/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.accversion;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.accversion.AddingAssistService;
import kd.fi.bd.enhance.treetask.AccountAddingAssistAdapter;
import kd.fi.bd.enhance.treetask.AccountContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.OrgAccOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class AssistAddingContext {
    private static final Log LOG = LogFactory.getLog(AssistAddingContext.class);
    private final AddingAssistService addingAssistService;
    private final BiTreeNode<Long, OrgVO> rootOrg;
    private final long rootAccountId;
    private final BiTreeNode<String, AccountVO> rootAccount;
    private DependBiTreeNode<AccountContext> rootTask;
    private final Long accountTableId;
    private final String rootAccountNumber;
    private final Date versionDate;
    private final List<AssistEntryVO> addingAssitList;
    private List<Long> useOrgIdList;
    private Map<Long, OrgAccOwnershipVO> orgAccNumberShip;
    private Set<Long> allAccountIdSet;
    private Set<Long> allCreateOrgAccountIdSet;
    private Map<Long, Map<String, Boolean>> orgIdAccountIncudeAssistMap;
    private Map<Long, DynamicObject> accountIdDynObjMap;
    private Map<Long, DynamicObject> orgIdDynObjMap;
    private Map<Long, DynamicObject> assistIdDynObjMap;
    private Table<Long, Long, Integer> orgIdAccountIdBizTable;
    private Map<String, List<DynamicObject>> periodMap;
    private Set<Long> periodTypeIds;

    public AssistAddingContext(long rootAccountId, long rootOrgId, long accountTableId, Date versionDate, List<AssistEntryVO> addingAssitList, AddingAssistService addingAssistService) {
        long masterId;
        long tick = System.currentTimeMillis();
        this.addingAssistService = addingAssistService;
        DynamicObject accountDyn = addingAssistService.queryAccountDynObj(rootAccountId, "number", "longnumber", "ctrlstrategy");
        boolean isShareCtrlStrategy = AccountVersionUtil.isShareCtrlStrategy(accountDyn);
        this.rootAccountNumber = accountDyn.getString("number");
        this.rootAccountId = masterId = BDUtil.getCurrOrgFirstMasterId(rootAccountId, rootOrgId, accountTableId, this.rootAccountNumber);
        this.accountTableId = accountTableId;
        this.versionDate = versionDate;
        this.addingAssitList = Collections.unmodifiableList(addingAssitList);
        this.rootOrg = addingAssistService.buildSubTreeByOrgId(10, rootOrgId);
        if (isShareCtrlStrategy) {
            this.useOrgIdList = new ArrayList<Long>(10);
            this.useOrgIdList.add(rootOrgId);
            List<BiTreeNode<Long, OrgVO>> childs = this.rootOrg.getChild();
            if (!childs.isEmpty()) {
                for (int i = childs.size() - 1; i >= 0; --i) {
                    childs.get(i).disconnectParent();
                }
            }
        } else {
            this.useOrgIdList = Collections.unmodifiableList(new ArrayList<Long>(this.rootOrg.collect(BiTreeNode::getId)));
        }
        this.rootAccount = addingAssistService.buildSubTreeByAccountNumber(accountTableId, this.rootAccountNumber, accountDyn.getString("longnumber"), this.useOrgIdList);
        this.initContext();
        LOG.info(String.format("assist_adding_context initialization on org: %s, account id: %s cost: %s", rootOrgId, rootAccountId, System.currentTimeMillis() - tick));
    }

    public final void initContext() {
        this.orgAccNumberShip = this.addingAssistService.getAllSubLatestAccountInfoInUseOrgRange(this.rootAccountId, this.useOrgIdList, this.versionDate);
        LOG.info(String.format("org_acc_number_ship init is : %s", this.orgAccNumberShip.values().stream().map(x -> x.getLogStr()).collect(Collectors.joining("\n"))));
        this.allAccountIdSet = this.orgAccNumberShip.values().stream().flatMap(x -> x.getAllAccIds().stream()).collect(Collectors.toSet());
        this.accountIdDynObjMap = this.addingAssistService.loadAccountIdDynObjMap(this.allAccountIdSet);
        this.allCreateOrgAccountIdSet = this.accountIdDynObjMap.values().stream().filter(x -> this.useOrgIdList.contains(x.getLong("createorg_id"))).map(x -> x.getLong("id")).collect(Collectors.toSet());
        this.orgIdDynObjMap = this.addingAssistService.loadOrgIdDynObjMap(this.useOrgIdList);
        Set<Long> assistIdSet = this.addingAssitList.stream().map(AssistEntryVO::getId).collect(Collectors.toSet());
        this.assistIdDynObjMap = this.addingAssistService.loadAssistIdDynObjMap(assistIdSet);
        this.orgIdAccountIncudeAssistMap = this.addingAssistService.isAccountIncludeAssist(this.orgAccNumberShip, this.addingAssitList);
        Map<Long, Set<Long>> orgAccountMap = this.orgAccNumberShip.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((OrgAccOwnershipVO)x.getValue()).getLatestAccIds()));
        this.orgIdAccountIdBizTable = this.addingAssistService.batchCheckAfterSpecificDate(orgAccountMap, this.versionDate);
        this.periodMap = new HashMap<String, List<DynamicObject>>(8);
        this.periodTypeIds = BDUtil.getPeriodType();
    }

    public final void initRootTask() {
        AccountAddingAssistAdapter adapter = new AccountAddingAssistAdapter();
        DependBiTreeNode rootTask = adapter.buildAccOrgTree(this.rootOrg, this.rootAccount, this);
        this.rootTask = rootTask;
    }

    public Optional<Long> tryGetAccountIdByOrgAndAccNum(long orgId, String accountNumber) {
        OrgAccOwnershipVO accOwnershipVO = this.getOrgAccNumberShip().get(orgId);
        if (Objects.isNull(accOwnershipVO)) {
            return Optional.empty();
        }
        Map<String, Long> accountNumberIdMap = accOwnershipVO.getNumberLatestAccId();
        Long accountId = accountNumberIdMap.get(accountNumber);
        if (Objects.isNull(accountId)) {
            return Optional.empty();
        }
        return Optional.of(accountId);
    }

    public Long getRootOrgId() {
        return this.rootOrg.getId();
    }

    public Long getRootAccountId() {
        return this.rootAccountId;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public String getRootAccountNumber() {
        return this.rootAccountNumber;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public List<AssistEntryVO> getAddingAssitList() {
        return this.addingAssitList;
    }

    public List<Long> getUseOrgIdList() {
        return this.useOrgIdList;
    }

    public void setUseOrgIdList(List<Long> useOrgIdList) {
        this.useOrgIdList = useOrgIdList;
    }

    public BiTreeNode<Long, OrgVO> getRootOrg() {
        return this.rootOrg;
    }

    public BiTreeNode<String, AccountVO> getRootAccount() {
        return this.rootAccount;
    }

    public Map<Long, OrgAccOwnershipVO> getOrgAccNumberShip() {
        return this.orgAccNumberShip;
    }

    public Set<Long> getAllAccountIdSet() {
        return this.allAccountIdSet;
    }

    public Set<Long> getAllCreateOrgAccountIdSet() {
        return this.allCreateOrgAccountIdSet;
    }

    public Map<Long, Map<String, Boolean>> getOrgIdAccountIncudeAssistMap() {
        return this.orgIdAccountIncudeAssistMap;
    }

    public Map<Long, DynamicObject> getAccountIdDynObjMap() {
        return this.accountIdDynObjMap;
    }

    public Map<Long, DynamicObject> getOrgIdDynObjMap() {
        return this.orgIdDynObjMap;
    }

    public Map<Long, DynamicObject> getAssistIdDynObjMap() {
        return this.assistIdDynObjMap;
    }

    public Table<Long, Long, Integer> getOrgIdAccountIdBizTable() {
        return this.orgIdAccountIdBizTable;
    }

    public DependBiTreeNode<AccountContext> getRootTask() {
        return this.rootTask;
    }

    public Map<String, List<DynamicObject>> getPeriodMap() {
        return this.periodMap;
    }

    public Set<Long> getPeriodTypeIds() {
        return this.periodTypeIds;
    }
}

