/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class AssignCtx
implements Serializable {
    private static final long serialVersionUID = -4687126589577748334L;
    private Long useOrgid;
    private List<Long> orgIds;
    private List<Long> dataIDs;
    private String ctrlstrategy;
    private Set<String> acctCheckErrMsg;
    private Long accountTableId;
    private Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap;
    private Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap;
    private Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMapToTopOrg;
    private Map<Long, String> orgNameMap = new HashMap<Long, String>(10);

    public Map<Long, String> getOrgNameMap() {
        return this.orgNameMap;
    }

    public AssignCtx(Long useOrgid, List<Long> orgIds, List<Long> dataIDs, String ctrlstrategy) {
        this.useOrgid = useOrgid;
        this.orgIds = orgIds;
        this.dataIDs = new ArrayList<Long>(dataIDs);
        this.ctrlstrategy = ctrlstrategy;
        this.assignOrgTreeNodeMap = new HashMap<Long, AssignOrgTreeNode>(orgIds.size());
        this.assignAcctountNumTreeNodeMap = new HashMap<String, AssignAccountNumTreeNode>(dataIDs.size());
        this.acctCheckErrMsg = new HashSet<String>(10);
        this.assignOrgTreeNodeMapToTopOrg = new HashMap<Long, AssignOrgTreeNode>(10);
        this.initOp();
        this.buildOrgNodes(orgIds);
        this.buildOrgNodesToTop(useOrgid);
        this.buildAccountNumNodes();
    }

    private void buildOrgNodesToTop(Long useOrgid) {
        this.recuBuildAssignOrgTreeNodeMapToTopOrg(useOrgid);
        this.assignOrgTreeNodeMapToTopOrg.putAll(this.assignOrgTreeNodeMap);
    }

    private void recuBuildAssignOrgTreeNodeMapToTopOrg(Long useOrgid) {
        QFilter f2 = new QFilter("view", "=", (Object)10);
        QFilter f3 = new QFilter("org", "=", (Object)useOrgid);
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent,enable,isfreeze", (QFilter[])new QFilter[]{f2, f3}, null);){
            for (Row row : dt) {
                Long orgId = row.getLong("org");
                Long parentOrgId = row.getLong("parent");
                AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                if (null == curorgNode) continue;
                curorgNode.setParentId(row.getLong("parent"));
                curorgNode.setEnable(row.getBoolean("enable"));
                curorgNode.setIsfreeze(row.getBoolean("isfreeze"));
                this.assignOrgTreeNodeMap.put(orgId, curorgNode);
                AssignOrgTreeNode parentOrgNode = this.assignOrgTreeNodeMap.computeIfAbsent(parentOrgId, k -> new AssignOrgTreeNode((Long)k));
                parentOrgNode.getChildIds().add(orgId);
                this.recuBuildAssignOrgTreeNodeMapToTopOrg(parentOrgId);
            }
        }
    }

    private void buildOrgNodes(List<Long> orgIds) {
        if (null == orgIds || orgIds.size() == 0) {
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u4e3a\u7a7a", (String)"AssignCtx_0", (String)"fi-bd-common", (Object[])new Object[0])});
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        DataSet dt = BatchProcessUtil.batchQueryDataSet(orgIds, k -> QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent,enable,isfreeze", (QFilter[])new QFilter[]{f2, new QFilter("org", "in", k)}, null));
        Object object = null;
        try {
            for (Row row : dt) {
                Long orgId = row.getLong("org");
                AssignOrgTreeNode curorgNode = this.assignOrgTreeNodeMap.get(orgId);
                if (null != curorgNode) continue;
                curorgNode = new AssignOrgTreeNode(orgId);
                curorgNode.setParentId(row.getLong("parent"));
                curorgNode.setEnable(row.getBoolean("enable"));
                curorgNode.setIsfreeze(row.getBoolean("isfreeze"));
                this.assignOrgTreeNodeMap.put(orgId, curorgNode);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dt != null) {
                if (object != null) {
                    try {
                        dt.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dt.close();
                }
            }
        }
        Set<Long> assignOrgIds = this.assignOrgTreeNodeMap.keySet();
        assignOrgIds = new HashSet<Long>(assignOrgIds);
        for (Long assignOrgId : assignOrgIds) {
            AssignOrgTreeNode curOrgNode = this.assignOrgTreeNodeMap.get(assignOrgId);
            Long parentOrgId = curOrgNode.getParentId();
            AssignOrgTreeNode parentOrgNode = this.assignOrgTreeNodeMap.computeIfAbsent(parentOrgId, k -> new AssignOrgTreeNode((Long)k));
            parentOrgNode.getChildIds().add(assignOrgId);
        }
    }

    private void initOp() {
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((Object)this.dataIDs.get(0), (String)"bd_accountview");
        this.accountTableId = accountObj.getLong("accounttable_id");
    }

    private void buildAccountNumNodes() {
        DynamicObject[] accts;
        HashSet<Long> pidSet = new HashSet<Long>(this.dataIDs.size());
        HashSet<Long> masteridSet = new HashSet<Long>(this.dataIDs.size());
        for (DynamicObject acct : accts = BusinessDataServiceHelper.load((Object[])this.dataIDs.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
            masteridSet.add(acct.getLong("masterid"));
            String number = acct.getString("number");
            AssignAccountNumTreeNode assignAccountNumTreeNode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(number, k -> new AssignAccountNumTreeNode((String)k));
            Object parent = acct.getParent();
            String pnumber = acct.getString("parent.number");
            if (!StringUtils.isNotEmpty((String)pnumber)) continue;
            assignAccountNumTreeNode.setPnumber(pnumber);
            AssignAccountNumTreeNode pnode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(pnumber, k -> new AssignAccountNumTreeNode((String)k));
            pnode.getChildNumbers().add(number);
            pidSet.add(acct.getLong("parent.id"));
        }
        if (pidSet.size() > 0) {
            this.fixAcctTreeDataComplete(new HashSet<Long>(this.dataIDs), pidSet, masteridSet);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("number", "in", this.assignAcctountNumTreeNodeMap.keySet()));
        try (DataSet ds = AccountUtils.queryAccountDataSet(this.useOrgid, this.accountTableId, "masterid", filters);){
            for (Object row : ds) {
                masteridSet.add(row.getLong("masterid"));
            }
        }
        filters.clear();
        filters.add(new QFilter("masterid", "in", masteridSet));
        ds = AccountUtils.queryAccountDataSet(this.useOrgid, this.accountTableId, "id,number,masterid,longnumber", filters);
        var6_8 = null;
        try {
            HashMap<Long, Map> demoMap = new HashMap<Long, Map>(16);
            for (Row row : ds) {
                demoMap.computeIfAbsent(row.getLong("masterid"), k -> new HashMap(16)).put(row.getString("longnumber"), row.getString("number"));
            }
            for (Map.Entry entry : demoMap.entrySet()) {
                Map value = (Map)entry.getValue();
                if (value.size() <= 1) continue;
                ArrayList longNumbers = new ArrayList(value.keySet());
                longNumbers.sort(Comparator.comparingInt(String::length));
                for (int i = 0; i < longNumbers.size(); ++i) {
                    String longNumberNt = (String)longNumbers.get(i);
                    String numberNt = (String)value.get(longNumberNt);
                    AssignAccountNumTreeNode node = this.assignAcctountNumTreeNodeMap.computeIfAbsent(numberNt, k -> new AssignAccountNumTreeNode((String)k));
                    if (i <= 0) continue;
                    String longPnumberNt = (String)longNumbers.get(i - 1);
                    String pnumberNt = (String)value.get(longPnumberNt);
                    node.setPnumber(pnumberNt);
                    AssignAccountNumTreeNode pnode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(pnumberNt, k -> new AssignAccountNumTreeNode((String)k));
                    pnode.getChildNumbers().add(numberNt);
                }
            }
        }
        catch (Throwable demoMap) {
            var6_8 = demoMap;
            throw demoMap;
        }
        finally {
            if (ds != null) {
                if (var6_8 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable demoMap) {
                        var6_8.addSuppressed(demoMap);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Set<Map.Entry<String, AssignAccountNumTreeNode>> entries = this.assignAcctountNumTreeNodeMap.entrySet();
        for (Map.Entry<String, AssignAccountNumTreeNode> treeNodeEntry : entries) {
            AssignAccountNumTreeNode node = treeNodeEntry.getValue();
            String string = node.getPnumber();
            if (!StringUtils.isNotEmpty((String)string)) continue;
            AssignAccountNumTreeNode parentOrgNode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(string, k -> new AssignAccountNumTreeNode((String)k));
            parentOrgNode.getChildNumbers().add(treeNodeEntry.getKey());
        }
    }

    private void fixAcctTreeDataComplete(Set<Long> dataIDs, Set<Long> pidSet, Set<Long> masteridSet) {
        DynamicObject[] accts = BusinessDataServiceHelper.load((Object[])pidSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        pidSet.clear();
        for (DynamicObject acct : accts) {
            String number = acct.getString("number");
            dataIDs.add((Long)acct.getPkValue());
            masteridSet.add(acct.getLong("masterid"));
            if (acct.getLong("parent.id") != 0L) {
                pidSet.add(acct.getLong("parent.id"));
            }
            AssignAccountNumTreeNode node = this.assignAcctountNumTreeNodeMap.get(number);
            String pnumber = acct.getString("parent.number");
            if (!StringUtils.isNotEmpty((String)pnumber)) continue;
            node.setPnumber(pnumber);
            AssignAccountNumTreeNode pnode = this.assignAcctountNumTreeNodeMap.computeIfAbsent(pnumber, k -> new AssignAccountNumTreeNode((String)k));
            pnode.getChildNumbers().add(number);
        }
        if (pidSet.size() > 0) {
            this.fixAcctTreeDataComplete(dataIDs, pidSet, masteridSet);
        }
    }

    public Long getUseOrgid() {
        return this.useOrgid;
    }

    public void setUseOrgid(Long useOrgid) {
        this.useOrgid = useOrgid;
    }

    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public List<Long> getDataIDs() {
        return this.dataIDs;
    }

    public void setDataIDs(List<Long> dataIDs) {
        this.dataIDs = dataIDs;
    }

    public String getCtrlstrategy() {
        return this.ctrlstrategy;
    }

    public void setCtrlstrategy(String ctrlstrategy) {
        this.ctrlstrategy = ctrlstrategy;
    }

    public Map<Long, AssignOrgTreeNode> getAssignOrgTreeNodeMap() {
        return this.assignOrgTreeNodeMap;
    }

    public void setAssignOrgTreeNodeMap(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        this.assignOrgTreeNodeMap = assignOrgTreeNodeMap;
    }

    public Map<String, AssignAccountNumTreeNode> getAssignAcctountNumTreeNodeMap() {
        return this.assignAcctountNumTreeNodeMap;
    }

    public void setAssignAcctountNumTreeNodeMap(Map<String, AssignAccountNumTreeNode> assignAcctountNumTreeNodeMap) {
        this.assignAcctountNumTreeNodeMap = assignAcctountNumTreeNodeMap;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public Set<String> getAcctCheckErrMsg() {
        return this.acctCheckErrMsg;
    }

    public void setAcctCheckErrMsg(Set<String> acctCheckErrMsg) {
        this.acctCheckErrMsg = acctCheckErrMsg;
    }

    public Map<Long, AssignOrgTreeNode> getAssignOrgTreeNodeMapToTopOrg() {
        return this.assignOrgTreeNodeMapToTopOrg;
    }

    public void setAssignOrgTreeNodeMapToTopOrg(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMapToTopOrg) {
        this.assignOrgTreeNodeMapToTopOrg = assignOrgTreeNodeMapToTopOrg;
    }
}

