/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceExcutor;
import kd.fi.bd.assign.AssignCtx;
import kd.fi.bd.assign.AssignHandle;
import kd.fi.bd.assign.AssignResult;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.interfaces.service.IAccountAssignService;
import kd.fi.bd.util.AccountVersionUtil;

public class AssignServiceHelper {
    private static Log logger = LogFactory.getLog(AssignServiceHelper.class);
    public static final String defaultctrlstrategy_entityID = "bd_bddefctrlstrtgy";
    public static final String baseDataUseRegSuffix = "UseReg";
    public static final String entityID_basedataview = "bd_basedataview";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";

    public Map<Long, List<Long>> batchAssign(String entityID, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs) {
        ORM orm = ORM.create();
        DynamicObjectCollection col = orm.query(entityID, "id, masterid, createorg, org, ctrlstrategy", new QFilter[]{new QFilter("id", "in", dataIDs)});
        ArrayList<Object[]> saveParamsList = new ArrayList<Object[]>();
        ArrayList<Object[]> saveParamsListSub = new ArrayList<Object[]>();
        HashMap<Long, List<Long>> assignCheckRes = new HashMap<Long, List<Long>>();
        DynamicObject ctrlview = this.getCtrlview(entityID);
        if (null == ctrlview) {
            throw new NullPointerException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%s\u5bf9\u5e94\u7684\u63a7\u5236\u89c6\u56fe", (String)"AssignServiceHelper_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), entityID));
        }
        HashMap<Long, List<Long>> subordinateOrgsMap = new HashMap<Long, List<Long>>(orgIDs.size());
        for (Long l : orgIDs) {
            List<Long> subordinateOrgList = AssignServiceHelper.getDirectSubordinateOrgList((Long)ctrlview.getPkValue(), l);
            subordinateOrgsMap.put(l, subordinateOrgList);
        }
        HashSet orgs = new HashSet();
        for (DynamicObject dataInfo : col) {
            String ctrlStrategy = dataInfo.getString("ctrlstrategy");
            Long createOrgId = dataInfo.getLong("createorg");
            Long adminOrgId = dataInfo.getLong("org");
            Long dataId = (Long)dataInfo.getPkValue();
            HashSet<Long> allUseOrgSet = new HashSet<Long>();
            List assignCheckOrgs = (List)assignCheckRes.get(dataId);
            assignCheckOrgs = null == assignCheckOrgs ? new ArrayList(10) : assignCheckOrgs;
            for (Long orgId : orgIDs) {
                if (assignCheckOrgs.size() > 0 && assignCheckOrgs.contains(orgId)) continue;
                allUseOrgSet.add(orgId);
                Object[] saveParams = new Object[]{orgId, dataId, createOrgId, adminOrgId, ctrlStrategy, assignOrgID, orgId, dataId};
                saveParamsList.add(saveParams);
                List subordinateOrgList = (List)subordinateOrgsMap.get(orgId);
                HashSet<Long> useOrgSet = new HashSet<Long>();
                for (Long useOrgID : subordinateOrgList) {
                    if (useOrgID.equals(createOrgId) || orgIDs.contains(useOrgID)) continue;
                    useOrgSet.add(useOrgID);
                }
                for (Long useOrgID : useOrgSet) {
                    if (allUseOrgSet.contains(useOrgID)) continue;
                    saveParams = new Object[]{useOrgID, dataId, createOrgId, adminOrgId, ctrlStrategy, assignOrgID, useOrgID, dataId};
                    saveParamsListSub.add(saveParams);
                }
                allUseOrgSet.addAll(useOrgSet);
                orgs.addAll(allUseOrgSet);
            }
        }
        String string = ORM.create().getDataEntityType(entityID).getAlias();
        String dbRouteKey = ORM.create().getDataEntityType(entityID).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String bsaeDataUseRegTableName = string + baseDataUseRegSuffix;
        String insertSql = " insert into " + bsaeDataUseRegTableName + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign,FAssignOrgID)  (SELECT TOP 1 ?, ?, ?, ?, ?,'1',?  FROM dual WHERE NOT EXISTS (SELECT 1 FROM " + bsaeDataUseRegTableName + " WHERE fuseorgid = ? AND FDataID = ?)) ";
        String insertSubSql = " insert into " + bsaeDataUseRegTableName + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign,FAssignOrgID)  (SELECT TOP 1 ?, ?, ?, ?, ?,'0',?  FROM dual WHERE NOT EXISTS (SELECT 1 FROM " + bsaeDataUseRegTableName + " WHERE fuseorgid = ? AND FDataID = ?)) ";
        try (TXHandle h = TX.required();){
            if (saveParamsList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertSql, saveParamsList);
            }
            if (saveParamsListSub.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertSubSql, saveParamsListSub);
            }
        }
        BaseDataCtrlCache.clearBaseDataUseRange((String)entityID, orgs);
        BaseDataCtrlCache.clearBaseDataFilter((String)entityID, orgs);
        return assignCheckRes;
    }

    private static List<Long> getDirectSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        ORM ormOV = ORM.create();
        ArrayList<Long> directSubOrgIds = new ArrayList<Long>();
        boolean isctrlunit = false;
        QFilter f2 = new QFilter("view.id", "=", (Object)orgViewId);
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)isctrlunit);
        QFilter f4 = new QFilter("parent.id", "=", (Object)parentOrgId);
        QFilter f5 = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter f6 = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), ENTITYID_ORG_STRUCTURE, "org.id", new QFilter[]{f2, f3, f4, f5, f6});){
            for (Row row : ds) {
                if (row.getLong("org.id") == null) continue;
                directSubOrgIds.add(row.getLong("org.id"));
            }
        }
        ArrayList<Long> allSubOrgIds = new ArrayList<Long>();
        List<Long> subOrgIds = AssignServiceHelper.getAllSubordinateOrgs(orgViewId, directSubOrgIds, Boolean.TRUE, isctrlunit);
        allSubOrgIds.addAll(directSubOrgIds);
        allSubOrgIds.addAll(subOrgIds);
        allSubOrgIds.add(parentOrgId);
        return allSubOrgIds;
    }

    private static List<Long> getAllSubordinateOrgs(Long orgViewId, List<Long> directSubOrgIds, boolean b, boolean isctrlunit) {
        QFilter orgFilter = new QFilter("org", "in", directSubOrgIds);
        QFilter viewFilter = new QFilter("view", "=", (Object)orgViewId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter statusFilter = new QFilter("org.status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter isctrlunitFilter = new QFilter("isctrlunit", "=", (Object)isctrlunit);
        QFilter[] filters = new QFilter[]{orgFilter, freezeFilter, statusFilter, enableFilter, viewFilter, isctrlunitFilter};
        String parentLongNumber = null;
        ArrayList<String> parentLongnumberList = new ArrayList<String>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.servicehelper.org.OrgUnitServiceHelper.getAllSubordinateOrgs", (String)ENTITYID_ORG_STRUCTURE, (String)"longnumber", (QFilter[])filters, (String)"longnumber");
        Object object = null;
        try {
            for (Row row : dataSet) {
                String longnumber = row.getString("longnumber");
                if (StringUtils.isBlank((CharSequence)longnumber) || parentLongNumber != null && longnumber.startsWith(parentLongNumber)) continue;
                parentLongNumber = longnumber + "!";
                parentLongnumberList.add(parentLongNumber);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashSet<Long> childOrgIds = new HashSet<Long>();
        for (String longnumber : parentLongnumberList) {
            QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "%"));
            filters = new QFilter[]{longnumberFilter, freezeFilter, statusFilter, enableFilter, viewFilter, isctrlunitFilter};
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"kd.bos.servicehelper.org.OrgUnitServiceHelper.getAllSubordinateOrgs.longnumber", (String)ENTITYID_ORG_STRUCTURE, (String)"org", (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                for (Row row : dataSet2) {
                    childOrgIds.add(row.getLong("org"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet2 == null) continue;
                if (throwable != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet2.close();
            }
        }
        return new ArrayList<Long>(childOrgIds);
    }

    public DynamicObject getCtrlview(String entityID) {
        DynamicObject ctrlview = null;
        DynamicObject[] basedataview = BusinessDataServiceHelper.load((String)entityID_basedataview, (String)"ctrlview.treetype", (QFilter[])new QFilter[]{new QFilter("basedata", "=", (Object)entityID)});
        if (null == basedataview || basedataview.length == 0) {
            DynamicObject[] defaultctrlstrategy = BusinessDataServiceHelper.load((String)defaultctrlstrategy_entityID, (String)"ctrlview.treetype", (QFilter[])new QFilter[]{new QFilter("basedataid", "=", (Object)entityID)});
            if (null != defaultctrlstrategy && defaultctrlstrategy.length > 0) {
                ctrlview = defaultctrlstrategy[0].getDynamicObject("ctrlview");
            }
        } else {
            ctrlview = basedataview[0].getDynamicObject("ctrlview");
        }
        return ctrlview;
    }

    public IBaseDataCtrlPlugin getBaseDataCtrlPlugin(String entityType) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin = null;
        String baseDataCtrlPluginStr = BaseDataCtrlCache.getBaseDataCtrlPlugin((String)entityType);
        if (!StringUtils.isEmpty((CharSequence)baseDataCtrlPluginStr)) {
            if ("DATA_LOADED".equals(baseDataCtrlPluginStr)) {
                baseDataCtrlPlugin = null;
                return baseDataCtrlPlugin;
            }
            try {
                baseDataCtrlPlugin = (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return baseDataCtrlPlugin;
        }
        String selectPro = "plugin";
        QFilter[] qf = new QFilter[]{new QFilter("basedataid", "=", (Object)entityType)};
        DynamicObjectCollection defStrgyCol = QueryServiceHelper.query((String)defaultctrlstrategy_entityID, (String)selectPro, (QFilter[])qf);
        if (defStrgyCol != null && defStrgyCol.size() > 0 && !StringUtils.isEmpty((CharSequence)((DynamicObject)defStrgyCol.get(0)).getString("plugin"))) {
            baseDataCtrlPluginStr = ((DynamicObject)defStrgyCol.get(0)).getString("plugin");
            BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
            try {
                baseDataCtrlPlugin = (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return baseDataCtrlPlugin;
        }
        baseDataCtrlPluginStr = "DATA_LOADED";
        BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
        return baseDataCtrlPlugin;
    }

    public static void trans2LeafAccount(Set<Long> accountIds, Long[] orgIds, Map<Long, Long> orgPorgs) {
        Map accounts = BusinessDataServiceHelper.loadFromCache((Object[])accountIds.toArray(), (String)"bd_accountview");
        HashMap<Long, AccountTableRef> tabRefs = new HashMap<Long, AccountTableRef>();
        Map<Long, Map<Long, DynamicObject>> accPairMap = AssignServiceHelper.getAccountPairs(accounts);
        for (Map.Entry<Long, Map<Long, DynamicObject>> en : accPairMap.entrySet()) {
            Long[] at = en.getKey();
            AccountTableRef accRef = tabRefs.computeIfAbsent((Long)at, arg_0 -> AssignServiceHelper.lambda$trans2LeafAccount$0((Long)at, arg_0));
            for (Map.Entry<Long, DynamicObject> entry : en.getValue().entrySet()) {
                accRef.getAccountRef().addAccountRef(entry.getValue().getLong("id"), entry.getKey(), AssignServiceHelper.getAsstActItemMap(entry.getValue()));
            }
        }
        Date versionDate = AccountVersionUtil.getStartDate();
        HashSet<Long> useOrgIds = new HashSet<Long>();
        for (Long orgId : orgIds) {
            if (orgPorgs.get(orgId) != null) continue;
            useOrgIds.add(orgId);
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        if (!useOrgIds.isEmpty()) {
            QFilter f3 = new QFilter("org", "in", useOrgIds);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)ENTITYID_ORG_STRUCTURE, (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
                for (Row row : dt) {
                    orgPorgs.put(row.getLong("org"), row.getLong("parent"));
                }
            }
        }
        Long[] f3 = orgIds;
        int n = f3.length;
        for (int i = 0; i < n; ++i) {
            long orgId = f3[i];
            List<Long> cid = AssignServiceHelper.getLeafs((DynamicObject)accounts.values().iterator().next(), orgId);
            try (TXHandle handle = TX.requiresNew();){
                try {
                    ArrayList<Object[]> useRegParam = new ArrayList<Object[]>(accounts.size());
                    for (DynamicObject account : accounts.values()) {
                        String ctrlstrategy = account.getString("ctrlstrategy");
                        Long createOrgId = account.getLong("createorg_id");
                        if ("1".equals(ctrlstrategy) || "3".equals(ctrlstrategy)) {
                            Long assignOrgId = orgPorgs.get(orgId);
                            useRegParam.add(new Object[]{orgId, account.getLong("id"), createOrgId, createOrgId, ctrlstrategy, "1", assignOrgId == null ? createOrgId : assignOrgId});
                            continue;
                        }
                        useRegParam.add(new Object[]{orgId, account.getLong("id"), createOrgId, createOrgId, ctrlstrategy, "1", createOrgId});
                    }
                    AccountVersionUtil.doAssign(null, useRegParam);
                    if (cid.size() == 1) {
                        for (AccountTableRef tabRef : tabRefs.values()) {
                            AccountTableRefServiceExcutor.getInstance().excuteEnableService(orgId, versionDate, tabRef, false);
                        }
                    }
                }
                catch (Exception ex) {
                    handle.markRollback();
                    throw ex;
                }
            }
            if (cid.size() != 1) continue;
            for (AccountTableRef tabRef : tabRefs.values()) {
                AccountTableRefServiceExcutor.getInstance().excuteNonTxService(orgId, versionDate, tabRef, "enable");
            }
        }
        HashSet<Long> orgIdsSet = new HashSet<Long>(orgIds.length);
        for (Long orgId : orgIds) {
            orgIdsSet.add(orgId);
        }
        AccountVersionUtil.clearBaseDataCache(false, orgIdsSet);
    }

    private static Map<Long, Map<Long, DynamicObject>> getAccountPairs(Map<Object, DynamicObject> accounts) {
        LinkedHashMap<Long, TreeNode> accMap = new LinkedHashMap<Long, TreeNode>(accounts.size());
        for (DynamicObject dynamicObject : accounts.values()) {
            accMap.put(dynamicObject.getLong("id"), new TreeNode(dynamicObject));
        }
        ArrayList<TreeNode> accTrees = new ArrayList<TreeNode>(10);
        for (Map.Entry entry : accMap.entrySet()) {
            TreeNode acc = (TreeNode)entry.getValue();
            DynamicObject p = acc.data.getDynamicObject("parent");
            if (p == null) continue;
            TreeNode pAcc = (TreeNode)accMap.get(p.getLong("id"));
            if (pAcc != null) {
                pAcc.children.add(acc);
                continue;
            }
            accTrees.add(acc);
        }
        HashMap<Long, Map<Long, DynamicObject>> hashMap = new HashMap<Long, Map<Long, DynamicObject>>();
        for (TreeNode acc : accTrees) {
            DynamicObject leafAccount = AssignServiceHelper.getFirstLeafAccount(acc);
            if (!leafAccount.getBoolean("isleaf")) continue;
            Map accp = hashMap.computeIfAbsent(leafAccount.getLong("accounttable_id"), key -> new HashMap());
            accp.put(acc.data.getLong("parent_id"), leafAccount);
        }
        return hashMap;
    }

    private static DynamicObject getFirstLeafAccount(TreeNode node) {
        List children = node.children;
        if (children.isEmpty()) {
            return node.data;
        }
        return AssignServiceHelper.getFirstLeafAccount((TreeNode)children.get(0));
    }

    private static Map<String, Object> getAsstActItemMap(DynamicObject obj) {
        DynamicObjectCollection entry = obj.getDynamicObjectCollection("checkitementry");
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        for (DynamicObject row : entry) {
            DynamicObject item = row.getDynamicObject("asstactitem");
            String defaultvalue = row.getString("defaulid");
            if (item == null || StringUtils.isEmpty((CharSequence)defaultvalue)) continue;
            Object value = defaultvalue;
            if (!"3".equals(item.getString("valuetype"))) {
                value = Long.parseLong(String.valueOf(defaultvalue));
            }
            result.put(item.getString("flexfield"), value);
        }
        return result;
    }

    public static List<Long> getLeafs(DynamicObject successSaveAcct, long createOrgId) {
        ArrayList<Long> pid = new ArrayList<Long>(10);
        ArrayList<Long> cid = new ArrayList<Long>(10);
        String useRegSqlOPVER = " select reg.FUSEORGID FUSEORGID, reg.FDATAID FDATAID, acct.fmasterid fmasterid,acct.FNUMBER  from T_BD_AccountUseReg reg  left join t_bd_account acct on reg.FDATAID = acct.fparentid  where acct.faccounttableid = " + successSaveAcct.getLong("accounttable_id") + " and reg.fuseorgid = " + createOrgId + " and acct.fid = " + successSaveAcct.getLong("org_id") + " and acct.fenddate= ?";
        Object[] params = new Object[]{AccountVersionUtil.getEndDate()};
        try (DataSet dataSet = DB.queryDataSet((String)"AssignServiceHelper", (DBRoute)DBRoute.of((String)"gl"), (String)useRegSqlOPVER, (Object[])params);){
            for (Row row : dataSet) {
                pid.add(row.getLong("FDATAID"));
            }
        }
        if (pid.size() > 0) {
            String useRegSql = " select reg.fdataid fdataid, reg.fuseorgid fuseorgid, acct.fmasterid fmasterid  from T_BD_AccountUseReg reg  left join t_bd_account acct on reg.FDATAID = acct.fid  where reg.fuseorgid " + createOrgId + " and acct.fisleaf = '1'  and acct.fparentid = " + pid.get(0) + " and acct.fenddate= ?";
            DataSet dataSet = DB.queryDataSet((String)"AssignServiceHelper", (DBRoute)DBRoute.of((String)"gl"), (String)useRegSql, (Object[])params);
            Object object = null;
            try {
                for (Row row : dataSet) {
                    cid.add(row.getLong("fdataid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        return cid;
    }

    public static void assignAllOldVersionAccts(Long accountId, Long assignorgId, Long useOrgId, Map<Long, Long> orgPorgs) {
        Throwable row5;
        Throwable throwable;
        DataSet dt;
        Object row22;
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)"bd_accountview");
        String number = accountObj.getString("number");
        long accountTableId = accountObj.getDynamicObject("accounttable").getLong("id");
        ArrayList<Long> dataIds = new ArrayList<Long>(10);
        String useRegSqlByNumber = " select reg.fdataid fdataid, reg.fuseorgid fuseorgid, acct.fmasterid fmasterid  from T_BD_AccountUseReg reg  left join t_bd_account acct on reg.FDATAID = acct.fid  where reg.fuseorgid = " + assignorgId + " and acct.fnumber = '" + number + "' and acct.faccounttableid = " + accountTableId;
        try (DataSet dataSet = DB.queryDataSet((String)"assignAllOldVersionAccts", (DBRoute)DBRoute.of((String)"gl"), (String)useRegSqlByNumber);){
            for (Object row22 : dataSet) {
                Long fdataid = row22.getLong("fdataid");
                dataIds.add(fdataid);
            }
        }
        ArrayList<Long> excdataIds = new ArrayList<Long>(10);
        String excdataSql = "select exc.fdataid fdataid from t_bd_accountexc exc left join t_bd_account acct on exc.fdataid=acct.fid where exc.fuseorgid= " + assignorgId + " and acct.fnumber='" + number + "' and acct.faccounttableid = " + accountTableId;
        DataSet dataSet = DB.queryDataSet((String)"assignAllOldVersionAccts", (DBRoute)DBRoute.of((String)"gl"), (String)excdataSql);
        row22 = null;
        try {
            for (Row row3 : dataSet) {
                Long fdataid = row3.getLong("fdataid");
                excdataIds.add(fdataid);
            }
        }
        catch (Throwable fdataid) {
            row22 = fdataid;
            throw fdataid;
        }
        finally {
            if (dataSet != null) {
                if (row22 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable fdataid) {
                        ((Throwable)row22).addSuppressed(fdataid);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Long> useDataIds = new ArrayList<Long>(10);
        ArrayList<Long> excDataIds = new ArrayList<Long>(10);
        if (!dataIds.isEmpty()) {
            ArrayList<Long> useParameters = new ArrayList<Long>(10);
            useParameters.add(useOrgId);
            StringBuilder useRegSql = new StringBuilder();
            useRegSql.append("select reg.fdataid fdataid, reg.fuseorgid fuseorgid  from t_bd_accountusereg reg  ");
            useRegSql.append(" where reg.fuseorgid = ? ");
            useRegSql.append(" and reg.fdataid in ( ");
            dataIds.forEach(obj -> useRegSql.append("?,"));
            useRegSql.deleteCharAt(useRegSql.length() - 1).append(" )");
            useParameters.addAll(dataIds);
            dt = DB.queryDataSet((String)"checkIsAssign", (DBRoute)DBRoute.of((String)"gl"), (String)useRegSql.toString(), (Object[])useParameters.toArray());
            throwable = null;
            try {
                row5 = null;
                while (dt.hasNext()) {
                    row5 = dt.next();
                    useDataIds.add(row5.getLong("fdataid"));
                }
            }
            catch (Throwable row4) {
                throwable = row4;
                throw row4;
            }
            finally {
                if (dt != null) {
                    if (throwable != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable row4) {
                            throwable.addSuppressed(row4);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            dataIds.removeIf(dataid -> accountId.compareTo((Long)dataid) == 0);
            dataIds.removeIf(dataid -> excdataIds.contains(dataid));
            dataIds.removeIf(dataid -> useDataIds.contains(dataid));
        }
        if (!dataIds.isEmpty()) {
            ArrayList<Long> excParameters = new ArrayList<Long>(10);
            excParameters.add(assignorgId);
            StringBuilder excSql = new StringBuilder();
            excSql.append("select exc.fdataid fdataid, exc.fuseorgid fuseorgid  ");
            excSql.append(" from t_bd_accountexc exc  ");
            excSql.append(" where exc.fuseorgid = ? ");
            excSql.append(" and exc.fdataid in ( ");
            dataIds.forEach(dataId -> excSql.append("?,"));
            excSql.deleteCharAt(excSql.length() - 1).append(")");
            excParameters.addAll(dataIds);
            dt = DB.queryDataSet((String)"checkIsAssign", (DBRoute)DBRoute.of((String)"gl"), (String)excSql.toString(), (Object[])excParameters.toArray());
            throwable = null;
            try {
                row5 = null;
                while (dt.hasNext()) {
                    row5 = dt.next();
                    excDataIds.add(row5.getLong("fdataid"));
                }
            }
            catch (Throwable row5) {
                throwable = row5;
                throw row5;
            }
            finally {
                if (dt != null) {
                    if (throwable != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable row5) {
                            throwable.addSuppressed(row5);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
        }
        HashSet<Long> useOrgIds = new HashSet<Long>();
        if (orgPorgs.get(useOrgId) == null) {
            useOrgIds.add(useOrgId);
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        if (!useOrgIds.isEmpty()) {
            QFilter f3 = new QFilter("org", "in", useOrgIds);
            row5 = null;
            try (DataSet dt2 = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)ENTITYID_ORG_STRUCTURE, (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
                for (Row row6 : dt2) {
                    orgPorgs.put(row6.getLong("org"), row6.getLong("parent"));
                }
            }
            catch (Throwable throwable2) {
                row5 = throwable2;
                throw throwable2;
            }
        }
        ArrayList<Object[]> useRegParam = new ArrayList<Object[]>(1);
        ArrayList<Object[]> excParams = new ArrayList<Object[]>(1);
        DynamicObject[] accountObjs = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashSet<String> excParamsKey = new HashSet<String>(accountObjs.length);
        HashSet<String> upParamsKey = new HashSet<String>(accountObjs.length);
        for (DynamicObject account : accountObjs) {
            Object[] uparam;
            String ctrlstrategy;
            Long createOrgId = account.getLong("createorg_id");
            long dataId2 = account.getLong("id");
            Object[] exeParam = new Object[]{dataId2, createOrgId, useOrgId};
            String excKey = StringUtils.join((Object[])new Object[]{dataId2, createOrgId, useOrgId}, (String)"-");
            if (excDataIds.contains(dataId2) && excParamsKey.add(excKey)) {
                excParams.add(exeParam);
            }
            if ("1".equals(ctrlstrategy = account.getString("ctrlstrategy")) || "3".equals(ctrlstrategy)) {
                Long assignOrgId = orgPorgs.get(useOrgId);
                uparam = new Object[]{useOrgId, account.getLong("id"), createOrgId, createOrgId, ctrlstrategy, "1", assignOrgId == null ? createOrgId : assignOrgId};
            } else {
                uparam = new Object[]{useOrgId, account.getLong("id"), createOrgId, createOrgId, ctrlstrategy, "1", createOrgId};
            }
            String upKey = StringUtils.join((Object[])new Object[]{dataId2, useOrgId}, (String)"-");
            if (!upParamsKey.add(upKey)) continue;
            useRegParam.add(uparam);
        }
        AccountVersionUtil.doAssign(excParams, useRegParam);
    }

    public static AssignResult assign(Long assignOrgId, List<Long> useOrgs, Long accId, String ctrlstrategy) {
        return AssignServiceHelper.assign(assignOrgId, useOrgs, Collections.singletonList(accId), ctrlstrategy);
    }

    public static AssignResult assign(Long assignOrgId, List<Long> useOrgs, List<Long> accIds, String ctrlstrategy) {
        AssignResult assignResult;
        AssignCtx ctx = new AssignCtx(assignOrgId, useOrgs, accIds, ctrlstrategy);
        if (AccountVersionUtil.isUseNewAssignMethodSystemProperty()) {
            IAccountAssignService accountAssignService = (IAccountAssignService)BDGLServiceFactory.getService("IAccountAssignService");
            assignResult = accountAssignService.doAssign(assignOrgId, useOrgs, accIds);
        } else {
            assignResult = new AssignHandle(ctx, null).handle();
        }
        return assignResult;
    }

    private static /* synthetic */ AccountTableRef lambda$trans2LeafAccount$0(Long at, Long key) {
        return new AccountTableRef(at, at, new AccountRef());
    }

    private static class TreeNode {
        private DynamicObject data;
        private List<TreeNode> children = new ArrayList<TreeNode>(3);

        TreeNode(DynamicObject data) {
            this.data = data;
        }
    }
}

