/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assign;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;

public class OpLogHelper {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void addOperateLog(IFormView formView, long orgId, String opKeyWord, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... param) {
        String appNumber = formView.getFormShowParameter().getAppId();
        String appId = this.getAppId(appNumber);
        RequestContext requestContext = RequestContext.get();
        OpLogAppInfo info = new OpLogAppInfo();
        info.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        info.setBizAppID(appId);
        info.setBizObjID(formView.getEntityId());
        info.setOrgID(Long.valueOf(orgId != 0L ? orgId : requestContext.getOrgId()));
        info.setOpTime(TimeServiceHelper.now());
        info.setClientType(requestContext.getClient());
        info.setClientIP(requestContext.getLoginIP());
        info.setKeyWord(opKeyWord);
        info.setOpName(opKey, opNameBridge);
        info.setOpDesc(opDescBridge, param);
        this.addOperateLog((AppLogInfo)info);
    }

    private String getAppId(String appNumber) {
        AppInfo appInfo;
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        return appId;
    }

    public void addOperateLog(AppLogInfo appLogInfo) {
        this.logService.addLog(appLogInfo);
    }

    public void addBatchOperateLog(List<AppLogInfo> appLogInfoList) {
        this.logService.addBatchLog(appLogInfoList);
    }
}

