/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.assignv2;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefServiceParam;
import kd.fi.bd.assign.AssignAccountNumTreeNode;
import kd.fi.bd.assign.AssignCtx;
import kd.fi.bd.assign.AssignServiceHelper;
import kd.fi.bd.assign.CloneUtilFactory;
import kd.fi.bd.assignv2.OrgAcctParent;
import kd.fi.bd.assignv2.OrgSingleAssignCtx;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.AssignOrgTreeNode;

public class AssignTask
implements Callable<Object> {
    private static final Log logger = LogFactory.getLog(AssignTask.class);
    private AssignCtx ctx;
    private long useOrgId;
    private Queue<Future> futures;

    public AssignTask(AssignCtx ctx, Long useOrgId, Queue<Future> futures) {
        this.useOrgId = useOrgId;
        this.ctx = ctx;
        this.futures = futures;
    }

    @Override
    public Object call() throws Exception {
        Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap = this.ctx.getAssignOrgTreeNodeMap();
        AssignOrgTreeNode assignOrgTreeNode = assignOrgTreeNodeMap.get(this.useOrgId);
        long parentId = assignOrgTreeNode.getParentId();
        OrgSingleAssignCtx sourceOrgSingleAssignCtx = new OrgSingleAssignCtx(this.ctx);
        sourceOrgSingleAssignCtx.setUseOrgid(parentId);
        this.buildOrgAcctParentAndOtherParentsAssign(sourceOrgSingleAssignCtx);
        this.buildOrgAcctParents(sourceOrgSingleAssignCtx);
        this.personalizedAccountOnOuterOrg(sourceOrgSingleAssignCtx);
        this.processExplain(assignOrgTreeNodeMap, parentId);
        String requestId = RequestContext.getOrCreate().getRequestId();
        RequestContext.getOrCreate().setRequestId(requestId);
        OrgSingleAssignCtx targetOrgSingleAssignCtx = new OrgSingleAssignCtx(this.ctx);
        targetOrgSingleAssignCtx.setUseOrgid(this.useOrgId);
        this.buildOrgAcctParentAndOtherParentsAssign(targetOrgSingleAssignCtx);
        this.buildOrgAcctParents(targetOrgSingleAssignCtx);
        this.personalizedAccountOnOuterOrg(targetOrgSingleAssignCtx);
        this.removeAlreadyAssignAcctId(sourceOrgSingleAssignCtx, targetOrgSingleAssignCtx);
        this.checkAssignOrgCreateSameAcctByNum(sourceOrgSingleAssignCtx, targetOrgSingleAssignCtx);
        this.makeAssignExcuter(sourceOrgSingleAssignCtx, targetOrgSingleAssignCtx);
        Set<Long> childIds = assignOrgTreeNode.getChildIds();
        if (childIds != null && childIds.size() > 0) {
            this.processExplain(assignOrgTreeNodeMap, this.useOrgId);
            for (Long childId : childIds) {
                Future future = ThreadService.submit((Callable)new AssignTask(this.ctx, childId, this.futures), (TaskType)TaskType.FIBD_ACCOUNT_ASSIGN_TASK);
                this.futures.add(future);
            }
        }
        return this.useOrgId;
    }

    private void personalizedAccountOnOuterOrg(OrgSingleAssignCtx orgSingleAssignCtx) {
        Long useOrgid = orgSingleAssignCtx.getUseOrgid();
        if (DebugTrace.enable()) {
            logger.info("personalizedAccountOnOuterOrg_orgid:{} process start", (Object)useOrgid);
        }
        List<Long> superiorOrgIds = BDUtil.getAllSuperiorOrgIds(useOrgid, true);
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = orgSingleAssignCtx.getAssignCtx().getAssignAcctountNumTreeNodeMap();
        ArrayList<String> accountNumbers = new ArrayList<String>(10);
        for (Map.Entry<String, AssignAccountNumTreeNode> x : accountNumTreeNodeMap.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)x.getValue().getPnumber())) continue;
            String number = x.getValue().getNumber();
            accountNumbers.add(number);
        }
        while (accountNumbers.size() > 0) {
            ArrayList<String> childAccountNumbers = new ArrayList<String>(10);
            Map<String, OrgAcctParent> oapopMap = orgSingleAssignCtx.getOapopMap();
            for (String accountNumber : accountNumbers) {
                OrgAcctParent parentOrgAcctParent;
                Long createOrgId;
                Set<String> childNumbers = accountNumTreeNodeMap.get(accountNumber).getChildNumbers();
                childAccountNumbers.addAll(childNumbers);
                OrgAcctParent orgAcctParent = oapopMap.get(accountNumber);
                if (orgAcctParent == null || orgAcctParent.getAcctId() == 0L || (createOrgId = Long.valueOf(orgAcctParent.getCreateOrgId())).compareTo(useOrgid) == 0 || superiorOrgIds.contains(createOrgId)) continue;
                DynamicObject parentAccountFromDb = BusinessDataServiceHelper.loadSingle((Object)orgAcctParent.getAcctId(), (String)"bd_accountview");
                DynamicObject useOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgid, (String)"bos_org", (String)"id,number,name");
                if (null == useOrg) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"AccountVersionPersonalizeUtil_2", (String)"fi-bd-common", (Object[])new Object[0]), useOrgid));
                }
                parentAccountFromDb.set("useorg", (Object)useOrg);
                parentAccountFromDb.set("useorg_id", (Object)useOrgid);
                String parentAcctNum = orgAcctParent.getpAcctNum();
                if (StringUtils.isNotEmpty((CharSequence)parentAcctNum) && (parentOrgAcctParent = oapopMap.get(parentAcctNum)) != null) {
                    parentAccountFromDb.set("parent", (Object)BusinessDataServiceHelper.loadSingle((Object)parentOrgAcctParent.getAcctId(), (String)"bd_accountview"));
                    parentAccountFromDb.set("parent_id", (Object)parentOrgAcctParent.getAcctId());
                }
                OperateOption personalizeOp = OperateOption.create();
                personalizeOp.setVariableValue("isPersonalizeData", "1");
                AccountVersionOpVars.setAutoAssignChildAfterVersioned(personalizeOp, true);
                AccountVersionOpVars.setIsFromRepairOrAssignView(personalizeOp, true);
                OperationResult personalizeResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{parentAccountFromDb}, (OperateOption)personalizeOp);
                if (personalizeResult.isSuccess()) continue;
                String failedMsg = BDUtil.buildOperationResultFailedMsg(personalizeResult, false);
                logger.info("batch_personalized_account failed on account: {} on org: {} for {}", new Object[]{accountNumber, useOrg.getString("name"), failedMsg});
                String errMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u7ec4\u7ec7%1$s\u7684\u79d1\u76ee%2$s\u4e2a\u6027\u5316\u5904\u7406\u65f6\u5931\u8d25: \"%3$s\"", (String)"AssignTask_0", (String)"fi-bd-common", (Object[])new Object[0]), useOrg.getString("name"), accountNumber, failedMsg);
                throw new KDBizException(errMsg);
            }
            orgSingleAssignCtx.getOapopMap().clear();
            this.buildOrgAcctParentAndOtherParentsAssign(orgSingleAssignCtx);
            this.buildOrgAcctParents(orgSingleAssignCtx);
            accountNumbers = childAccountNumbers;
        }
    }

    private void buildOrgAcctParentAndOtherParentsAssign(OrgSingleAssignCtx orgSingleAssignCtx) {
        OrgAcctParent orgAcctParam;
        AssignCtx assignCtx = orgSingleAssignCtx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = orgSingleAssignCtx.getOapopMap();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fmasterid,a.fparentid, a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,a.faccounttableid,l.fname ", new Object[0]);
        sqlBuilder.append(" from  t_bd_account a", new Object[0]);
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        sqlBuilder.append(" left join t_bd_account_l l on a.fid=l.fid and l.flocaleid =? ", new Object[]{lang});
        sqlBuilder.append(" where a.faccounttableid= ?  ", new Object[]{assignCtx.getAccountTableId()});
        sqlBuilder.append(" and a.fcreateorgid = ? ", new Object[]{orgSingleAssignCtx.getUseOrgid()});
        ArrayList<String> accountNums = new ArrayList<String>(assignCtx.getAssignAcctountNumTreeNodeMap().keySet());
        sqlBuilder.appendIn(" and a.fnumber ", accountNums);
        try (DataSet dataSet = DB.queryDataSet((String)"buildOrgAcctParentAndOtherParentsAssign", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                String fnumber2 = row.getString("fnumber");
                orgAcctParam = oapopMap.get(fnumber2);
                if (null == orgAcctParam) {
                    orgAcctParam = new OrgAcctParent();
                    oapopMap.put(fnumber2, orgAcctParam);
                    orgAcctParam.setNeedDeal(false);
                    orgAcctParam.setNeedVerison(false);
                }
                Date fenddate = row.getDate("fenddate");
                Long id = row.getLong("fid");
                if (fenddate.compareTo(AccountVersionUtil.getEndDate()) == 0) {
                    orgAcctParam.setAcctId(id);
                    orgAcctParam.setAcctMasterId(row.getLong("fmasterid"));
                    orgAcctParam.setOrgId(orgSingleAssignCtx.getUseOrgid());
                    orgAcctParam.setAcctNum(fnumber2);
                    orgAcctParam.setAcctTableId(row.getLong("faccounttableid"));
                    orgAcctParam.setpAcctId(row.getLong("fparentid"));
                    orgAcctParam.setAcctName(row.getString("fname"));
                    orgAcctParam.setCtrlstrategy(row.getString("fctrlstrategy"));
                    orgAcctParam.setCreateOrgId(row.getLong("fcreateorgid"));
                }
                orgAcctParam.getAcctMasterIds().add(row.getLong("fmasterid"));
                orgAcctParam.getUseregIds().add(id);
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.FNUMBER, ", new Object[0]);
        sqlBuilder.append(" exc.FDATAID,exc.FCREATEORGID,exc.FUSEORGID ", new Object[0]);
        sqlBuilder.append(" from  t_bd_accountexc exc ", new Object[0]);
        sqlBuilder.append(" left join t_bd_account a ON exc.fdataid=a.fid ", new Object[0]);
        sqlBuilder.append(" where a.faccounttableid= ?  ", new Object[]{assignCtx.getAccountTableId()});
        sqlBuilder.append(" and exc.FUSEORGID = ? ", new Object[]{orgSingleAssignCtx.getUseOrgid()});
        sqlBuilder.appendIn(" and fnumber ", accountNums);
        ArrayList excSqlResult = new ArrayList(10);
        HashSet<Long> excludeAcct = new HashSet<Long>(5);
        Throwable throwable = null;
        try (DataSet dataSet = DB.queryDataSet((String)"buildOrgAcctParentAndOtherParentsAssign", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row3 : dataSet) {
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                returnObj.put("fnumber", row3.getString("fnumber"));
                returnObj.put("fdataid", row3.getLong("fdataid"));
                returnObj.put("fcreateorgid", row3.getLong("fcreateorgid"));
                returnObj.put("fuseorgid", row3.getLong("fuseorgid"));
                excSqlResult.add(returnObj);
                excludeAcct.add(row3.getLong("fdataid"));
            }
        }
        catch (Throwable fnumber2) {
            Throwable throwable2 = fnumber2;
            throw fnumber2;
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fmasterid,a.fparentid,a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,a.faccounttableid,l.fname, ", new Object[0]);
        sqlBuilder.append(" reg.fuseorgid,reg.FCREATEORGID,reg.FADMINORGID,reg.FCTRLSTRATEGY,reg.FISASSIGN,reg.FASSIGNORGID ", new Object[0]);
        sqlBuilder.append(" from  t_bd_accountusereg reg ", new Object[0]);
        sqlBuilder.append(" left join t_bd_account a ON reg.fdataid=a.fid ", new Object[0]);
        sqlBuilder.append(" left join t_bd_account_l l on a.fid=l.fid and l.flocaleid =? ", new Object[]{lang});
        sqlBuilder.append(" where a.faccounttableid= ? ", new Object[]{assignCtx.getAccountTableId()});
        sqlBuilder.append(" and reg.FUSEORGID = ? ", new Object[]{orgSingleAssignCtx.getUseOrgid()});
        sqlBuilder.appendIn(" and fnumber ", accountNums);
        dataSet = DB.queryDataSet((String)"buildOrgAcctParentAndOtherParentsAssign", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        Throwable throwable3 = null;
        try {
            for (Row row : dataSet) {
                String fnumber3 = row.getString("fnumber");
                OrgAcctParent orgAcctParam2 = oapopMap.get(fnumber3);
                if (null == orgAcctParam2) {
                    orgAcctParam2 = new OrgAcctParent();
                    oapopMap.put(fnumber3, orgAcctParam2);
                }
                Date fenddate = row.getDate("fenddate");
                Long id = row.getLong("fid");
                if (!excludeAcct.contains(id) && fenddate.compareTo(AccountVersionUtil.getEndDate()) == 0) {
                    orgAcctParam2.setOrgId(orgSingleAssignCtx.getUseOrgid());
                    orgAcctParam2.setAcctNum(fnumber3);
                    orgAcctParam2.setAcctId(id);
                    orgAcctParam2.setAcctMasterId(row.getLong("fmasterid"));
                    orgAcctParam2.setAcctTableId(row.getLong("faccounttableid"));
                    orgAcctParam2.setpAcctId(row.getLong("fparentid"));
                    orgAcctParam2.setAcctName(row.getString("fname"));
                    orgAcctParam2.setCtrlstrategy(row.getString("fctrlstrategy"));
                    orgAcctParam2.setCreateOrgId(row.getLong("fcreateorgid"));
                    orgAcctParam2.setAssignOrgId(row.getLong("fassignorgid"));
                }
                orgAcctParam2.getAcctMasterIds().add(row.getLong("fmasterid"));
                orgAcctParam2.getUseregIds().add(id);
            }
        }
        catch (Throwable fnumber2) {
            Throwable throwable4 = fnumber2;
            throw fnumber2;
        }
        finally {
            if (dataSet != null) {
                if (throwable3 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable fnumber2) {
                        throwable3.addSuppressed(fnumber2);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (Map map : excSqlResult) {
            String fnumber = (String)map.get("fnumber");
            orgAcctParam = oapopMap.get(fnumber);
            if (null == orgAcctParam) continue;
            orgAcctParam.getExcIds().add((Long)map.get("fdataid"));
        }
    }

    private void buildOrgAcctParents(OrgSingleAssignCtx orgSingleAssignCtx) {
        if (DebugTrace.enable()) {
            logger.info("orgid : " + orgSingleAssignCtx.getUseOrgid() + " process start");
        }
        Map<String, OrgAcctParent> oapopMap = orgSingleAssignCtx.getOapopMap();
        HashSet<Long> parentId = new HashSet<Long>(10);
        for (Map.Entry<String, OrgAcctParent> oapopEntry : oapopMap.entrySet()) {
            Long pAcctId = oapopEntry.getValue().getpAcctId();
            if (null == pAcctId || pAcctId == 0L) continue;
            parentId.add(pAcctId);
        }
        if (null == parentId || parentId.size() == 0) {
            if (DebugTrace.enable()) {
                logger.info("orgid : " + orgSingleAssignCtx.getUseOrgid() + " null == parentId||parentId.size()  return");
            }
            return;
        }
        SqlBuilder acctountSql = new SqlBuilder();
        acctountSql.append("select a.fid,a.fmasterid,a.fnumber,a.fcreateOrgId,a.fctrlstrategy,a.fenddate,l.fname ", new Object[0]);
        acctountSql.append(" from  t_bd_account a", new Object[0]);
        acctountSql.append(" left join t_bd_account_l l on a.fid=l.fid ", new Object[0]);
        String lang = RequestContext.get().getLang().getLocale().getLanguage() + "_" + RequestContext.get().getLang().getLocale().getCountry();
        acctountSql.append(" and l.flocaleid =? ", new Object[]{lang});
        acctountSql.appendIn(" where a.fid ", new ArrayList(parentId));
        HashMap acctountSqlResult = new HashMap(16);
        try (DataSet dataSet = DB.queryDataSet((String)"buildOrgAcctParents", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)acctountSql);){
            for (Row row : dataSet) {
                HashMap<String, Object> returnObj = new HashMap<String, Object>(16);
                long fid = row.getLong("fid");
                returnObj.put("fnumber", row.getString("fnumber"));
                returnObj.put("fid", fid);
                returnObj.put("fmasterid", row.getLong("fmasterid"));
                returnObj.put("fctrlstrategy", row.getString("fctrlstrategy"));
                returnObj.put("fcreateorgid", row.getLong("fcreateorgid"));
                returnObj.put("fname", row.getString("fname"));
                acctountSqlResult.put(fid, returnObj);
            }
        }
        for (Map.Entry<String, OrgAcctParent> oapopEntry : oapopMap.entrySet()) {
            OrgAcctParent oap = oapopEntry.getValue();
            Long pAcctId = oap.getpAcctId();
            if (null == pAcctId || pAcctId == 0L) continue;
            Map accountInfo = (Map)acctountSqlResult.get(pAcctId);
            oap.setpAcctName((String)accountInfo.get("fname"));
            oap.setpAcctNum((String)accountInfo.get("fnumber"));
            oap.setpAcctMasterId((Long)accountInfo.get("fmasterid"));
        }
    }

    private void removeAlreadyAssignAcctId(OrgSingleAssignCtx sourceOrgSingleAssignCtx, OrgSingleAssignCtx targetOrgSingleAssignCtx) {
        if (DebugTrace.enable()) {
            logger.info("removeAlreadyAssignAcctId_orgid:{}\uff0cprocess start", (Object)targetOrgSingleAssignCtx.getUseOrgid());
        }
        Map<String, OrgAcctParent> oapopMap = targetOrgSingleAssignCtx.getOapopMap();
        Map<String, OrgAcctParent> pctxOapopMap = sourceOrgSingleAssignCtx.getOapopMap();
        for (Map.Entry<String, OrgAcctParent> pctxOapopEntry : pctxOapopMap.entrySet()) {
            String pNumber = pctxOapopEntry.getKey();
            OrgAcctParent pctxOapop = pctxOapopEntry.getValue();
            if (DebugTrace.enable()) {
                logger.info("removeAlreadyAssignAcctId_orgid:{},pNumber:{}", (Object)targetOrgSingleAssignCtx.getUseOrgid(), (Object)pNumber);
                logger.info("removeAlreadyAssignAcctId_orgid:{}, pctxOapop:{}", (Object)targetOrgSingleAssignCtx.getUseOrgid(), (Object)pctxOapop);
            }
            if (oapopMap.containsKey(pNumber)) {
                if (DebugTrace.enable()) {
                    logger.info("removeAlreadyAssignAcctId_orgid:{},pNumber:{} containsKey:true", (Object)targetOrgSingleAssignCtx.getUseOrgid(), (Object)pNumber);
                }
                OrgAcctParent oapop = oapopMap.get(pNumber);
                if (DebugTrace.enable()) {
                    logger.info("removeAlreadyAssignAcctId_orgid:{},oapopMap:{}", (Object)targetOrgSingleAssignCtx.getUseOrgid(), (Object)oapop);
                }
                if (pctxOapop.getAcctMasterId() != oapop.getAcctMasterId()) continue;
                oapop.setNeedDeal(false);
                continue;
            }
            if (DebugTrace.enable()) {
                logger.info("removeAlreadyAssignAcctId_orgid:{},pNumber:{} containsKey:false", (Object)targetOrgSingleAssignCtx.getUseOrgid(), (Object)pNumber);
            }
            try {
                OrgAcctParent pAcctOapop;
                OrgAcctParent pctxOapopClone = (OrgAcctParent)pctxOapop.clone();
                pctxOapopClone.setNeedVerison(false);
                pctxOapopClone.setNeedDeal(true);
                pctxOapopClone.setAssign(false);
                if (!Strings.isNullOrEmpty((String)pctxOapopClone.getpAcctNum()) && null != (pAcctOapop = oapopMap.get(pctxOapopClone.getpAcctNum()))) {
                    pctxOapopClone.setpAcctId(pAcctOapop.getAcctId());
                }
                pctxOapopClone.setOrgId(targetOrgSingleAssignCtx.getUseOrgid());
                oapopMap.put(pNumber, pctxOapopClone);
            }
            catch (CloneNotSupportedException e) {
                logger.info("removeAlreadyAssignAcctId_orgid:{} CloneNotSupportedException e ", (Object)targetOrgSingleAssignCtx.getUseOrgid());
                logger.error("removeAlreadyAssignAcctId_clone pctxOaoap", (Throwable)e);
                throw new KDBizException("removeAlreadyAssignAcctId_" + e.getMessage());
            }
        }
    }

    private void checkAssignOrgCreateSameAcctByNum(OrgSingleAssignCtx sourceOrgSingleAssignCtx, OrgSingleAssignCtx targetOrgSingleAssignCtx) {
        if (DebugTrace.enable()) {
            logger.info("checkAssignOrgCreateSameAcctByNum_orgid:{}, process start", (Object)targetOrgSingleAssignCtx.getUseOrgid());
        }
        Map<String, OrgAcctParent> oapopMap = targetOrgSingleAssignCtx.getOapopMap();
        Map<String, OrgAcctParent> pctxOapopMap = sourceOrgSingleAssignCtx.getOapopMap();
        for (Map.Entry<String, OrgAcctParent> oapopEntry : oapopMap.entrySet()) {
            OrgAcctParent pctxOapop;
            Long popOrgAcctMasterId;
            OrgAcctParent oapop = oapopEntry.getValue();
            if (!oapop.isNeedDeal()) continue;
            String currentOrgAcctNum = oapopEntry.getKey();
            Long opOrgAcctMasterId = oapopEntry.getValue().getAcctMasterId();
            if (!pctxOapopMap.containsKey(currentOrgAcctNum) || opOrgAcctMasterId.compareTo(popOrgAcctMasterId = Long.valueOf((pctxOapop = pctxOapopMap.get(currentOrgAcctNum)).getAcctMasterId())) == 0) continue;
            oapop.setNeedDeal(false);
        }
    }

    private void makeAssignExcuter(OrgSingleAssignCtx sourceOrgSingleAssignCtx, OrgSingleAssignCtx targetOrgSingleAssignCtx) {
        if (DebugTrace.enable()) {
            logger.info("makeAssignExcuter_orgid:{} process start", (Object)targetOrgSingleAssignCtx.getUseOrgid());
        }
        AssignCtx assignCtx = targetOrgSingleAssignCtx.getAssignCtx();
        Map<String, OrgAcctParent> oapopMap = targetOrgSingleAssignCtx.getOapopMap();
        Map<String, OrgAcctParent> pctxOapopMap = sourceOrgSingleAssignCtx.getOapopMap();
        this.buildIDdataDynObjMap(targetOrgSingleAssignCtx, oapopMap);
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = assignCtx.getAssignAcctountNumTreeNodeMap();
        ArrayList<String> acctNumbers = new ArrayList<String>(10);
        for (Map.Entry<String, AssignAccountNumTreeNode> e : accountNumTreeNodeMap.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)e.getValue().getPnumber())) continue;
            String x = e.getValue().getNumber();
            acctNumbers.add(x);
        }
        if (DebugTrace.enable()) {
            logger.info("makeAssignExcuter_acctNumbers:{}", (Object)String.join((CharSequence)",", acctNumbers));
        }
        ArrayList<String> acctNumbersSort = new ArrayList<String>(accountNumTreeNodeMap.size());
        for (String acctNumber : acctNumbers) {
            AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            if (assignAccountNumTreeNode == null) continue;
            acctNumbersSort.add(acctNumber);
            Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.loopAccountNumbers(pctxOapopMap, accountNumTreeNodeMap, acctNumber, childNumbers, acctNumbersSort);
        }
        if (DebugTrace.enable()) {
            logger.info("makeAssignExcuter_acctNumbersSort:{}", (Object)String.join((CharSequence)",", acctNumbersSort));
        }
        for (String acctNumber : acctNumbersSort) {
            DynamicObject[] successSaveAccts;
            OperationResult operationResult;
            Object createOrgId22;
            OrgAcctParent oapop = oapopMap.get(acctNumber);
            if (DebugTrace.enable()) {
                this.loopAssignExplain(targetOrgSingleAssignCtx, acctNumber, oapopMap, pctxOapopMap);
                logger.info("loopAssign_useOrgId:{},assignOrgId:{}", (Object)targetOrgSingleAssignCtx.getUseOrgid(), (Object)(oapop == null ? "null" : oapop.toString()));
            }
            if (oapop == null || !oapop.isNeedDeal()) continue;
            OrgAcctParent pctOap = pctxOapopMap.get(acctNumber);
            String pacctNum = oapop.getpAcctNum();
            boolean isNeedVersionAssign = true;
            if (pctOap == null || pacctNum == null) {
                isNeedVersionAssign = false;
            } else if (oapopMap.get(pacctNum) != null && oapopMap.get(pacctNum).getCreateOrgId() != targetOrgSingleAssignCtx.getUseOrgid().longValue()) {
                if (oapopMap.get(pacctNum).getAcctId() != 0L && pctxOapopMap.get(pacctNum).getCreateOrgId() != oapopMap.get(pacctNum).getCreateOrgId()) {
                    DynamicObject parentAccountFromDb = BusinessDataServiceHelper.loadSingle((Object)oapopMap.get(pacctNum).getAcctId(), (String)"bd_accountview");
                    DynamicObject useOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)targetOrgSingleAssignCtx.getUseOrgid(), (String)"bos_org", (String)"id,number,name");
                    if (null == useOrg) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff08ID=%s\uff09\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8981\u5148\u6e05\u9664\u810f\u6570\u636e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"AccountVersionPersonalizeUtil_2", (String)"fi-bd-common", (Object[])new Object[0]), targetOrgSingleAssignCtx.getUseOrgid()));
                    }
                    parentAccountFromDb.set("useorg", (Object)useOrg);
                    parentAccountFromDb.set("useorg_id", (Object)targetOrgSingleAssignCtx.getUseOrgid());
                    OperateOption personalizeOp = OperateOption.create();
                    personalizeOp.setVariableValue("isPersonalizeData", "1");
                    AccountVersionOpVars.setAutoAssignChildAfterVersioned(personalizeOp, true);
                    AccountVersionOpVars.setIsFromRepairOrAssignView(personalizeOp, true);
                    OperationResult personalizeResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{parentAccountFromDb}, (OperateOption)personalizeOp);
                    OperationLogEntry entry2 = new OperationLogEntry(targetOrgSingleAssignCtx.getUseOrgid(), parentAccountFromDb.getLong("id"), AccountOperationType.PERSONAL, Boolean.TRUE);
                    AccountOperationLogUtil.addLogEntryRow(entry2);
                    if (!personalizeResult.isSuccess()) {
                        String failedMsg = BDUtil.buildOperationResultFailedMsg(personalizeResult, false);
                        logger.info("batch_personalized_account failed on account:{} on org:{} for:{}", new Object[]{pacctNum, useOrg.getString("name"), failedMsg});
                        String errMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u7ec4\u7ec7%1$s\u7684\u79d1\u76ee%2$s\u4e2a\u6027\u5316\u5904\u7406\u65f6\u5931\u8d25: \"%3$s\"", (String)"AssignTask_0", (String)"fi-bd-common", (Object[])new Object[0]), useOrg.getString("name"), pacctNum, failedMsg);
                        entry2.setSuccess(Boolean.FALSE);
                        entry2.setLog(errMsg);
                        throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{errMsg});
                    }
                    targetOrgSingleAssignCtx.getOapopMap().clear();
                    this.buildOrgAcctParentAndOtherParentsAssign(targetOrgSingleAssignCtx);
                    this.buildOrgAcctParents(targetOrgSingleAssignCtx);
                    this.removeAlreadyAssignAcctId(sourceOrgSingleAssignCtx, targetOrgSingleAssignCtx);
                    this.checkAssignOrgCreateSameAcctByNum(sourceOrgSingleAssignCtx, targetOrgSingleAssignCtx);
                    isNeedVersionAssign = true;
                } else {
                    isNeedVersionAssign = false;
                }
            }
            if (!isNeedVersionAssign) {
                long acctParentId;
                if (pctOap != null && pacctNum != null) {
                    boolean isIncludeParentAccount;
                    Long pAccountId = pctxOapopMap.get(pacctNum).getAcctId();
                    OrgAcctParent orgAcctParent = oapopMap.get(pacctNum);
                    boolean bl = isIncludeParentAccount = null != orgAcctParent && orgAcctParent.getUseregIds().contains(pAccountId);
                    if (!isIncludeParentAccount) {
                        oapop.setNeedDeal(false);
                        Map<Long, String> orgNameMap = targetOrgSingleAssignCtx.getAssignCtx().getOrgNameMap();
                        String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b\u4e2d\u68c0\u67e5\u5230\u79d1\u76ee\u201c%1$s\u201d\u5f02\u5e38\uff0c\u8bf7\u5bf9\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u79d1\u76ee\u201c%3$s\u201d\u5148\u8fdb\u884c\u7248\u672c\u5316\u518d\u5206\u914d\u3002", (String)"MakeAssignExcuter_3", (String)"fi-bd-common", (Object[])new Object[0]), pacctNum, orgNameMap.get(targetOrgSingleAssignCtx.getUseOrgid()), pacctNum);
                        throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
                    }
                }
                oapop.setNeedVerison(false);
                HashSet<Long> acctIdSet = new HashSet<Long>(1);
                acctIdSet.add(oapop.getAcctId());
                DynamicObject acctDybOjb = targetOrgSingleAssignCtx.getAcctLeafParent().get(oapop.getAcctId());
                if (acctDybOjb.getBoolean("isleaf") && ((acctParentId = acctDybOjb.getLong("parent.id")) == 0L || targetOrgSingleAssignCtx.getTransParentIdatas().add(acctParentId))) {
                    AssignServiceHelper.trans2LeafAccount(acctIdSet, new Long[]{targetOrgSingleAssignCtx.getUseOrgid()}, targetOrgSingleAssignCtx.getOrgPorgs());
                }
                ArrayList<Object[]> useRegParam = new ArrayList<Object[]>(1);
                ArrayList<Object[]> excParams = new ArrayList<Object[]>(1);
                HashSet<Long> dataIds = new HashSet<Long>(oapop.getUseregIds());
                dataIds.addAll(oapop.getExcIds());
                HashSet<String> excParamsKey = new HashSet<String>(dataIds.size());
                HashSet<String> upParamsKey = new HashSet<String>(dataIds.size());
                for (Long acctid : dataIds) {
                    DynamicObject dynamicObject = targetOrgSingleAssignCtx.getIddataDynMap().get(acctid);
                    createOrgId22 = dynamicObject.getLong("createorg_id");
                    long dataId = dynamicObject.getLong("id");
                    Object[] exeParam = new Object[]{dataId, createOrgId22, oapop.getOrgId()};
                    String excKey = StringUtils.join((Object[])new Object[]{dataId, createOrgId22, oapop.getOrgId()}, (String)"-");
                    if (oapop.getExcIds().contains(dataId) && excParamsKey.add(excKey)) {
                        excParams.add(exeParam);
                    }
                    String ctrlstrategy = dynamicObject.getString("ctrlstrategy");
                    Long assignOrgId = targetOrgSingleAssignCtx.getAssignCtx().getUseOrgid();
                    Object[] uparam = new Object[]{oapop.getOrgId(), dynamicObject.getLong("id"), createOrgId22, createOrgId22, ctrlstrategy, "1", assignOrgId == null ? createOrgId22 : assignOrgId};
                    String upKey = StringUtils.join((Object[])new Object[]{dataId, oapop.getOrgId()}, (String)"-");
                    if (!upParamsKey.add(upKey)) continue;
                    useRegParam.add(uparam);
                    OperationLogEntry operationLogEntry = new OperationLogEntry(oapop.getOrgId(), dynamicObject.getLong("id"), AccountOperationType.ASSIGN, Boolean.TRUE);
                    AccountOperationLogUtil.addLogEntryRow(operationLogEntry);
                }
                targetOrgSingleAssignCtx.getUseRegParam().addAll(useRegParam);
                targetOrgSingleAssignCtx.getExcParams().addAll(excParams);
                if (targetOrgSingleAssignCtx.getUseRegParam().size() <= 500 && targetOrgSingleAssignCtx.getExcParams().size() <= 500) continue;
                AccountVersionUtil.doAssign(targetOrgSingleAssignCtx.getExcParams(), targetOrgSingleAssignCtx.getUseRegParam());
                targetOrgSingleAssignCtx.getUseRegParam().clear();
                targetOrgSingleAssignCtx.getExcParams().clear();
                continue;
            }
            oapop.setNeedVerison(true);
            Map<Object, DynamicObject> accountMap = targetOrgSingleAssignCtx.getAccountMap();
            if (null == accountMap) {
                accountMap = new HashMap<Object, DynamicObject>(16);
            }
            DynamicObject acctObject = accountMap.computeIfAbsent(oapop.getAcctId(), id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_accountview"));
            Map<Object, DynamicObject> opAccountMap = targetOrgSingleAssignCtx.getOpAccountMap();
            if (null == opAccountMap) {
                opAccountMap = new HashMap<Object, DynamicObject>(16);
            }
            DynamicObject opAccountObj = null;
            if (StringUtils.isNotEmpty((CharSequence)pacctNum)) {
                Long pAccountId = oapopMap.get(pacctNum).getAcctId();
                opAccountObj = opAccountMap.computeIfAbsent(pAccountId, id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_accountview"));
            }
            if (null == targetOrgSingleAssignCtx.getBosOrgMap()) {
                targetOrgSingleAssignCtx.setBosOrgMap(new HashMap<Object, DynamicObject>(16));
            }
            DynamicObject bos_org = targetOrgSingleAssignCtx.getBosOrgMap().computeIfAbsent(oapop.getOrgId(), id -> BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_org"));
            DynamicObject cloneAcct = (DynamicObject)CloneUtilFactory.getCloneUtil().clone((IDataEntityBase)acctObject);
            cloneAcct.set("createorg", (Object)bos_org);
            cloneAcct.set("org", (Object)bos_org);
            cloneAcct.set("useorg", (Object)bos_org);
            cloneAcct.set("parent", (Object)opAccountObj);
            if (DebugTrace.enable()) {
                logger.info("cloneAcct_startdate:{}, enddate:{}", (Object)cloneAcct.getDate("startdate"), (Object)cloneAcct.getDate("enddate"));
                if (opAccountObj != null) {
                    logger.info("cloneAcctParent_startdate:{}, enddate:{}", (Object)opAccountObj.getDate("startdate"), (Object)opAccountObj.getDate("enddate"));
                }
            }
            SqlBuilder queryMidAndIsLeafSql = new SqlBuilder();
            queryMidAndIsLeafSql.append(" select a.fmasterid, a.fisleaf ", new Object[0]);
            queryMidAndIsLeafSql.append(" from t_bd_account_u as u ", new Object[0]);
            queryMidAndIsLeafSql.append(" inner join t_bd_account as a on a.fid = u.fdataid ", new Object[0]);
            queryMidAndIsLeafSql.append(" where a.faccounttableid = ? ", new Object[]{targetOrgSingleAssignCtx.getAssignCtx().getAccountTableId()});
            queryMidAndIsLeafSql.append(" and a.fnumber = ? ", new Object[]{cloneAcct.getString("number")});
            queryMidAndIsLeafSql.append(" and u.fuseorgid = ? ", new Object[]{pctOap.getOrgId()});
            HashMap<Long, Boolean> queryMidAndIsLeafRs = new HashMap<Long, Boolean>(10);
            Throwable throwable = null;
            try (DataSet dataSet = DB.queryDataSet((String)"MakeAssignExcuter", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)queryMidAndIsLeafSql);){
                createOrgId22 = dataSet.iterator();
                while (createOrgId22.hasNext()) {
                    Row row = (Row)createOrgId22.next();
                    queryMidAndIsLeafRs.put(row.getLong("fmasterid"), row.getBoolean("fisleaf"));
                }
            }
            catch (Throwable createOrgId22) {
                Throwable throwable2 = createOrgId22;
                throw createOrgId22;
            }
            if (queryMidAndIsLeafRs.size() > 1) {
                for (Map.Entry entry2 : queryMidAndIsLeafRs.entrySet()) {
                    if (!((Boolean)entry2.getValue()).booleanValue()) continue;
                    cloneAcct.set("masterid", entry2.getKey());
                    cloneAcct.set("isleaf", (Object)true);
                    break;
                }
            }
            if (null != opAccountObj) {
                long opaccountTableId = opAccountObj.getLong("accounttable_id");
                String opnumber = opAccountObj.getString("number");
                if (oapop.getAcctTableId() == opaccountTableId && oapop.getpAcctNum().equals(opnumber)) {
                    DynamicObject updateAssist;
                    if (opAccountObj.getBoolean("iscashequivalent")) {
                        cloneAcct.set("iscashequivalent", (Object)true);
                    }
                    if (opAccountObj.getBoolean("isjournal")) {
                        cloneAcct.set("isjournal", (Object)true);
                    }
                    if (opAccountObj.getBoolean("acnotice")) {
                        cloneAcct.set("acnotice", (Object)true);
                    }
                    if (opAccountObj.getBoolean("ischangecurrency")) {
                        cloneAcct.set("ischangecurrency", (Object)true);
                    }
                    if (opAccountObj.getBoolean("isqty")) {
                        cloneAcct.set("isqty", (Object)true);
                        cloneAcct.set("measureunitgroup", opAccountObj.get("measureunitgroup"));
                        cloneAcct.set("measureunit", opAccountObj.get("measureunit"));
                    }
                    cloneAcct.set("accrualdirection", opAccountObj.get("accrualdirection"));
                    ArrayList<Object> assistEntryObjs = new ArrayList<Object>(10);
                    DynamicObjectCollection cloneAssistEntry = cloneAcct.getDynamicObjectCollection("checkitementry");
                    HashMap<Long, DynamicObject> cloneAssistMap = new HashMap<Long, DynamicObject>(cloneAssistEntry.size());
                    HashMap<Long, DynamicObject> updateAssistMap = new HashMap<Long, DynamicObject>(cloneAssistEntry.size());
                    for (DynamicObject assistRow : cloneAssistEntry) {
                        assistRow.set("id", null);
                        long assistId = assistRow.getLong("asstactitem_id");
                        cloneAssistMap.put(assistId, assistRow);
                        updateAssistMap.put(assistId, assistRow);
                    }
                    DynamicObjectCollection opAssistEntry = opAccountObj.getDynamicObjectCollection("checkitementry");
                    opAssistEntry.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
                    HashMap<Long, DynamicObject> opAssistMap = new HashMap<Long, DynamicObject>(opAssistEntry.size());
                    ArrayList<Long> opAssistIdWithSeq = new ArrayList<Long>(opAssistEntry.size());
                    for (DynamicObject dynamicObject : opAssistEntry) {
                        long assistId = dynamicObject.getLong("asstactitem_id");
                        opAssistMap.put(assistId, dynamicObject);
                        opAssistIdWithSeq.add(assistId);
                    }
                    for (Map.Entry entry3 : opAssistMap.entrySet()) {
                        Long assistId = (Long)entry3.getKey();
                        DynamicObject opAssistObj = (DynamicObject)entry3.getValue();
                        if (cloneAssistMap.containsKey(assistId)) {
                            DynamicObject cloneAssist = (DynamicObject)cloneAssistMap.get(assistId);
                            if (opAssistObj.getBoolean("isrequire")) {
                                cloneAssist.set("isrequire", (Object)true);
                            }
                            if (opAssistObj.getBoolean("enaccheck")) {
                                cloneAssist.set("enaccheck", (Object)true);
                            }
                            if (opAssistObj.getBoolean("isdetail")) {
                                cloneAssist.set("isdetail", (Object)true);
                            }
                            updateAssistMap.put(assistId, cloneAssist);
                            continue;
                        }
                        DynamicObject dynamicObject = new DynamicObject(cloneAssistEntry.getDynamicObjectType());
                        dynamicObject.set("asstactitem", opAssistObj.get("asstactitem"));
                        dynamicObject.set("isrequire", opAssistObj.get("isrequire"));
                        dynamicObject.set("enaccheck", opAssistObj.get("enaccheck"));
                        dynamicObject.set("isdetail", opAssistObj.get("isdetail"));
                        updateAssistMap.put(assistId, dynamicObject);
                    }
                    int seq = 1;
                    for (Long assistId : opAssistIdWithSeq) {
                        updateAssist = (DynamicObject)updateAssistMap.get(assistId);
                        if (updateAssist != null) {
                            updateAssist.set("seq", (Object)seq);
                            assistEntryObjs.add(updateAssist);
                            ++seq;
                        }
                        updateAssistMap.remove(assistId);
                    }
                    for (Map.Entry updateEntry : updateAssistMap.entrySet()) {
                        updateAssist = (DynamicObject)updateEntry.getValue();
                        updateAssist.set("seq", (Object)seq);
                        assistEntryObjs.add(updateEntry.getValue());
                        ++seq;
                    }
                    cloneAssistEntry.clear();
                    cloneAssistEntry.addAll(assistEntryObjs);
                    DynamicObjectCollection dynamicObjectCollection = cloneAcct.getDynamicObjectCollection("currencyentry");
                    String acctCurrencyType = opAccountObj.getString("acctcurrency");
                    if ("allcurrency".equals(acctCurrencyType) || "nocurrency".equals(acctCurrencyType)) {
                        cloneAcct.set("acctcurrency", (Object)acctCurrencyType);
                        dynamicObjectCollection.clear();
                    } else if ("descurrency".equals(acctCurrencyType)) {
                        DynamicObjectCollection opCurrencyEntry;
                        String cloneAcctCurrencyType = cloneAcct.getString("acctcurrency");
                        if ("nocurrency".equals(cloneAcctCurrencyType)) {
                            cloneAcct.set("acctcurrency", (Object)cloneAcctCurrencyType);
                            dynamicObjectCollection.clear();
                        } else if ("allcurrency".equals(cloneAcctCurrencyType)) {
                            cloneAcct.set("acctcurrency", (Object)acctCurrencyType);
                            opCurrencyEntry = opAccountObj.getDynamicObjectCollection("currencyentry");
                            ArrayList<DynamicObject> opCurrencyObjs = new ArrayList<DynamicObject>(opCurrencyEntry.size());
                            opCurrencyEntry.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
                            int i = 0;
                            for (Object opCurrencyObject : opCurrencyEntry) {
                                DynamicObject dynamicObject = new DynamicObject(opCurrencyEntry.getDynamicObjectType());
                                dynamicObject.set("seq", (Object)i++);
                                dynamicObject.set("currency", opCurrencyObject.get("currency"));
                                opCurrencyObjs.add(dynamicObject);
                            }
                            dynamicObjectCollection.clear();
                            dynamicObjectCollection.addAll(opCurrencyObjs);
                        } else if ("descurrency".equals(cloneAcctCurrencyType)) {
                            Object opCurrencyObject;
                            cloneAcct.set("acctcurrency", (Object)acctCurrencyType);
                            opCurrencyEntry = opAccountObj.getDynamicObjectCollection("currencyentry");
                            Set cloneCurrencyIDSet = dynamicObjectCollection.stream().map(entry -> entry.getDynamicObject("currency").getPkValue()).collect(Collectors.toSet());
                            ArrayList<DynamicObject> opCurrencyObjs = new ArrayList<DynamicObject>(dynamicObjectCollection.size());
                            opCurrencyEntry.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
                            int i = 0;
                            opCurrencyObject = opCurrencyEntry.iterator();
                            while (opCurrencyObject.hasNext()) {
                                DynamicObject opCurrencyObj = (DynamicObject)opCurrencyObject.next();
                                if (!cloneCurrencyIDSet.contains(opCurrencyObj.getDynamicObject("currency").getPkValue())) continue;
                                DynamicObject dynamicObject = new DynamicObject(opCurrencyEntry.getDynamicObjectType());
                                dynamicObject.set("seq", (Object)i++);
                                dynamicObject.set("currency", opCurrencyObj.get("currency"));
                                opCurrencyObjs.add(dynamicObject);
                            }
                            dynamicObjectCollection.clear();
                            dynamicObjectCollection.addAll(opCurrencyObjs);
                        }
                    }
                }
            }
            OperateOption op = OperateOption.create();
            AccountVersionOpVars.setVersioning(op, Boolean.TRUE);
            op.setVariableValue("isassign", "1");
            op.setVariableValue("useOrgID", String.valueOf(cloneAcct.getLong("useorg_id")));
            if (acctObject.getInt("level") > 1 && AccountVersionUtil.isVersionedChildAccount(acctObject.getLong("createorg_id"), acctObject.getLong("masterid"), acctObject.getLong("id"), acctObject.getString("number"))) {
                op.setVariableValue("isversionaddleaf", "1");
            }
            if (DebugTrace.enable()) {
                logger.info("\u79d1\u76ee\u5206\u914d,\u9700\u8981\u7248\u672c\u5316\uff0c\u51c6\u5907\u8c03\u7528\u79d1\u76ee\u4fdd\u5b58\u65b9\u6cd5\uff1acloneAcct:{}", (Object)cloneAcct.toString());
            }
            Object var24_34 = null;
            try {
                operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{cloneAcct}, (OperateOption)op);
                if (!operationResult.isSuccess()) {
                    String failedMsg = BDUtil.buildOperationResultFailedMsg(operationResult, false);
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{failedMsg});
                }
                OperationLogEntry entity = new OperationLogEntry(cloneAcct.getLong("useorg_id"), cloneAcct.getLong("id"), AccountOperationType.VERSION, Boolean.TRUE);
                AccountOperationLogUtil.addLogEntryRow(entity);
            }
            catch (Exception e) {
                logger.info("org:{}\uff0c\u79d1\u76ee\u7f16\u7801\uff1a{}, \u79d1\u76ee\u5206\u914d\uff1a\u7248\u672c\u5316\u4fdd\u5b58\u64cd\u4f5c\u62a5\u9519\u4fe1\u606f: {}", new Object[]{oapop.getOrgId(), cloneAcct.getString("number"), e.getMessage()});
                String msg = String.format(ResManager.loadKDString((String)"%1$s \u5f53\u524d\u7ec4\u7ec7\u540d\u79f0\uff1a%2$s,\u79d1\u76ee\uff1a%3$s\u3002", (String)"AssignTask_1", (String)"fi-bd-common", (Object[])new Object[0]), e.getMessage(), bos_org.getString("name"), cloneAcct.getString("number"));
                targetOrgSingleAssignCtx.getAssignCtx().getAcctCheckErrMsg().add(msg);
                OperationLogEntry entity = new OperationLogEntry(cloneAcct.getLong("useorg_id"), cloneAcct.getLong("id"), AccountOperationType.VERSION, false);
                entity.setLog(msg);
                AccountOperationLogUtil.setOperationLog(operationLog -> {
                    operationLog.getEntryEntity().add(entity);
                    operationLog.setLog(ResManager.loadKDString((String)"\u5931\u8d25", (String)"MakeAssignExcuter_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    operationLog.addNewAccount(cloneAcct);
                });
                throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{msg});
            }
            List valResults = operationResult.getValidateResult().getValidateErrors();
            for (ValidateResult validateResult : valResults) {
                OperationLogEntry entity = new OperationLogEntry(cloneAcct.getLong("useorg_id"), cloneAcct.getLong("id"), AccountOperationType.VERSION, Boolean.FALSE);
                entity.setNumber(cloneAcct.getString("number"));
                entity.setAccountName(cloneAcct.getString("name"));
                for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                    if (!oapop.getFailedOorgIds().contains(oapop.getOrgId())) {
                        oapop.getFailedOorgIds().add(oapop.getOrgId());
                    }
                    targetOrgSingleAssignCtx.getAssignCtx().getAcctCheckErrMsg().add(errorInfo.getMessage() + "\r\n");
                    if (DebugTrace.enable()) {
                        logger.info("Account_assign\uff1aversionalized faield msg: " + errorInfo.getMessage());
                    }
                    entity.setLog(StringUtils.isEmpty((CharSequence)entity.getLog()) ? errorInfo.getMessage() : entity.getLog() + "\n" + errorInfo.getMessage());
                    AccountOperationLogUtil.addLogEntryRow(entity);
                }
            }
            List successPkIds = operationResult.getSuccessPkIds();
            if (DebugTrace.enable()) {
                logger.info("Account_assign\uff1aversionalized successed acc ids: {}", (Object)StringUtils.join((Object[])new List[]{successPkIds}));
            }
            for (DynamicObject successSaveAcct : successSaveAccts = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                ArrayList<Object[]> useRegParam = new ArrayList<Object[]>(1);
                ArrayList<Object[]> excParams = new ArrayList<Object[]>(1);
                Long l = successSaveAcct.getLong("createorg_id");
                long orgId = successSaveAcct.getLong("org_id");
                this.resetCtxOrgPorgs(targetOrgSingleAssignCtx.getOrgPorgs(), orgId);
                long dataId = successSaveAcct.getLong("id");
                String successSaveAcctctrlstrategy = successSaveAcct.getString("ctrlstrategy");
                Long assignOrgId = targetOrgSingleAssignCtx.getAssignCtx().getUseOrgid();
                useRegParam.add(new Object[]{orgId, dataId, l, l, successSaveAcct.getString("ctrlstrategy"), "0", assignOrgId == null ? l : assignOrgId});
                if (DebugTrace.enable()) {
                    logger.info("Account_assign\uff1aassign releation, ctrl strategy\uff1a" + successSaveAcctctrlstrategy + ",useRegParam:{fuseorgid=" + orgId + ",fdataid=" + dataId + ",fcreateorgid=" + l + ",fadminorgid=" + l + ",fctrlstrategy=" + successSaveAcct.getString("ctrlstrategy") + ",fisassign=" + 0 + ",fassignorgid=" + (assignOrgId == null ? l : assignOrgId));
                }
                HashSet<Long> existsUseDataIds = new HashSet<Long>(oapop.getUseregIds());
                existsUseDataIds.add(oapop.getAcctId());
                OrgAcctParent poapop = pctxOapopMap.get(acctNumber);
                HashSet<Long> pexistsUseDataIds = new HashSet<Long>(poapop.getUseregIds());
                pexistsUseDataIds.addAll(existsUseDataIds);
                for (Long acctid : pexistsUseDataIds) {
                    DynamicObject account2 = targetOrgSingleAssignCtx.getIddataDynMap().get(acctid);
                    if (account2 == null) {
                        account2 = BusinessDataServiceHelper.loadSingleFromCache((Object)acctid, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
                    }
                    Long oldCreateOrgId = account2.getLong("createorg_id");
                    String ctrlstrategy = account2.getString("ctrlstrategy");
                    useRegParam.add(new Object[]{orgId, acctid, oldCreateOrgId, oldCreateOrgId, ctrlstrategy, "1", assignOrgId});
                    excParams.add(new Object[]{acctid, oldCreateOrgId, orgId});
                    OperationLogEntry entry4 = new OperationLogEntry(orgId, acctid, AccountOperationType.ASSIGN, true);
                    AccountOperationLogUtil.addLogEntryRow(entry4);
                }
                AccountVersionUtil.doAssign(excParams, useRegParam);
                OperationLogEntry entry5 = new OperationLogEntry(orgId, dataId, AccountOperationType.ASSIGN, true);
                AccountOperationLogUtil.addLogEntryRow(entry5);
                if (DebugTrace.enable()) {
                    logger.info("AssignTask_makeAssignExcuter\uff1aassignAllOldVersionAccts,accountId={},assignorgId={},useOrgId={},orgPorgs={}", new Object[]{dataId, assignOrgId, orgId, targetOrgSingleAssignCtx.getOrgPorgs()});
                }
                AssignServiceHelper.assignAllOldVersionAccts(dataId, assignOrgId, orgId, targetOrgSingleAssignCtx.getOrgPorgs());
                oapop.setCreateOrgId(oapop.getOrgId());
                oapop.setAcctId((Long)successPkIds.get(0));
                AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
                Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
                if (null != childNumbers && childNumbers.size() > 0) {
                    for (String childNumber : childNumbers) {
                        OrgAcctParent childOap = oapopMap.get(childNumber);
                        childOap.setpAcctId((Long)successPkIds.get(0));
                    }
                }
                this.prepareServiceParam(targetOrgSingleAssignCtx.getRefServiceParamMapTemp(), orgId, successSaveAcct.getLong("accounttable_id"), successSaveAcct.getDate("startdate"), successSaveAcct.getLong("id"), oapop.getAcctId(), this.getAsstActItemMap(successSaveAcct));
                List<Long> cid = AssignServiceHelper.getLeafs(successSaveAcct, l);
                if (cid.size() != 1) continue;
                this.prepareServiceParam(targetOrgSingleAssignCtx.getRefServiceParamMap(), orgId, successSaveAcct.getLong("accounttable_id"), successSaveAcct.getDate("startdate"), successSaveAcct.getLong("id"), oapop.getAcctId(), this.getAsstActItemMap(successSaveAcct));
            }
        }
        if (targetOrgSingleAssignCtx.getUseRegParam().size() > 0 || targetOrgSingleAssignCtx.getExcParams().size() > 0) {
            AccountVersionUtil.doAssign(targetOrgSingleAssignCtx.getExcParams(), targetOrgSingleAssignCtx.getUseRegParam());
            targetOrgSingleAssignCtx.getUseRegParam().clear();
            targetOrgSingleAssignCtx.getExcParams().clear();
        }
    }

    private void loopAccountNumbers(Map<String, OrgAcctParent> pctxOapopMap, Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap, String parentAcctNumber, Set<String> acctNumbers, List<String> acctNumbersSort) {
        OrgAcctParent parent = pctxOapopMap.get(parentAcctNumber);
        Set<Long> acctMasterIds = parent.getAcctMasterIds();
        String versionAddLeafFirst = "";
        if (acctMasterIds.size() > 1) {
            block0: for (String acctNumber : acctNumbers) {
                if (versionAddLeafFirst.length() > 0) break;
                OrgAcctParent orgAcctParent = pctxOapopMap.get(acctNumber);
                Set<Long> masterIds = orgAcctParent.getAcctMasterIds();
                for (Long acctMasterId : acctMasterIds) {
                    if (!masterIds.contains(acctMasterId)) continue;
                    versionAddLeafFirst = acctNumber;
                    acctNumbersSort.add(acctNumber);
                    continue block0;
                }
            }
        }
        for (String acctNumber : acctNumbers) {
            AssignAccountNumTreeNode assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            if (assignAccountNumTreeNode == null) continue;
            if (!StringUtils.equals((CharSequence)acctNumber, (CharSequence)versionAddLeafFirst)) {
                acctNumbersSort.add(acctNumber);
            }
            Set<String> childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.loopAccountNumbers(pctxOapopMap, accountNumTreeNodeMap, acctNumber, childNumbers, acctNumbersSort);
        }
    }

    private void buildIDdataDynObjMap(OrgSingleAssignCtx ctx, Map<String, OrgAcctParent> oapopMap) {
        HashSet<Long> regAndExcdataIds = new HashSet<Long>(5);
        HashSet<Long> oapIds = new HashSet<Long>(5);
        Set<Map.Entry<String, OrgAcctParent>> oapopMapEntrys = oapopMap.entrySet();
        for (Map.Entry<String, OrgAcctParent> oapopMapEntry : oapopMapEntrys) {
            OrgAcctParent oapop = oapopMapEntry.getValue();
            regAndExcdataIds.addAll(oapop.getUseregIds());
            regAndExcdataIds.addAll(oapop.getExcIds());
            oapIds.add(oapop.getAcctId());
        }
        if (regAndExcdataIds.size() > 0) {
            HashMap<Long, DynamicObject> iddataMap = new HashMap<Long, DynamicObject>(regAndExcdataIds.size());
            QFilter dataIdsFilter = new QFilter("id", "in", regAndExcdataIds);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,createorg_id,ctrlstrategy", (QFilter[])new QFilter[]{dataIdsFilter});
            for (DynamicObject acctDynObj : cols) {
                iddataMap.put(acctDynObj.getLong("id"), acctDynObj);
            }
            ctx.getIddataDynMap().putAll(iddataMap);
        }
        if (oapIds.size() > 0) {
            HashMap<Long, DynamicObject> acctLeafParent = new HashMap<Long, DynamicObject>(regAndExcdataIds.size());
            String selectFields = "id,isleaf,parent.id";
            QFilter[] qfArr = new QFilter[]{new QFilter("id", "in", oapIds)};
            DynamicObjectCollection dyCol = QueryServiceHelper.query((String)"bd_accountview", (String)selectFields, (QFilter[])qfArr);
            for (DynamicObject acctObj : dyCol) {
                acctLeafParent.put(acctObj.getLong("id"), acctObj);
            }
            ctx.getAcctLeafParent().putAll(acctLeafParent);
        }
    }

    private void loopAssignExplain(OrgSingleAssignCtx ctx, String acctNumber, Map<String, OrgAcctParent> oapopMap, Map<String, OrgAcctParent> pctxOapopMap) {
        long orgid = ctx.getUseOrgid();
        String orgName = ctx.getAssignCtx().getOrgNameMap().get(orgid);
        StringBuilder assignStrBuilder = new StringBuilder();
        assignStrBuilder.append("acctNum : ").append(acctNumber).append("---").append("org : ").append(ctx.getUseOrgid()).append("---").append("orgName : ").append(orgName).append("---").append("oapopMap : ").append(oapopMap.get(acctNumber) == null ? "" : oapopMap.get(acctNumber).toString()).append("pctxOapopMap : ").append(pctxOapopMap.get(acctNumber) == null ? "" : pctxOapopMap.get(acctNumber).toString()).append(";");
        logger.info(assignStrBuilder.toString());
    }

    private void resetCtxOrgPorgs(Map<Long, Long> orgPorgs, long useOrgId) {
        HashSet<Long> useOrgIds = new HashSet<Long>();
        if (orgPorgs.get(useOrgId) == null) {
            useOrgIds.add(useOrgId);
        }
        QFilter f2 = new QFilter("view", "=", (Object)10);
        if (!useOrgIds.isEmpty()) {
            QFilter f3 = new QFilter("org", "in", useOrgIds);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getUseregParams", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{f2, f3}, null);){
                for (Row row : dt) {
                    orgPorgs.put(row.getLong("org"), row.getLong("parent"));
                }
            }
        }
    }

    private Map<String, Object> getAsstActItemMap(DynamicObject obj) {
        DynamicObjectCollection entry = obj.getDynamicObjectCollection("checkitementry");
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        for (DynamicObject row : entry) {
            DynamicObject item = row.getDynamicObject("asstactitem");
            String defaultvalue = row.getString("defaulid");
            if (item == null || StringUtils.isEmpty((CharSequence)defaultvalue)) continue;
            Object value = defaultvalue;
            if (!"3".equals(item.getString("valuetype"))) {
                value = Long.parseLong(String.valueOf(defaultvalue));
            }
            result.put(item.getString("flexfield"), value);
        }
        return result;
    }

    private void prepareServiceParam(Map<String, AccountTableRefServiceParam> refServiceParamMap, long orgId, long tableId, Date versiondate, long newAcctId, long oldAcctId, Map<String, Object> assgrpMap) {
        AccountTableRefServiceParam param = refServiceParamMap.computeIfAbsent(AccountVersionUtil.getRefServiceKey(orgId, tableId, versiondate), k -> new AccountTableRefServiceParam(orgId, tableId, versiondate, new AccountTableRef(tableId, tableId, new AccountRef())));
        param.getAccountTableRef().getAccountRef().addAccountRef(newAcctId, oldAcctId, assgrpMap);
    }

    private void processExplain(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap, Long rootId) {
        this.orgTreeStructureExplain(assignOrgTreeNodeMap, rootId);
        this.acctTreeStructureExplain();
    }

    private void acctTreeStructureExplain() {
        Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap = this.ctx.getAssignAcctountNumTreeNodeMap();
        List acctNumbers = accountNumTreeNodeMap.entrySet().stream().filter(e -> StringUtils.isEmpty((CharSequence)((AssignAccountNumTreeNode)e.getValue()).getPnumber())).map(x -> ((AssignAccountNumTreeNode)x.getValue()).getNumber()).collect(() -> new ArrayList(10), (r, x) -> r.add(x), (left, right) -> left.addAll(right));
        this.explainTopAccts(acctNumbers);
        this.recuExplainChild(acctNumbers, accountNumTreeNodeMap);
    }

    private void recuExplainChild(Collection<String> acctNumbers, Map<String, AssignAccountNumTreeNode> accountNumTreeNodeMap) {
        Set<String> childNumbers;
        AssignAccountNumTreeNode assignAccountNumTreeNode;
        for (String acctNumber : acctNumbers) {
            assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.explainAcctAndSubAccts(acctNumber, childNumbers);
        }
        for (String acctNumber : acctNumbers) {
            assignAccountNumTreeNode = accountNumTreeNodeMap.get(acctNumber);
            childNumbers = assignAccountNumTreeNode.getChildNumbers();
            this.recuExplainChild(childNumbers, accountNumTreeNodeMap);
        }
    }

    private void explainTopAccts(List<String> acctNumbers) {
        this.explainAcctAndSubAccts("", acctNumbers);
    }

    private void explainAcctAndSubAccts(String parentAcct, Collection<String> acctNumbers) {
        StringBuilder acctNumExplainBuilder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)parentAcct)) {
            acctNumExplainBuilder.append("top level acct : ");
        } else {
            acctNumExplainBuilder.append("pacctnumber : ").append(parentAcct).append(";");
        }
        if (null != acctNumbers && !acctNumbers.isEmpty()) {
            for (String acctNum : acctNumbers) {
                acctNumExplainBuilder.append("acctNumber : ").append(acctNum).append(",");
            }
            if (acctNumExplainBuilder.length() > 0) {
                acctNumExplainBuilder.deleteCharAt(acctNumExplainBuilder.length() - 1).append(";");
            }
        } else {
            acctNumExplainBuilder.append("no child");
        }
        if (DebugTrace.enable()) {
            logger.info(acctNumExplainBuilder.toString());
        }
    }

    private void orgTreeStructureExplain(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap, Long orgId) {
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(assignOrgTreeNodeMap.size());
        this.buildOrgIdNameMap(assignOrgTreeNodeMap, orgNameMap);
        this.buildOrgExplainInfo(true, orgId, Long.parseLong("0"), orgNameMap);
        this.recuExplainChild(orgId, orgNameMap, assignOrgTreeNodeMap);
        this.ctx.getOrgNameMap().putAll(orgNameMap);
    }

    private void buildOrgIdNameMap(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap, Map<Long, String> orgNameMap) {
        DynamicObject[] orgNames;
        Set<Long> orgExcuteOrgid = this.buildExcuteOrgIdSets(assignOrgTreeNodeMap);
        QFilter orgFilter = new QFilter("id", "in", orgExcuteOrgid);
        for (DynamicObject orgName : orgNames = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{orgFilter})) {
            orgNameMap.put(orgName.getLong("id"), orgName.getString("name"));
        }
    }

    private void recuExplainChild(Long orgId, Map<Long, String> orgNameMap, Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        AssignOrgTreeNode assignOrgTreeNode = assignOrgTreeNodeMap.get(orgId);
        Set<Long> childTreeNodes = assignOrgTreeNode.getChildIds();
        for (Long treeID : childTreeNodes) {
            this.buildOrgExplainInfo(false, treeID, orgId, orgNameMap);
        }
        for (Long childNode : childTreeNodes) {
            this.recuExplainChild(childNode, orgNameMap, assignOrgTreeNodeMap);
        }
    }

    private void buildOrgExplainInfo(boolean isroot, Long orgId, Long parentId, Map<Long, String> orgNameMap) {
        StringBuilder strBuild = new StringBuilder();
        if (isroot) {
            strBuild.append("assignOrgTreeNodeMap root : ");
        } else {
            strBuild.append("assignOrgTreeNodeMap node : ");
        }
        strBuild.append("parentId : ").append(parentId).append(";").append("parentname : ").append(orgNameMap.get(parentId)).append(";").append("id : ").append(orgId).append(";").append("name : ").append(orgNameMap.get(orgId)).append(";");
        logger.info(strBuild.toString());
    }

    private Set<Long> buildExcuteOrgIdSets(Map<Long, AssignOrgTreeNode> assignOrgTreeNodeMap) {
        HashSet<Long> orgExcuteOrgid = new HashSet<Long>(assignOrgTreeNodeMap.size());
        for (Map.Entry<Long, AssignOrgTreeNode> orgEntry : assignOrgTreeNodeMap.entrySet()) {
            orgExcuteOrgid.add(orgEntry.getKey());
        }
        return orgExcuteOrgid;
    }
}

