/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.dao;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.business.dao.BaseDataCommonDAO;
import kd.fi.bd.business.vo.AssgrpVO;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.business.vo.PresetCashFlowItemEntryVO;
import kd.fi.bd.business.vo.PresetCashFlowItemVO;
import kd.fi.bd.util.filter.QFilterBuilder;

public class CashFlowItemPresetRelationDAO
extends BaseDataCommonDAO {
    public static List<PresetCashFlowItemVO> getAllRelationsByAccountTableId(Long accountTableId) {
        List<PresetCashFlowItemVO> result = CashFlowItemPresetRelationDAO.load("gl_presetcashflowitem", PresetCashFlowItemVO.class, QFilterBuilder.create("accounttable", "=", accountTableId).toArray(new QFilter[0]), "", -1);
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet cashFlowItemIds = new HashSet(result.size());
        HashSet accountIds = new HashSet(result.size());
        HashSet assgrpIds = new HashSet(result.size());
        result.stream().peek(preset -> cashFlowItemIds.add(preset.getCashFlowItemId())).flatMap(preset -> preset.getPresetCashFlowItemEntryVOS().stream()).forEach(presetEntry -> {
            accountIds.add(presetEntry.getAccountId());
            assgrpIds.add(presetEntry.getAssgrpId());
        });
        Map<Long, CashFlowItemVO> cashFlowItemVOMap = CashFlowItemPresetRelationDAO.load(cashFlowItemIds.toArray(new Long[0]), CashFlowItemVO.class);
        Map<Long, PresetCashFlowItemEntryVO.AccountVO> accountVOMap = CashFlowItemPresetRelationDAO.load(accountIds.toArray(new Long[0]), PresetCashFlowItemEntryVO.AccountVO.class);
        Map<Long, AssgrpVO> assgrpVOMap = CashFlowItemPresetRelationDAO.load(assgrpIds.toArray(new Long[0]), AssgrpVO.class);
        for (PresetCashFlowItemVO presetCashFlowItemVO : result) {
            presetCashFlowItemVO.setCashFlowItemVO(cashFlowItemVOMap.get(presetCashFlowItemVO.getCashFlowItemId()));
            for (PresetCashFlowItemEntryVO entryVO : presetCashFlowItemVO.getPresetCashFlowItemEntryVOS()) {
                entryVO.setAccountVO(accountVOMap.get(entryVO.getAccountId()));
                entryVO.setAssgrpVO(assgrpVOMap.get(entryVO.getAssgrpId()));
            }
        }
        return result;
    }
}

