/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.vo.AccountHealthLogEntryVO;
import kd.fi.bd.business.vo.AccountHealthLogVO;
import kd.fi.bd.interfaces.service.AccountHealthLogService;
import org.apache.commons.collections4.ListUtils;

public class AccountHealthLogServiceImpl
implements AccountHealthLogService {
    private static final Log log = LogFactory.getLog(AccountHealthLogServiceImpl.class);

    @Override
    public void saveLog(List<AccountHealthLogVO> healthLogVOList) {
        if (CollectionUtils.isEmpty(healthLogVOList)) {
            log.info("healthLogVOList is empty");
            return;
        }
        try {
            ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(16);
            for (AccountHealthLogVO healthLogVO : healthLogVOList) {
                DynamicObject healthLog = BusinessDataServiceHelper.newDynamicObject((String)"bd_accounthealth_log");
                healthLog.set("org", (Object)healthLogVO.getOrgId());
                healthLog.set("createtime", (Object)healthLogVO.getCreateTime());
                healthLog.set("accounttable", (Object)healthLogVO.getAccountTableId());
                healthLog.set("creater", (Object)healthLogVO.getCreater());
                healthLog.set("optype", (Object)healthLogVO.getOpType());
                healthLog.set("requestid", (Object)healthLogVO.getRequestId());
                healthLog.set("exeresult", (Object)healthLogVO.getExeResult());
                List<AccountHealthLogEntryVO> healthLogEntry = healthLogVO.getHealthLogEntryVOList();
                if (CollectionUtils.isNotEmpty(healthLogEntry)) {
                    DynamicObjectCollection newColl = healthLog.getDynamicObjectCollection("entryentity");
                    for (AccountHealthLogEntryVO healthLogEntryVO : healthLogEntry) {
                        DynamicObject newRow = new DynamicObject(newColl.getDynamicObjectType());
                        newRow.set("exestate", (Object)healthLogEntryVO.getExeState());
                        newRow.set("acctnumber", (Object)healthLogEntryVO.getAcctNumber());
                        newRow.set("categories", (Object)this.subStringDes(healthLogEntryVO.getCategories()));
                        newRow.set("description", (Object)this.subStringDes(healthLogEntryVO.getDescription()));
                        newRow.set("versiondate", (Object)healthLogEntryVO.getVersionDate());
                        newRow.set("repairaccid", (Object)healthLogEntryVO.getRepairAccId());
                        newRow.set("seq", (Object)healthLogEntryVO.getSeq());
                        newColl.add((Object)newRow);
                    }
                }
                logList.add(healthLog);
            }
            if (!logList.isEmpty()) {
                List batchList = ListUtils.partition(logList, (int)200);
                for (List list : batchList) {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                }
            }
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u5065\u5eb7\u5de1\u67e5\u65e5\u5fd7\u4fdd\u5b58\u670d\u52a1\u5f02\u5e38[%1$s]: %2$s", (String)"AccountHealthLogServiceImpl_0", (String)"fi-fcm-mservice", (Object[])new Object[0]), TraceIdUtil.getCurrentTraceIdString(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            log.error(msg, (Throwable)e);
            throw new KDBizException(msg);
        }
    }

    protected String subStringDes(String str) {
        if (StringUtils.isNotEmpty((String)str)) {
            return str.length() > 500 ? str.substring(0, 500) : str;
        }
        return "";
    }
}

