/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowDataRow;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowTable;
import kd.fi.bd.business.dao.CashFlowItemPresetRelationDAO;
import kd.fi.bd.business.service.AssgrpService;
import kd.fi.bd.business.service.ExtOrgService;
import kd.fi.bd.business.vo.AssgrpVO;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.business.vo.PresetCashFlowItemEntryVO;
import kd.fi.bd.business.vo.PresetCashFlowItemVO;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.collector.ExtCollectors;

public class CashFlowItemPresetRelationService {
    public static List<PresetCashFlowItemVO> getAvailableRelations(Long orgId, Long accountTableId) {
        ArrayList<PresetCashFlowItemVO> result = new ArrayList<PresetCashFlowItemVO>(10);
        List<Long> allSuperiorOrgIds = ExtOrgService.getAllSuperiorOrgs("10", orgId, true);
        List<PresetCashFlowItemVO> allRelations = CashFlowItemPresetRelationDAO.getAllRelationsByAccountTableId(accountTableId);
        Multimap<Long, PresetCashFlowItemVO> orgItemsMap = allRelations.stream().filter(r -> r.getCashFlowItemVO().getEnable() != false && r.getCashFlowItemVO().getLeaf() != false).collect(ExtCollectors.toMultiap(PresetCashFlowItemVO::getCreateOrgId, r -> r));
        Collections.reverse(allSuperiorOrgIds);
        HashSet<String> existedLongNumberSet = new HashSet<String>(4);
        for (Long superiorOrgId : allSuperiorOrgIds) {
            for (PresetCashFlowItemVO presetCashFlowItemVO : orgItemsMap.get((Object)superiorOrgId)) {
                if (!existedLongNumberSet.add(presetCashFlowItemVO.getCashFlowItemVO().getLongNumber())) continue;
                result.add(presetCashFlowItemVO);
            }
        }
        return result;
    }

    public static Map<PresetCashFlowItemParam, Long> batchGetCashFlowItemIds(List<PresetCashFlowItemParam> paramList, long orgId, long accountTableId, long periodId) {
        CashFlowItemPresetRelationService.compensateAssgrpJson(paramList);
        List<PresetCashFlowItemVO> availableRelations = CashFlowItemPresetRelationService.getAvailableRelations(orgId, accountTableId);
        PresetCashFlowTable table = CashFlowItemPresetRelationService.buildPresetCashFlowTable(availableRelations);
        HashMap resultNumberMap = new HashMap(paramList.size());
        for (PresetCashFlowItemParam param : paramList) {
            String acctLongNumber = param.getAcctLongnumber();
            String firstNumber = acctLongNumber.split("_")[0];
            List<PresetCashFlowDataRow> list = table.get(firstNumber, param.getItemType(), param.getDc());
            if (list.isEmpty()) continue;
            Map<String, Object> flexValueMap = AssgrpService.fromJsonStr(param.getAssGrpJsonStr());
            CashFlowItemPresetRelationService.matchByAssGrp(list, flexValueMap, acctLongNumber).ifPresent(x -> resultNumberMap.put(param, x.getCfLongNumber().substring(x.getCfLongNumber().lastIndexOf(64) + 1)));
        }
        if (resultNumberMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, CashFlowItemVO> longNumberItemVOMap = CashFlowItemHelper.loadForVersion(resultNumberMap.values().toArray(new String[0]), (Long)orgId, (Long)periodId, CashFlowItemVO::getLeaf);
        return resultNumberMap.entrySet().stream().filter(e -> Objects.nonNull(longNumberItemVOMap.get(e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, e -> ((CashFlowItemVO)longNumberItemVOMap.get(e.getValue())).getId()));
    }

    private static Optional<PresetCashFlowDataRow> matchByAssGrp(List<PresetCashFlowDataRow> rows, Map<String, Object> assGrpMap, String acctLongNumber) {
        List<String> selfAndSuperiorLongNumbers = CashFlowItemPresetRelationService.parseToSelfAndSuperiorLongNumbers(acctLongNumber);
        for (String longNumber : selfAndSuperiorLongNumbers) {
            Optional<PresetCashFlowDataRow> result = assGrpMap.isEmpty() ? rows.stream().filter(x -> x.getAssgrp().isEmpty()).filter(x -> x.getAcctLongNumber().equals(longNumber)).findFirst() : rows.stream().filter(x -> x.getAssgrp().size() <= assGrpMap.size()).sorted((o1, o2) -> Integer.compare(o2.getAssgrp().size(), o1.getAssgrp().size())).filter(x -> CashFlowItemPresetRelationService.isAssGrpContainAll(assGrpMap, x.getAssgrp())).filter(x -> x.getAcctLongNumber().equals(longNumber)).findFirst();
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static List<String> parseToSelfAndSuperiorLongNumbers(String selfLongNumber) {
        ArrayList<String> allNum = new ArrayList<String>(8);
        allNum.add(selfLongNumber);
        int index = selfLongNumber.lastIndexOf("_");
        while (index > 0) {
            String parent = selfLongNumber.substring(0, index);
            allNum.add(parent);
            index = parent.lastIndexOf("_");
        }
        return allNum;
    }

    private static boolean isAssGrpContainAll(Map<String, Object> assGrpMap, Map<String, Object> containMap) {
        for (Map.Entry<String, Object> entry : containMap.entrySet()) {
            Object containVal = entry.getValue();
            Object val = assGrpMap.get(entry.getKey());
            if (val != null && containVal != null && val.toString().equals(containVal.toString())) continue;
            return false;
        }
        return true;
    }

    private static void compensateAssgrpJson(List<PresetCashFlowItemParam> paramList) {
        List assgrpJsonMissedParams = paramList.stream().filter(param -> param.getAssgrp() > 0L && param.getAssGrpJsonStr() == null).collect(Collectors.toList());
        if (assgrpJsonMissedParams.isEmpty()) {
            return;
        }
        List<Long> assgrpIds = BDUtil.extractToList(assgrpJsonMissedParams, PresetCashFlowItemParam::getAssgrp);
        Map<Long, AssgrpVO> assgrpVOMap = AssgrpService.load(assgrpIds.toArray(new Long[0]));
        for (PresetCashFlowItemParam param2 : assgrpJsonMissedParams) {
            param2.setAssGrpJsonStr(assgrpVOMap.get(param2.getAssgrp()).getValue());
        }
    }

    private static PresetCashFlowTable buildPresetCashFlowTable(List<PresetCashFlowItemVO> relations) {
        PresetCashFlowTable presetCashFlowTable = new PresetCashFlowTable(16);
        for (PresetCashFlowItemVO relation : relations) {
            if (null == relation.getCashFlowItemVO()) continue;
            for (PresetCashFlowItemEntryVO relationEntry : relation.getPresetCashFlowItemEntryVOS()) {
                if (null == relationEntry.getAccountVO()) continue;
                PresetCashFlowDataRow dataRow = new PresetCashFlowDataRow(relation.getCashFlowItemVO().getType(), relation.getCashFlowItemVO().getLongNumber(), relationEntry.getAccountVO().getLongNumber(), relationEntry.getDc());
                if (relationEntry.getAssgrpVO() != null) {
                    dataRow.getAssgrp().putAll(AssgrpService.fromJsonStr(relationEntry.getAssgrpVO().getValue()));
                }
                String firstLevelAccountNumber = relationEntry.getAccountVO().getLongNumber().split("_")[0];
                presetCashFlowTable.add(firstLevelAccountNumber, dataRow);
            }
        }
        return presetCashFlowTable;
    }
}

