/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.dao.CashFlowItemDao;
import kd.fi.bd.business.service.PeriodService;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.cashflow.replace.CashFlowItemDBReplaceExecutor;
import kd.fi.bd.enums.CashFlowItemType;
import kd.fi.bd.interfaces.service.ICashFlowItemService;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.collector.ExtCollectors;
import kd.fi.bd.util.filter.QFilterBuilder;

public class CashFlowItemServiceImpl
implements ICashFlowItemService {
    private static final Log extLogger = ExtLogFactory.getLog(CashFlowItemServiceImpl.class, "[CashFlowItemServiceImpl]");

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Long periodId) {
        return this.loadSingleForVersion(itemNumber, orgId, periodId, (CashFlowItemVO itemVO) -> true);
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new String[]{itemNumber}, orgId, periodId, extFilter).get(itemNumber));
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Date effectiveDate) {
        return this.loadSingleForVersion(itemNumber, orgId, effectiveDate, (CashFlowItemVO itemVO) -> true);
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(String itemNumber, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new String[]{itemNumber}, orgId, effectiveDate, extFilter).get(itemNumber));
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Long periodId) {
        return this.loadSingleForVersion(cashFlowItemId, orgId, periodId, (CashFlowItemVO itemVO) -> true);
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new Long[]{cashFlowItemId}, orgId, periodId, extFilter).get(cashFlowItemId));
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Date effectiveDate) {
        return this.loadSingleForVersion(cashFlowItemId, orgId, effectiveDate, (CashFlowItemVO itemVO) -> true);
    }

    @Override
    public Optional<CashFlowItemVO> loadSingleForVersion(Long cashFlowItemId, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        return Optional.ofNullable(this.loadForVersion(new Long[]{cashFlowItemId}, orgId, effectiveDate, extFilter).get(cashFlowItemId));
    }

    @Override
    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Long periodId) {
        return this.loadForVersion(itemNumbers, orgId, periodId, (CashFlowItemVO ignore) -> true);
    }

    @Override
    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        Date effectiveDate = PeriodService.loadSingle(periodId).getEndDate();
        return this.loadForVersion(itemNumbers, orgId, effectiveDate, extFilter);
    }

    @Override
    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Date effectiveDate) {
        return this.loadForVersion(itemNumbers, orgId, effectiveDate, (CashFlowItemVO ignore) -> true);
    }

    @Override
    public Map<String, CashFlowItemVO> loadForVersion(String[] itemNumbers, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        extLogger.info("loadForVersion params---itemNumbers:{}, orgId:{}, effectiveDate:{}", new Object[]{itemNumbers, orgId, effectiveDate});
        if (ArrayUtils.isEmpty((Object[])itemNumbers)) {
            return Collections.emptyMap();
        }
        QFilterBuilder baseQFilterBuilder = new QFilterBuilder();
        baseQFilterBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId));
        List<CashFlowItemVO> cashFlowItemVOS = CashFlowItemDao.load(baseQFilterBuilder.toArray(new QFilter("number", "in", (Object)itemNumbers)), "", -1);
        Predicate<CashFlowItemVO> correctFilter = extFilter.and(item -> item.getStartDate().compareTo(effectiveDate) <= 0 && item.getEndDate().compareTo(effectiveDate) > 0);
        List<CashFlowItemVO> poppedItems = BDUtil.popFromCollection(cashFlowItemVOS, correctFilter.negate());
        Map<String, CashFlowItemVO> result = cashFlowItemVOS.stream().collect(Collectors.toMap(CashFlowItemVO::getNumber, cfItem -> cfItem, (o, n) -> n));
        poppedItems.removeIf(itemVO -> result.containsKey(itemVO.getNumber()));
        if (poppedItems.isEmpty()) {
            extLogger.info("all items found in current level, loadForVersion result---result:{}", result);
            return result;
        }
        Multimap<String, String> parentNumOriNumMap = poppedItems.stream().flatMap(item -> Arrays.stream(item.getLongNumber().split("@")).filter(numPerLevel -> !item.getNumber().equals(numPerLevel)).map(num -> Tuple.create((Object)num, (Object)item.getNumber()))).collect(ExtCollectors.toMultiap(t -> (String)t.item1, t -> (String)t.item2));
        List<CashFlowItemVO> parentItemVOS = CashFlowItemDao.load(baseQFilterBuilder.toArray(new QFilter("number", "in", (Object)parentNumOriNumMap.keySet())), "level desc", -1);
        for (CashFlowItemVO parentItemVO : parentItemVOS) {
            for (String curOriNumber : parentNumOriNumMap.get((Object)parentItemVO.getNumber())) {
                if (!correctFilter.test(parentItemVO) || result.containsKey(curOriNumber)) continue;
                result.put(curOriNumber, parentItemVO);
            }
        }
        extLogger.info("loadForVersion result---result:{}", result);
        return result;
    }

    @Override
    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Long periodId) {
        return this.loadForVersion(cashFlowItemIds, orgId, periodId, (CashFlowItemVO itemVO) -> true);
    }

    @Override
    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        Date effectiveDate = PeriodService.loadSingle(periodId).getEndDate();
        return this.loadForVersion(cashFlowItemIds, orgId, effectiveDate, extFilter);
    }

    @Override
    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Date effectiveDate) {
        return this.loadForVersion(cashFlowItemIds, orgId, effectiveDate, (CashFlowItemVO ignore) -> true);
    }

    @Override
    public Map<Long, CashFlowItemVO> loadForVersion(Long[] cashFlowItemIds, Long orgId, Date effectiveDate, Predicate<CashFlowItemVO> extFilter) {
        extLogger.info("loadForVersion params---itemIds:{}, orgId:{}, effectiveDate:{}", new Object[]{cashFlowItemIds, orgId, effectiveDate});
        if (ArrayUtils.isEmpty((Object[])cashFlowItemIds)) {
            return Collections.emptyMap();
        }
        Map<Long, CashFlowItemVO> result = this.load(cashFlowItemIds);
        Set<Long> allPermittedItems = this.getAllPermittedItems(orgId);
        Predicate<CashFlowItemVO> correctFilter = extFilter.and(item -> item.getStartDate().compareTo(effectiveDate) <= 0 && item.getEndDate().compareTo(effectiveDate) > 0).and(item -> allPermittedItems.contains(item.getId()));
        Map<Long, CashFlowItemVO> poppedMap = BDUtil.popFromMap(result, e -> correctFilter.negate().test(e.getValue()));
        if (poppedMap.isEmpty()) {
            extLogger.info("all items found with id, loadForVersion result---result:{}", result);
            return result;
        }
        Map<String, Long> numberIdMap = poppedMap.entrySet().stream().map(e -> Tuple.create((Object)((CashFlowItemVO)e.getValue()).getNumber(), e.getKey())).collect(Collectors.toMap(t -> (String)t.item1, t -> (Long)t.item2));
        Map<String, CashFlowItemVO> numberItemMap = this.loadForVersion(numberIdMap.keySet().toArray(new String[0]), orgId, effectiveDate, extFilter);
        numberItemMap.forEach((number, item) -> result.put((Long)numberIdMap.get(number), (CashFlowItemVO)item));
        extLogger.info("loadForVersion result---result:{}", result);
        return result;
    }

    @Override
    public List<CashFlowItemVO> loadVersionByOrg(Long orgId, Long periodId, Predicate<CashFlowItemVO> extFilter) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder();
        Date periodEndDate = PeriodService.loadSingle(periodId).getEndDate();
        qFilterBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId)).add("startdate", "<=", periodEndDate).add("enddate", ">", periodEndDate);
        return CashFlowItemDao.load(qFilterBuilder.toArray(new QFilter[0]), "", -1).stream().filter(extFilter).collect(Collectors.toList());
    }

    @Override
    public CashFlowItemVO loadSingle(Long cashFlowItemId) {
        return CashFlowItemDao.loadSingle(cashFlowItemId);
    }

    @Override
    public Map<Long, CashFlowItemVO> load(Long[] cashFlowItemIds) {
        return CashFlowItemDao.load(cashFlowItemIds);
    }

    @Override
    public Set<Long> getAllPermittedItems(Long orgId) {
        QFilter baseDataIdInFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"gl_cashflowitem", (Long)orgId);
        extLogger.info("getAllPermittedItems: generated filter is {}", (Object)baseDataIdInFilter);
        if (baseDataIdInFilter == null || !(baseDataIdInFilter.getValue() instanceof Collection)) {
            return Collections.emptySet();
        }
        return new HashSet<Long>((Collection)baseDataIdInFilter.getValue());
    }

    @Override
    public QFilterBuilder buildSpeceficVersionFilter(CashFlowItemType type, Long periodId) {
        Date periodEndDate = PeriodService.loadSingle(periodId).getEndDate();
        QFilterBuilder qFilterBuilder = type.getBaseFilter().get();
        qFilterBuilder.add("startdate", "<=", periodEndDate).add("enddate", ">", periodEndDate);
        return qFilterBuilder;
    }

    @Override
    public QFilterBuilder buildLatestVersionFilter(CashFlowItemType type) {
        Date endDate = AccountRefUtils.getEndDate();
        QFilterBuilder qFilterBuilder = type.getBaseFilter().get();
        qFilterBuilder.addEqual("enddate", endDate);
        return qFilterBuilder;
    }

    @Override
    public int replaceDBItem(Long orgId, Long previousMasterId, Long updatedId) {
        return CashFlowItemDBReplaceExecutor.replace(orgId, previousMasterId, updatedId);
    }
}

