/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.ext.version.BaseDataOrgRelExtService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.interfaces.service.ICashflowItemUseRelationService;

public class CashflowItemNewModelRelationServiceImpl
implements ICashflowItemUseRelationService {
    @Override
    public Map<Long, Long> getAllSubCfIncludeAssign(Long itemId, String longNumber, List<Long> orgIds, boolean isOnlyLeaf) {
        HashMap<Long, Long> id2Masterid = new HashMap<Long, Long>(16);
        if (orgIds.isEmpty()) {
            return id2Masterid;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", orgIds, (boolean)false));
        filters.add(new QFilter("longnumber", "like", (Object)(longNumber + "%")));
        filters.add(new QFilter("id", "!=", (Object)itemId));
        if (isOnlyLeaf) {
            filters.add(new QFilter("isleaf", "=", (Object)true));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAllSubCfIncludeAssign", (String)"gl_cashflowitem", (String)"id,masterid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : ds) {
                id2Masterid.put(row.getLong("id"), row.getLong("masterid"));
            }
        }
        return id2Masterid;
    }

    @Override
    public Map<String, Set<Long>> queryExcDataId(long useOrgId, String[] numbers) {
        HashMap<String, Set<Long>> numMap = new HashMap<String, Set<Long>>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fnumber,b.fcreateorgid from t_gl_cashflowitem a inner join t_gl_cashflowitem b on a.fsourcedataid = b.fid ", new Object[0]);
        sqlBuilder.append(" where a.fcreateorgid = ? ", new Object[]{useOrgId});
        sqlBuilder.append(" and b.fid != b.fsourcedataid ", new Object[0]);
        sqlBuilder.appendIn(" and a.fnumber ", (Object[])numbers);
        try (DataSet ds = DB.queryDataSet((String)"queryExcDataId", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                numMap.computeIfAbsent(row.getString("a.fnumber"), k -> new HashSet()).add(row.getLong("a.fcreateorgid"));
            }
        }
        return numMap;
    }

    @Override
    public DataSet queryExcDataIdByNumber(long useOrgId, List<Object> numbers) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fid fdataid,b.fmasterid,b.fparentid, b.fnumber,b.fcreateOrgId,b.fctrlstrategy,b.fenddate from t_gl_cashflowitem a ", new Object[0]);
        sqlBuilder.append(" inner join t_gl_cashflowitem b on a.fsourcedataid = b.fid ", new Object[0]);
        sqlBuilder.append(" where a.fcreateorgid = ? ", new Object[]{useOrgId});
        sqlBuilder.append(" and b.fid != b.fsourcedataid ", new Object[0]);
        sqlBuilder.appendIn(" and a.fnumber ", numbers);
        return DB.queryDataSet((String)"queryExcDataId", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
    }

    @Override
    public Set<Long> queryIndivisionOrgIds(long itemId, List<Long> orgIds) {
        HashSet<Long> ids = new HashSet<Long>();
        QFilter filter = new QFilter("sourcedata", "=", (Object)itemId);
        QFilter fid = new QFilter("id", "!=", (Object)itemId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryIndivisionOrgIds", (String)"gl_cashflowitem", (String)"createorg", (QFilter[])new QFilter[]{filter, fid}, null, (int)-1);){
            for (Row row : dataSet) {
                ids.add(row.getLong("createorg"));
            }
        }
        if (orgIds != null && !orgIds.isEmpty()) {
            ids.retainAll(orgIds);
        }
        return ids;
    }

    @Override
    public Set<Long> queryAssignOrgIds(long itemId) {
        BaseDataOrgRelExtService service = new BaseDataOrgRelExtService("gl_cashflowitem");
        Map dataOrgRelation = service.getDataOrgRelation(Collections.singletonList(itemId));
        return dataOrgRelation.get(itemId) == null ? new HashSet<Long>() : (Set)dataOrgRelation.get(itemId);
    }

    @Override
    public Set<Long> queryAssignDataIds(long useOrgId, Set<Long> itemIds) {
        BaseDataOrgRelExtService service = new BaseDataOrgRelExtService("gl_cashflowitem");
        Map dataOrgRelation = service.getDataOrgRelation(itemIds);
        HashSet<Long> result = new HashSet<Long>(10);
        for (Map.Entry entry : dataOrgRelation.entrySet()) {
            if (!((Set)entry.getValue()).contains(useOrgId)) continue;
            result.add((Long)entry.getKey());
        }
        return result;
    }

    @Override
    public Set<Long> queryExcnDataIds(long createOrgId, Set<Long> itemIds) {
        HashSet<Long> result = new HashSet<Long>(10);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fid from t_gl_cashflowitem a inner join t_gl_cashflowitem b on a.fsourcedataid = b.fid ", new Object[0]);
        sqlBuilder.append(" where b.fcreateorgid = ? ", new Object[]{createOrgId});
        sqlBuilder.append(" and b.fid != b.fsourcedataid ", new Object[0]);
        sqlBuilder.appendIn(" and b.fid ", itemIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryExcDataId", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                result.add(row.getLong("fid"));
            }
        }
        return result;
    }

    @Override
    public Map<Long, Set<Long>> queryAssignRelationByMid(long masterId, List<Object> useOrgIds) {
        HashMap<Long, Set<Long>> datas = new HashMap<Long, Set<Long>>();
        BaseDataOrgRelExtService service = new BaseDataOrgRelExtService("gl_cashflowitem");
        QFilter fmid = new QFilter("masterid", "=", (Object)masterId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAssignRelationByMid", (String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{fmid}, null);){
            ArrayList<Long> ids = new ArrayList<Long>();
            int i = 0;
            for (Row row : dataSet) {
                if (i >= 499) {
                    Map dataOrgRelation = service.getDataOrgRelation(ids);
                    datas.putAll(dataOrgRelation);
                    ids.clear();
                }
                ids.add(row.getLong("id"));
                ++i;
            }
            if (!ids.isEmpty()) {
                Map dataOrgRelation = service.getDataOrgRelation(ids);
                datas.putAll(dataOrgRelation);
            }
        }
        return datas;
    }

    @Override
    public DataSet queryAssignDataByNumbers(long useOrgId, List<Object> numbers) {
        QFilter forg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)useOrgId);
        QFilter fnumber = new QFilter("number", "in", numbers);
        String selField = "id fid,masterid fmasterid,parent fparentid,number fnumber,createorg fcreateorgid,ctrlstrategy fctrlstrategy,enddate fenddate";
        DataSet useRange = QueryServiceHelper.queryDataSet((String)"queryAssignDataId", (String)"gl_cashflowitem", (String)selField, (QFilter[])new QFilter[]{forg, fnumber}, null);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fmasterid, a.fparentid, a.fnumber, a.fcreateorgid, a.fctrlstrategy, a.fenddate from t_gl_cashflowitem a inner join t_gl_cashflowitem b on a.fsourcedataid=b.fid ", new Object[0]);
        sqlBuilder.appendIn(" where a.fnumber", numbers);
        sqlBuilder.append(" and a.fcreateorgid=?", new Object[]{useOrgId});
        DataSet excDs = DB.queryDataSet((String)"queryAssignDataId", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        return useRange.union(excDs);
    }

    @Override
    public Map<String, Set<Long>> queryAssignDataId(long useOrgId, String[] numbers) {
        HashMap<String, Set<Long>> datas = new HashMap<String, Set<Long>>();
        QFilter forg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)useOrgId);
        QFilter fnumber = new QFilter("number", "in", (Object)numbers);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAssignDataId", (String)"gl_cashflowitem", (String)"id,number", (QFilter[])new QFilter[]{forg, fnumber}, null);){
            for (Row row : dataSet) {
                datas.computeIfAbsent(row.getString("number"), k -> new HashSet()).add(row.getLong("id"));
            }
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,a.fnumber from t_gl_cashflowitem a inner join t_gl_cashflowitem b on a.fsourcedataid=b.fid ", new Object[0]);
        sqlBuilder.appendIn(" where a.fnumber", (Object[])numbers);
        sqlBuilder.append(" and a.fcreateorgid=?", new Object[]{useOrgId});
        DataSet dataSet = DB.queryDataSet((String)"queryAssignDataId", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            for (Row row : dataSet) {
                datas.computeIfAbsent(row.getString("fnumber"), k -> new HashSet()).add(row.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return datas;
    }

    @Override
    public void writeUseRange(List<Object[]> excParams, List<Object[]> useRegParams) {
        HashMap<Object, List> exc = new HashMap<Object, List>(16);
        for (Object[] objectArray : excParams) {
            exc.computeIfAbsent(objectArray[2], k -> new ArrayList()).add(objectArray[0]);
        }
        HashMap<Object, List> useReg = new HashMap<Object, List>(16);
        for (Object[] useRegParam : useRegParams) {
            useReg.computeIfAbsent(useRegParam[0], k -> new ArrayList()).add(useRegParam[1]);
        }
        BaseDataOrgRelExtService baseDataOrgRelExtService = new BaseDataOrgRelExtService("gl_cashflowitem");
        for (Map.Entry entry : useReg.entrySet()) {
            List excData;
            List useData = (List)entry.getValue();
            if (exc != null && (excData = (List)exc.get(entry.getKey())) != null) {
                useData.removeAll(excData);
            }
            List datas = useData.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
            baseDataOrgRelExtService.writeOrgRel(Long.valueOf(Long.parseLong(entry.getKey().toString())), datas);
        }
    }

    @Override
    public Optional<DynamicObject> findPreVersion(long curOrgId, String number) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)"10", (long)curOrgId);
        if (!superiorOrgs.isEmpty()) {
            Long parentOrgId = (Long)superiorOrgs.get(0);
            QFilter forgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)parentOrgId);
            QFilter fnumber = new QFilter("number", "=", (Object)number);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"findPreVersion", (String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{fnumber, forgFilter}, (String)"startdate desc", (int)1);){
                if (ds.hasNext()) {
                    Long lastVersionId = ds.next().getLong("id");
                    Optional.of(BusinessDataServiceHelper.loadSingle((Object)lastVersionId, (String)"gl_cashflowitem"));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public void deleteUseRange(List<Object[]> useParams) {
        HashMap<Long, List> map = new HashMap<Long, List>();
        for (Object[] param : useParams) {
            List dataIds = map.computeIfAbsent(Long.parseLong(param[1].toString()), x -> new ArrayList());
            dataIds.add(Long.parseLong(param[0].toString()));
        }
        BaseDataOrgRelExtService service = new BaseDataOrgRelExtService("gl_cashflowitem");
        for (Map.Entry entry : map.entrySet()) {
            service.deleteOrgRel((Long)entry.getKey(), (List)entry.getValue());
        }
    }
}

