/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyQueryService;
import kd.fi.bd.business.service.mulcur.MulLocalDeployServiceHelper;
import kd.fi.bd.business.vo.AccountBookMCVO;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.exception.MCErrorCodes;
import org.apache.commons.collections4.list.UnmodifiableList;

public class LocalCurrencyConfigService {
    private static final Log LOG = LogFactory.getLog(LocalCurrencyConfigService.class);
    private static final String SELECT_FIELDS = String.join((CharSequence)",", "number", "name", "controlmetadata", "curfieldname", "curdbname", "exratetablefieldname", "exratetabledbname", "enable", LocalCurrencyConfigService.addEntryEntityPrefix("subcontrolmetadata"), LocalCurrencyConfigService.addEntryEntityPrefix("fieldtype"), LocalCurrencyConfigService.addEntryEntityPrefix("fieldname"), LocalCurrencyConfigService.addEntryEntityPrefix("dbname"));
    private static final String ENABLE_MUL_CUR_KEY = "queryEnableCurrencies";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initSpecificLocalCur(String localNum) {
        LocalCurrencyConfigVO config = LocalCurrencyConfigService.getCurrencyConfig(localNum);
        if (config.isEnabled()) {
            LOG.info("mullocal:" + localNum + " had been enabled. ");
            return true;
        }
        if (!config.validateSelf()) {
            throw new KDBizException(MCErrorCodes.CONFIG_ERR, new Object[]{" please contact developer. "});
        }
        Class<LocalCurrencyConfigService> clazz = LocalCurrencyConfigService.class;
        synchronized (LocalCurrencyConfigService.class) {
            config = LocalCurrencyConfigService.getCurrencyConfig(localNum);
            if (config.isEnabled()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            try (DLock dlock = DLock.create((String)"fi/bd/mulcurrency/deploy").fastMode();){
                if (!dlock.tryLock(3000L)) throw new KDBizException(MCErrorCodes.MUTUX_INIT_CONFIG, new Object[0]);
                config = LocalCurrencyConfigService.getCurrencyConfig(localNum);
                if (config.isEnabled()) {
                    boolean bl = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return bl;
                }
                ArrayList<LocalCurrencyConfigVO> allEnableConfigVOList = new ArrayList<LocalCurrencyConfigVO>(8);
                allEnableConfigVOList.add(config);
                allEnableConfigVOList.addAll((Collection<LocalCurrencyConfigVO>)LocalCurrencyConfigService.queryEnableCurrencies());
                MulLocalDeployServiceHelper.deployAll(allEnableConfigVOList.toArray(new LocalCurrencyConfigVO[0]));
                boolean isValid = MulLocalDeployServiceHelper.validateAfterDeployed(config);
                if (!isValid) throw new KDBizException(MCErrorCodes.FAILED_INIT_ERR, new Object[0]);
                LocalCurrencyConfigService.enabledLocalConfig(config.getNumber());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public static LocalCurrencyConfigVO getCurrencyConfig(String currencyNumber) {
        DynamicObject mulCurConfig = BusinessDataServiceHelper.loadSingle((String)"bd_mulcurconfig", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyNumber)});
        LocalCurrencyConfigVO configVO = LocalCurrencyConfigService.tranToLocalCurrencyConfig(mulCurConfig);
        if (Objects.nonNull(configVO)) {
            return configVO;
        }
        throw new KDBizException(MCErrorCodes.CONFIG_ERR, new Object[]{"config number is " + currencyNumber + " not exist"});
    }

    public static void enabledLocalConfig(String currencyNumber) {
        try (TXHandle tx = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"update t_bd_mulcurconfig set fenable = ? where fnumber = ? ", (Object[])new Object[]{Character.valueOf('1'), currencyNumber});
                LocalCurrencyConfigService.removeMulCurConfigCache();
                LocalCurrencyQueryService.removeCache();
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static List<LocalCurrencyConfigVO> getCurrencyConfigByEntityId(String controlEntityId) {
        DynamicObject[] mulCurConfigs;
        ArrayList<LocalCurrencyConfigVO> configVOList = new ArrayList<LocalCurrencyConfigVO>(8);
        for (DynamicObject mulCurConfig : mulCurConfigs = BusinessDataServiceHelper.load((String)"bd_mulcurconfig", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("controlmetadata", "=", (Object)controlEntityId)})) {
            LocalCurrencyConfigVO configVO = LocalCurrencyConfigService.tranToLocalCurrencyConfig(mulCurConfig);
            if (!Objects.nonNull(configVO)) continue;
            configVOList.add(configVO);
        }
        return configVOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UnmodifiableList<LocalCurrencyConfigVO> queryEnableCurrencies() {
        LocalCacheKey cacheKey = LocalCurrencyConfigService.buildCacheKey(ENABLE_MUL_CUR_KEY);
        ArrayList<LocalCurrencyConfigVO> localCurConfigVOList = (ArrayList<LocalCurrencyConfigVO>)LocalCacheHelper.get((LocalCacheKey)cacheKey, List.class);
        if (!Objects.isNull(localCurConfigVOList)) return new UnmodifiableList((List)localCurConfigVOList);
        Class<LocalCurrencyConfigService> clazz = LocalCurrencyConfigService.class;
        synchronized (LocalCurrencyConfigService.class) {
            DynamicObject[] mulCurConfigs;
            localCurConfigVOList = (List)LocalCacheHelper.get((LocalCacheKey)cacheKey, List.class);
            if (!Objects.isNull(localCurConfigVOList)) return new UnmodifiableList((List)localCurConfigVOList);
            localCurConfigVOList = new ArrayList<LocalCurrencyConfigVO>(8);
            for (DynamicObject mulCurConfig : mulCurConfigs = BusinessDataServiceHelper.load((String)"bd_mulcurconfig", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)})) {
                LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.tranToLocalCurrencyConfig(mulCurConfig);
                if (!Objects.nonNull(localCurrencyConfigVO)) continue;
                LocalCacheHelper.put((LocalCacheKey)LocalCurrencyConfigService.buildCacheKey("getCurrencyConfig#" + localCurrencyConfigVO.getNumber()), (Object)localCurrencyConfigVO);
                localCurConfigVOList.add(localCurrencyConfigVO);
            }
            LocalCacheHelper.put((LocalCacheKey)cacheKey, localCurConfigVOList);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new UnmodifiableList((List)localCurConfigVOList);
        }
    }

    public static Collection<LocalCurrencyConfigVO> queryEnableCurrencies(long orgId, long bookTypeId) {
        AccountBookMCVO accountBookMCVO = (AccountBookMCVO)LocalCurrencyQueryService.getAllMulLocalCurrency().get((Object)orgId, (Object)bookTypeId);
        if (Objects.nonNull(accountBookMCVO)) {
            Map<String, AccountBookMCVO.Info> enabledCurs = accountBookMCVO.getCurrencyInfoMap();
            return Collections.unmodifiableCollection(LocalCurrencyConfigService.queryEnableCurrencies().stream().filter(x -> enabledCurs.containsKey(x.getNumber())).collect(Collectors.toList()));
        }
        return Collections.EMPTY_LIST;
    }

    public static Map<Long, Collection<LocalCurrencyConfigVO>> batchQueryEnableCurrencies(Collection<Long> orgIds, long bookTypeId) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Collection<LocalCurrencyConfigVO>> result = new HashMap<Long, Collection<LocalCurrencyConfigVO>>(orgIds.size());
        Table<Long, Long, AccountBookMCVO> allMCAccountBooks = LocalCurrencyQueryService.getAllMulLocalCurrency();
        UnmodifiableList<LocalCurrencyConfigVO> enableCurs = LocalCurrencyConfigService.queryEnableCurrencies();
        orgIds.stream().forEach(orgId -> {
            AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMCAccountBooks.get(orgId, (Object)bookTypeId);
            if (Objects.nonNull(accountBookMCVO)) {
                Map<String, AccountBookMCVO.Info> enabledCurs = accountBookMCVO.getCurrencyInfoMap();
                Collection enableConfigs = Collections.unmodifiableCollection(enableCurs.stream().filter(x -> enabledCurs.containsKey(x.getNumber())).collect(Collectors.toList()));
                result.put((Long)orgId, enableConfigs);
            }
        });
        return result;
    }

    public static Collection<LocalCurrencyConfigVO> queryEnableCurrencies(Collection<Long> orgIds, long bookTypeId) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.EMPTY_LIST;
        }
        Table<Long, Long, AccountBookMCVO> allMCAccountBooks = LocalCurrencyQueryService.getAllMulLocalCurrency();
        HashSet enableCurNums = new HashSet(3);
        orgIds.stream().forEach(orgId -> {
            AccountBookMCVO accountBookMCVO = (AccountBookMCVO)allMCAccountBooks.get(orgId, (Object)bookTypeId);
            if (Objects.nonNull(accountBookMCVO)) {
                Map<String, AccountBookMCVO.Info> enabledCurs = accountBookMCVO.getCurrencyInfoMap();
                enableCurNums.addAll(enabledCurs.keySet());
            }
        });
        UnmodifiableList<LocalCurrencyConfigVO> enableCurs = LocalCurrencyConfigService.queryEnableCurrencies();
        return enableCurs.stream().filter(x -> enableCurNums.contains(x.getNumber())).collect(Collectors.toList());
    }

    private static LocalCurrencyConfigVO tranToLocalCurrencyConfig(DynamicObject mulCurConfig) {
        if (Objects.nonNull(mulCurConfig)) {
            MetaField controlMetaField = new MetaField(mulCurConfig.getString("controlmetadata").trim(), mulCurConfig.getString("curfieldname").trim(), mulCurConfig.getString("curdbname").trim(), "currency");
            MetaField exrateTableField = new MetaField(mulCurConfig.getString("controlmetadata").trim(), mulCurConfig.getString("exratetablefieldname").trim(), mulCurConfig.getString("exratetabledbname").trim(), "exratetable");
            DynamicObjectCollection entryFields = mulCurConfig.getDynamicObjectCollection("entryentity");
            HashBasedTable allFields = HashBasedTable.create();
            for (DynamicObject entryField : entryFields) {
                MetaField metaField = new MetaField(entryField.getString("subcontrolmetadata").trim(), entryField.getString("fieldname").trim(), entryField.getString("dbname").trim(), entryField.getString("fieldtype").trim());
                MCT mct = MCT.of(metaField.getFieldTag());
                allFields.put((Object)metaField.getEntityId(), (Object)mct, (Object)metaField);
            }
            return new LocalCurrencyConfigVO(mulCurConfig.getBoolean("enable"), mulCurConfig.getString("number"), mulCurConfig.getLocaleString("name"), controlMetaField, exrateTableField, (Table<String, MCT, MetaField>)allFields);
        }
        return null;
    }

    public static void removeMulCurConfigCache() {
        LocalCacheHelper.remove((LocalCacheKey)LocalCurrencyConfigService.buildCacheKey(ENABLE_MUL_CUR_KEY));
    }

    private static String addEntryEntityPrefix(String fieldName) {
        return "entryentity." + fieldName;
    }

    private static LocalCacheKey buildCacheKey(String key) {
        return LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.BASE_CURRENCY, (Object[])new Object[]{key});
    }
}

