/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.interfaces.service.IAccountQueryService;

public class AccountQueryServiceImpl
implements IAccountQueryService {
    private static final Log LOG = LogFactory.getLog(AccountQueryServiceImpl.class);

    @Override
    public DataSet queryHistoryAccount(String selectFields, Collection<Long> orgIds, long accountTableId, Date startDate, Date endDate, List<QFilter> accountFilters) {
        if (CollectionUtils.isEmpty(orgIds)) {
            throw new IllegalArgumentException("param orgIds is empty");
        }
        if (StringUtils.isEmpty((String)selectFields)) {
            throw new IllegalArgumentException("param selectFields is empty");
        }
        if (null == startDate || endDate == null) {
            throw new IllegalArgumentException("param startDate or endDate is null");
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (accountFilters != null) {
            accountFilters.stream().filter(x -> null != x).forEach(x -> filters.add((QFilter)x));
        }
        filters.add(new QFilter("accounttable", "=", (Object)accountTableId).and(new QFilter("status", "=", (Object)"C")).and("startdate", "<", (Object)endDate).and("enddate", ">=", (Object)startDate));
        ArrayList<QFilter> shareFilters = new ArrayList<QFilter>(filters);
        shareFilters.add(new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5')));
        DataSet allDs = QueryServiceHelper.queryDataSet((String)"query_share_account", (String)"bd_accountview", (String)selectFields, (QFilter[])shareFilters.toArray(new QFilter[shareFilters.size()]), null);
        List<DataSet> privateDsList = Lists.partition(new ArrayList<Long>(orgIds), (int)1999).stream().map(orgSubList -> {
            ArrayList<QFilter> privateFilters = new ArrayList<QFilter>(filters);
            privateFilters.add(new QFilter("createorg", "in", orgSubList));
            privateFilters.add(new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('7')));
            return QueryServiceHelper.queryDataSet((String)"query_share_account", (String)"bd_accountview", (String)selectFields, (QFilter[])privateFilters.toArray(new QFilter[privateFilters.size()]), null);
        }).collect(Collectors.toList());
        allDs = allDs.union(privateDsList.toArray(new DataSet[0]));
        ArrayList<QFilter> otherFilters = new ArrayList<QFilter>(filters);
        otherFilters.add(new QFilter("ctrlstrategy", "in", (Object)new String[]{"1", "2", "3", "4", "6"}));
        List<DataSet> assignDsList = Lists.partition(new ArrayList<Long>(orgIds), (int)1999).stream().map(orgSubList -> {
            ArrayList<QFilter> assignFilters = new ArrayList<QFilter>(otherFilters);
            StringBuilder joinSQL = new StringBuilder("inner join t_bd_accountusereg r on r.fdataid = bd_accountview.fid and r.fuseorgid in (");
            for (int i = 0; i < orgSubList.size(); ++i) {
                joinSQL.append(i > 0 ? ",?" : "?");
            }
            joinSQL.append(") ");
            QFilter regOrgFilter = QFilter.joinSQL((String)"bd_accountview", (String)joinSQL.toString(), (Object[])orgSubList.toArray(new Object[0]));
            assignFilters.add(regOrgFilter);
            return QueryServiceHelper.queryDataSet((String)"query_usereg_account", (String)"bd_accountview", (String)selectFields, (QFilter[])assignFilters.toArray(new QFilter[assignFilters.size()]), null);
        }).collect(Collectors.toList());
        allDs = allDs.union(assignDsList.toArray(new DataSet[0]));
        return allDs.distinct();
    }
}

