/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.accountrepair.impl;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.accounthealth.accountrepair.repair.AccountRepairContext;
import kd.fi.bd.accounthealth.vo.AccountRepairResVO;
import kd.fi.bd.accounthealth.vo.AccountRepairVO;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.interfaces.service.IAccountAssistRepairService;
import kd.fi.bd.util.AccountVersionOpVars;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.AccountVO;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.OrgVO;

public class AccountAssistRepairServiceImpl
implements IAccountAssistRepairService {
    @Override
    public List<AccountRepairResVO> repairAssist(AccountRepairContext ctx, long needRepairOrgId, Set<String> rootAccLongNumbers) {
        if (CollectionUtils.isEmpty(ctx.getAssistIdDynObjMap()) && !ctx.isQtyControl()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u2014\u2014\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u3002", (String)"AccountAssistRepairServiceImpl_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        BiTreeNode<Long, OrgVO> orgTreeNode = ctx.getTreeNode();
        Map<Long, BiTreeNode<Long, OrgVO>> treeNodeMap = BiTreeNode.toMap(orgTreeNode);
        BiTreeNode<Long, OrgVO> orgNode = treeNodeMap.get(needRepairOrgId);
        HashMap<Integer, List<BiTreeNode<Long, OrgVO>>> orgLevelMap = new HashMap<Integer, List<BiTreeNode<Long, OrgVO>>>(8);
        this.postTravelOrgNode(orgNode, orgLevelMap);
        for (String accLongNumber : rootAccLongNumbers) {
            String[] numbers = accLongNumber.split("_");
            String currNumber = numbers[numbers.length - 1];
            String pAccNumber = numbers.length > 1 ? numbers[numbers.length - 2] : numbers[0];
            BiTreeNode parentAccTreeNode = (BiTreeNode)ctx.getOrgToAccTreeTable().get((Object)needRepairOrgId, (Object)pAccNumber);
            Map parentAccTreeNodeMap = BiTreeNode.toMap(parentAccTreeNode);
            BiTreeNode<String, AccountVO> accountVOBiTreeNode = parentAccTreeNodeMap.get(currNumber);
            this.collectAddAssistForCurrAccTree(accountVOBiTreeNode, orgNode, ctx);
        }
        List<AccountRepairResVO> repairResultList = this.doRepairAssist(needRepairOrgId, orgLevelMap, rootAccLongNumbers, ctx);
        return repairResultList;
    }

    protected void collectAddAssistForCurrAccTree(BiTreeNode<String, AccountVO> accountVOBiTreeNode, BiTreeNode<Long, OrgVO> orgNode, AccountRepairContext context) {
        this.collectAddAssistsForCurrAccOnOrgTreeNode(orgNode, accountVOBiTreeNode, context);
        List<BiTreeNode<Long, OrgVO>> subOrgNodeList = orgNode.getChild();
        if (CollectionUtils.isEmpty(subOrgNodeList)) {
            return;
        }
        for (BiTreeNode<Long, OrgVO> subOrgNode : subOrgNodeList) {
            this.collectAddAssistForCurrAccTree(accountVOBiTreeNode, subOrgNode, context);
        }
    }

    protected List<AccountRepairResVO> doRepairAssist(long needRepairOrgId, Map<Integer, List<BiTreeNode<Long, OrgVO>>> orgLevelMap, Set<String> rootAccLongNumbers, AccountRepairContext context) {
        ArrayList<AccountRepairResVO> repairResultList = new ArrayList<AccountRepairResVO>(8);
        List orgLevelSortDescList = orgLevelMap.keySet().stream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        for (Integer orgLevel : orgLevelSortDescList) {
            List<BiTreeNode<Long, OrgVO>> orgNodeList = orgLevelMap.get(orgLevel);
            for (BiTreeNode<Long, OrgVO> orgNode : orgNodeList) {
                Long useOrgId = orgNode.getId();
                boolean repairRes = this.repairInfluentialAccount(orgNode, needRepairOrgId, rootAccLongNumbers, context, repairResultList);
                if (!repairRes) {
                    return repairResultList;
                }
                if (!Objects.equals(useOrgId, needRepairOrgId)) continue;
                return repairResultList;
            }
        }
        return repairResultList;
    }

    protected boolean repairInfluentialAccount(BiTreeNode<Long, OrgVO> orgNode, long needRepairOrgId, Set<String> rootAccLongNumbers, AccountRepairContext context, List<AccountRepairResVO> repairResultList) {
        Long useOrgId = orgNode.getId();
        for (String rootLongAccNumber : rootAccLongNumbers) {
            BiTreeNode<String, AccountVO> accountVOBiTreeNode;
            String[] numbers = rootLongAccNumber.split("_");
            String pAccNumber = numbers.length > 1 ? numbers[numbers.length - 2] : numbers[0];
            BiTreeNode parentAccTreeNode = (BiTreeNode)context.getOrgToAccTreeTable().get((Object)needRepairOrgId, (Object)pAccNumber);
            Map parentAccTreeNodeMap = BiTreeNode.toMap(parentAccTreeNode);
            String currNumber = numbers[numbers.length - 1];
            AccountRepairVO accountRepairVO = (AccountRepairVO)context.getAccountRepairInfoTable().get((Object)useOrgId, (Object)currNumber);
            if (Objects.isNull(accountRepairVO) || Objects.isNull(accountVOBiTreeNode = parentAccTreeNodeMap.get(currNumber))) continue;
            Integer topLevel = ((AccountVO)accountVOBiTreeNode.getData()).getLevel();
            HashMap<Integer, Set<BiTreeNode<String, AccountVO>>> accLevelNodeInfoMap = new HashMap<Integer, Set<BiTreeNode<String, AccountVO>>>(8);
            this.postTravelAccNode(accountVOBiTreeNode, accLevelNodeInfoMap);
            Integer maxAccLevel = (Integer)Collections.max(accLevelNodeInfoMap.keySet());
            for (int accLevel = maxAccLevel.intValue(); accLevel >= topLevel; --accLevel) {
                Set accNodes = (Set)accLevelNodeInfoMap.get(accLevel);
                if (Objects.isNull(accNodes)) continue;
                for (BiTreeNode accNode : accNodes) {
                    boolean repairRes = this.repairCurrAccount(orgNode, accNode, context, needRepairOrgId, repairResultList);
                    if (repairRes) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isNeedVersionForCurrOrg(BiTreeNode<Long, OrgVO> orgNode, BiTreeNode<String, AccountVO> accNode, AccountRepairContext context, List<AccountRepairResVO> repairResultList, long needRepairOrgId) {
        String accNumber = accNode.getId();
        Long parentOrgId = orgNode.getParentId();
        Table<Long, String, AccountRepairVO> accountRepairInfoTable = context.getAccountRepairInfoTable();
        AccountRepairVO accountRepairVO = (AccountRepairVO)accountRepairInfoTable.get((Object)orgNode.getId(), (Object)accNumber);
        AccountRepairVO pAccountRepairVO = (AccountRepairVO)accountRepairInfoTable.get((Object)parentOrgId, (Object)accNumber);
        String checkQtyRes = this.checkQty(accountRepairVO);
        Map<Long, BiTreeNode<Long, OrgVO>> treeNodeMap = BiTreeNode.toMap(context.getTreeNode());
        Long createOrgId = accountRepairVO.getCreateOrgId();
        BiTreeNode<Long, OrgVO> createOrgInfo = treeNodeMap.get(accountRepairVO.getCreateOrgId());
        String orgName = orgNode.getData().getName();
        boolean isSame = false;
        if (Objects.nonNull(pAccountRepairVO)) {
            isSame = Objects.equals(accountRepairVO.getLastVersionId(), pAccountRepairVO.getLastVersionId());
        }
        Tuple<Set<AssistEntryVO>, Set<AssistEntryVO>> assistEntryVOInfo = accountRepairVO.getAccPropInfo().getAssistEntryVOInfo();
        ArrayList<String> details = new ArrayList<String>(8);
        String createOrgName = !Objects.isNull(createOrgInfo) ? createOrgInfo.getData().getName() : BDUtil.getOrgById(createOrgId).getString("name");
        String diffInfoDesc = null;
        if (Objects.nonNull(assistEntryVOInfo)) {
            Set sourceAssistInfoSet = (Set)assistEntryVOInfo.item1;
            Set addAssistInfoSet = (Set)assistEntryVOInfo.item2;
            diffInfoDesc = this.getDiffAssistInfo(sourceAssistInfoSet, addAssistInfoSet, details, context.getAssistIdDynObjMap());
        }
        if (context.getRealRepair().booleanValue()) {
            if (isSame) {
                String repairOrgName = this.getRepairOrgName(accountRepairInfoTable, orgNode, accNumber, needRepairOrgId);
                String desc = ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u7f16\u7801\u4e3a%2$s\u7684\u79d1\u76ee\u5df2\u7531\u4e0a\u7ea7\u7ec4\u7ec7\uff1a%3$s\u5904\u7406\uff0c\u8be5\u7ec4\u7ec7\u65e0\u9700\u5904\u7406\u3002", (String)"AccountAssistRepairServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[]{orgName, accNumber, repairOrgName});
                repairResultList.add(new AccountRepairResVO(BDCommonResource.getSkipText(), desc, String.valueOf(createOrgId), String.valueOf(orgNode.getId()), checkQtyRes, accNumber, diffInfoDesc, context.getVersionDate(), accountRepairVO.getLastVersionId()));
                return false;
            }
        } else {
            repairResultList.add(new AccountRepairResVO("", "", createOrgName, orgName, checkQtyRes, accNumber, String.join((CharSequence)",", details), context.getVersionDate(), accountRepairVO.getLastVersionId()));
        }
        return true;
    }

    protected String getRepairOrgName(Table<Long, String, AccountRepairVO> accountRepairInfoTable, BiTreeNode<Long, OrgVO> orgNode, String accNumber, long rootOrgId) {
        AccountRepairVO currOrgAccRepairInfo = (AccountRepairVO)accountRepairInfoTable.get((Object)orgNode.getId(), (Object)accNumber);
        BiTreeNode parentOrg = orgNode.getParent();
        if (Objects.isNull(parentOrg)) {
            return orgNode.getData().getName();
        }
        Long parentOrgId = (Long)parentOrg.getId();
        if (Objects.equals(parentOrgId, rootOrgId)) {
            return ((OrgVO)parentOrg.getData()).getName();
        }
        AccountRepairVO pOrgAccRepairInfo = (AccountRepairVO)accountRepairInfoTable.get((Object)parentOrgId, (Object)accNumber);
        if (Objects.isNull(pOrgAccRepairInfo)) {
            return orgNode.getData().getName();
        }
        boolean isSame = Objects.equals(currOrgAccRepairInfo.getLastVersionId(), pOrgAccRepairInfo.getLastVersionId());
        if (!isSame || Objects.isNull(orgNode.getParent())) {
            return orgNode.getData().getName();
        }
        return this.getRepairOrgName(accountRepairInfoTable, parentOrg, accNumber, rootOrgId);
    }

    protected String getDiffAssistInfo(Set<AssistEntryVO> sourceAssistInfoSet, Set<AssistEntryVO> addAssistInfoSet, List<String> details, Map<Object, DynamicObject> assistIdDynObjMap) {
        Map<Object, Object> sourceAssistInfoMap = new HashMap(8);
        if (!CollectionUtils.isEmpty(sourceAssistInfoSet)) {
            sourceAssistInfoMap = sourceAssistInfoSet.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x));
        }
        Map<Object, Object> addAssistInfoMap = new HashMap(8);
        if (!CollectionUtils.isEmpty(addAssistInfoSet)) {
            addAssistInfoMap = addAssistInfoSet.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x));
        }
        StringBuilder diffInfoDesc = new StringBuilder();
        int index = 0;
        for (Map.Entry addAssistInfo : addAssistInfoMap.entrySet()) {
            if (index > 0) {
                diffInfoDesc.append("\r\n");
            }
            Long addAssitId = (Long)addAssistInfo.getKey();
            AssistEntryVO assistEntryVO = (AssistEntryVO)addAssistInfo.getValue();
            DynamicObject asstactTypeDy = assistIdDynObjMap.get(addAssitId);
            if (Objects.isNull(asstactTypeDy)) continue;
            String asstactTypeName = asstactTypeDy.getString("name");
            details.add(asstactTypeName);
            diffInfoDesc.append(asstactTypeName);
            if (!sourceAssistInfoMap.containsKey(addAssitId)) {
                String mess = BDCommonResource.getAddText();
                details.add(mess);
                diffInfoDesc.append("\uff1a").append(mess);
            } else {
                AssistEntryVO sourceAssistEntryVO = (AssistEntryVO)sourceAssistInfoMap.get(addAssitId);
                List<String> difEntryFields = this.checkEntryField(assistEntryVO, sourceAssistEntryVO);
                String diffEntryFileds = String.join((CharSequence)",", difEntryFields);
                details.add(String.join((CharSequence)";", difEntryFields));
                diffInfoDesc.append("\uff1a").append(diffEntryFileds);
            }
            ++index;
        }
        return diffInfoDesc.toString();
    }

    protected List<String> checkEntryField(AssistEntryVO assistEntryVO, AssistEntryVO sourceAssistEntryVO) {
        ArrayList<String> diffFields = new ArrayList<String>(8);
        if (assistEntryVO.getAc().booleanValue() && !sourceAssistEntryVO.getAc().booleanValue()) {
            diffFields.add(this.matechNameForProp("isenaccheck"));
        }
        if (assistEntryVO.getLeaf().booleanValue() && !sourceAssistEntryVO.getLeaf().booleanValue()) {
            diffFields.add(this.matechNameForProp("isdetail"));
        }
        if (assistEntryVO.getMustInput().booleanValue() && !sourceAssistEntryVO.getMustInput().booleanValue()) {
            diffFields.add(this.matechNameForProp("isrequire"));
        }
        return diffFields;
    }

    protected String checkQty(AccountRepairVO accountRepairVO) {
        Tuple<Boolean, Boolean> isQty = accountRepairVO.getAccPropInfo().getQty();
        Boolean newQty = (Boolean)isQty.item2;
        if (newQty.booleanValue()) {
            return BDCommonResource.getAddText();
        }
        return null;
    }

    protected boolean repairCurrAccount(BiTreeNode<Long, OrgVO> orgNode, BiTreeNode<String, AccountVO> accNode, AccountRepairContext context, long needRepairOrgId, List<AccountRepairResVO> repairResultList) {
        Long useOrgId = orgNode.getId();
        Table<Long, String, AccountRepairVO> accountRepairInfoTable = context.getAccountRepairInfoTable();
        AccountRepairVO accountRepairVO = (AccountRepairVO)accountRepairInfoTable.get((Object)useOrgId, (Object)accNode.getId());
        if (Objects.isNull(accountRepairVO)) {
            return true;
        }
        Date versionDate = context.getVersionDate();
        Long lastVersionId = accountRepairVO.getLastVersionId();
        Tuple<Set<AssistEntryVO>, Set<AssistEntryVO>> accAssistInfo = accountRepairVO.getAccPropInfo().getAssistEntryVOInfo();
        Tuple<Boolean, Boolean> qtyInfo = accountRepairVO.getAccPropInfo().getQty();
        if ((Objects.isNull(accAssistInfo) || CollectionUtils.isEmpty((Collection)((Collection)accAssistInfo.item2))) && !((Boolean)qtyInfo.item2).booleanValue()) {
            return true;
        }
        if (!this.isNeedVersionForCurrOrg(orgNode, accNode, context, repairResultList, needRepairOrgId) || !context.getRealRepair().booleanValue()) {
            return true;
        }
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)lastVersionId, (String)"bd_accountview");
        OperateOption op = OperateOption.create();
        op.setVariableValue("isPersonalizeData", "1");
        op.setVariableValue("viewsave", "1");
        op.setVariableValue("useOrgID", useOrgId.toString());
        AccountVersionOpVars.setVersioning(op, true);
        AccountVersionOpVars.setIsFromRepairOrAssignView(op, true);
        DynamicObject useOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)useOrgId, (String)"bos_org", (String)"id,number,name");
        account.set("useorg", (Object)useOrg);
        account.set("useorg_id", (Object)useOrg.getLong("id"));
        account.set("startdate", (Object)versionDate);
        if (Objects.nonNull(accAssistInfo) && !CollectionUtils.isEmpty((Collection)((Collection)accAssistInfo.item2))) {
            ArrayList<AssistEntryVO> addingAssistList = new ArrayList<AssistEntryVO>((Collection)accAssistInfo.item2);
            this.buildOperateAccount(account, addingAssistList, context.getAssistIdDynObjMap());
        }
        AccountRepairVO pOrgAccountRepairVO = (AccountRepairVO)accountRepairInfoTable.get((Object)orgNode.getParentId(), (Object)accNode.getId());
        String checkQty = "";
        if (Objects.nonNull(pOrgAccountRepairVO) && !StringUtils.isEmpty((Object)(checkQty = this.checkQty(accountRepairVO)))) {
            account.set("isqty", (Object)true);
        }
        OperationResult rs = OperationServiceHelper.executeOperate((String)"save", (String)"bd_accountview", (DynamicObject[])new DynamicObject[]{account}, (OperateOption)op);
        String diffAssistInfo = null;
        if (Objects.nonNull(accAssistInfo)) {
            diffAssistInfo = this.getDiffAssistInfo((Set)accAssistInfo.item1, (Set)accAssistInfo.item2, new ArrayList<String>(8), context.getAssistIdDynObjMap());
        }
        String repairOrgId = String.valueOf(orgNode.getId());
        if (!rs.isSuccess()) {
            String failedMsg = BDUtil.buildOperationResultFailedMsg(rs, false);
            repairResultList.add(new AccountRepairResVO(BDCommonResource.getFailedText(), failedMsg, repairOrgId, repairOrgId, checkQty, accountRepairVO.getNumber(), diffAssistInfo, context.getVersionDate(), accountRepairVO.getLastVersionId()));
            return false;
        }
        repairResultList.add(new AccountRepairResVO(BDCommonResource.getSuccessText(), "", repairOrgId, repairOrgId, checkQty, accountRepairVO.getNumber(), diffAssistInfo, context.getVersionDate(), accountRepairVO.getLastVersionId()));
        return true;
    }

    protected void buildOperateAccount(DynamicObject operationAccDyn, List<AssistEntryVO> addingAssistList, Map<Object, DynamicObject> assistIdDynObjMap) {
        DynamicObjectCollection assistEntryCollection = operationAccDyn.getDynamicObjectCollection("checkitementry");
        Map<Long, DynamicObject> assistIdEntryMap = assistEntryCollection.stream().collect(Collectors.toMap(x -> x.getLong("asstactitem.id"), x -> x));
        boolean isAssist = false;
        boolean isAc = false;
        int seq = assistEntryCollection.size();
        for (AssistEntryVO assistEntry : addingAssistList) {
            long assistId = assistEntry.getId();
            DynamicObject assistDynObj = assistIdDynObjMap.get(assistId);
            if (assistDynObj == null) continue;
            DynamicObject entryDynObj = assistIdEntryMap.get(assistId);
            if (entryDynObj == null) {
                entryDynObj = assistEntryCollection.addNew();
                entryDynObj.set("seq", (Object)(++seq));
                entryDynObj.set("asstactitem", (Object)assistDynObj);
                entryDynObj.set("enaccheck", (Object)assistEntry.isAc());
                entryDynObj.set("isrequire", (Object)assistEntry.isMustInput());
                entryDynObj.set("isdetail", (Object)assistEntry.isLeaf());
            } else {
                entryDynObj.set("enaccheck", (Object)this.selectFirst(entryDynObj.getBoolean("enaccheck"), assistEntry.isAc()));
                entryDynObj.set("isrequire", (Object)this.selectFirst(entryDynObj.getBoolean("isrequire"), assistEntry.isMustInput()));
                entryDynObj.set("isdetail", (Object)this.selectFirst(entryDynObj.getBoolean("isdetail"), assistEntry.isLeaf()));
            }
            if (assistEntry.isAc()) {
                isAc = true;
            }
            isAssist = true;
        }
        if (isAc) {
            operationAccDyn.set("accheck", (Object)Boolean.TRUE);
        }
        if (isAssist) {
            operationAccDyn.set("isassist", (Object)Boolean.TRUE);
        }
    }

    protected boolean selectFirst(boolean originValue, boolean waitingUpdateValue) {
        return originValue ? originValue : waitingUpdateValue;
    }

    protected void collectAddAssistsForCurrAccOnOrgTreeNode(BiTreeNode<Long, OrgVO> currOrgNode, BiTreeNode<String, AccountVO> accountVOBiTreeNode, AccountRepairContext context) {
        List<BiTreeNode<String, AccountVO>> childAccNodes;
        Set pAddAssists;
        AccountRepairVO pAccRepairInfo;
        Tuple<Set<AssistEntryVO>, Set<AssistEntryVO>> pAccAssistInfos;
        String accNumber = accountVOBiTreeNode.getId();
        Table<Long, String, AccountRepairVO> accountRepairInfoTable = context.getAccountRepairInfoTable();
        Long orgId = currOrgNode.getId();
        Long parentOrgId = currOrgNode.getParentId();
        AccountRepairVO accountRepairVO = (AccountRepairVO)accountRepairInfoTable.get((Object)orgId, (Object)accNumber);
        if (Objects.isNull(accountRepairVO)) {
            return;
        }
        long currOrgAccId = accountRepairVO.getLastVersionId();
        AccountRepairVO pOrgAccInfo = (AccountRepairVO)accountRepairInfoTable.get((Object)parentOrgId, (Object)accNumber);
        this.checkQty(accountVOBiTreeNode, accountRepairInfoTable, orgId, accountRepairVO, parentOrgId);
        HashSet<AssistEntryVO> pOrgDiffAssists = new HashSet<AssistEntryVO>(8);
        Map<Long, Set<AssistEntryVO>> idToAssistMap = context.getIdToAssistMap();
        Set<AssistEntryVO> currOrgAssists = idToAssistMap.get(currOrgAccId);
        if (Objects.nonNull(pOrgAccInfo)) {
            HashSet<AssistEntryVO> pOrgAddAssist;
            Long pOrgAccId = pOrgAccInfo.getLastVersionId();
            Set<AssistEntryVO> pOrgAssists = idToAssistMap.get(pOrgAccId);
            Tuple<Set<AssistEntryVO>, Set<AssistEntryVO>> pOrgAssistInfo = pOrgAccInfo.getAccPropInfo().getAssistEntryVOInfo();
            if (CollectionUtils.isEmpty((Collection)idToAssistMap.get(pOrgAccId)) && Objects.nonNull(pOrgAssistInfo) && CollectionUtils.isEmpty((Collection)((Collection)pOrgAssistInfo.item2))) {
                return;
            }
            if (Objects.nonNull(pOrgAssistInfo) && !CollectionUtils.isEmpty(pOrgAddAssist = new HashSet<AssistEntryVO>((Collection)pOrgAssistInfo.item2))) {
                Set existAssistIds = pOrgAddAssist.stream().map(x -> x.getId()).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(pOrgAssists)) {
                    pOrgAssists.forEach(x -> {
                        if (!existAssistIds.contains(x.getId())) {
                            pOrgAddAssist.add((AssistEntryVO)x);
                            existAssistIds.add(x.getId());
                        }
                    });
                }
                pOrgAssists = pOrgAddAssist;
            }
            if (!CollectionUtils.isEmpty(pOrgAssists)) {
                if (CollectionUtils.isEmpty(currOrgAssists)) {
                    pOrgDiffAssists.addAll(pOrgAssists);
                } else {
                    Set<AssistEntryVO> difAssistList = this.getDifAssistList(pOrgAssists, currOrgAssists);
                    pOrgDiffAssists.addAll(difAssistList);
                }
            }
        }
        Set<AssistEntryVO> parentAccDiffAssists = new HashSet<AssistEntryVO>(8);
        String pAccNumber = accountVOBiTreeNode.getParentId();
        if (!StringUtils.isEmpty((Object)pAccNumber) && Objects.nonNull(pAccAssistInfos = (pAccRepairInfo = (AccountRepairVO)accountRepairInfoTable.get((Object)orgId, (Object)pAccNumber)).getAccPropInfo().getAssistEntryVOInfo()) && !CollectionUtils.isEmpty((Collection)(pAddAssists = (Set)pAccAssistInfos.item2))) {
            if (CollectionUtils.isEmpty(currOrgAssists)) {
                parentAccDiffAssists = pAddAssists;
            } else {
                Set<AssistEntryVO> difAssistList = this.getDifAssistList(pAddAssists, currOrgAssists);
                parentAccDiffAssists.addAll(difAssistList);
            }
        }
        HashSet<AssistEntryVO> addAssistSet = new HashSet<AssistEntryVO>(8);
        if (!CollectionUtils.isEmpty(pOrgDiffAssists) && CollectionUtils.isEmpty(parentAccDiffAssists)) {
            addAssistSet = pOrgDiffAssists;
        }
        if (CollectionUtils.isEmpty(pOrgDiffAssists) && !CollectionUtils.isEmpty(parentAccDiffAssists)) {
            addAssistSet = parentAccDiffAssists;
        }
        if (!CollectionUtils.isEmpty(pOrgDiffAssists) && !CollectionUtils.isEmpty(parentAccDiffAssists)) {
            this.unionDiffAssist(pOrgDiffAssists, parentAccDiffAssists, addAssistSet);
        }
        if (!CollectionUtils.isEmpty(addAssistSet)) {
            accountRepairVO.getAccPropInfo().setAssistEntryVOInfo((Tuple<Set<AssistEntryVO>, Set<AssistEntryVO>>)Tuple.create(currOrgAssists, addAssistSet));
        }
        if (CollectionUtils.isEmpty(childAccNodes = accountVOBiTreeNode.getChild())) {
            return;
        }
        for (BiTreeNode<String, AccountVO> childAccNode : childAccNodes) {
            this.collectAddAssistsForCurrAccOnOrgTreeNode(currOrgNode, childAccNode, context);
        }
    }

    protected void unionDiffAssist(Set<AssistEntryVO> pOrgDiffAssists, Set<AssistEntryVO> parentAccDiffAssists, Set<AssistEntryVO> addAssistSet) {
        addAssistSet.addAll(parentAccDiffAssists);
        Map<Long, AssistEntryVO> currPAccAssistMap = parentAccDiffAssists.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x));
        for (AssistEntryVO pOrgAccassistEntryVO : pOrgDiffAssists) {
            long assistId = pOrgAccassistEntryVO.getId();
            if (currPAccAssistMap.containsKey(assistId)) {
                AssistEntryVO currAssistEntryVO = currPAccAssistMap.get(assistId);
                if (pOrgAccassistEntryVO.getLeaf().booleanValue() && !currAssistEntryVO.getLeaf().booleanValue()) {
                    currAssistEntryVO.setLeaf(true);
                }
                if (pOrgAccassistEntryVO.getMustInput().booleanValue() && !currAssistEntryVO.getMustInput().booleanValue()) {
                    currAssistEntryVO.setMustInput(true);
                }
                if (!pOrgAccassistEntryVO.getAc().booleanValue() || currAssistEntryVO.getAc().booleanValue()) continue;
                currAssistEntryVO.setAc(true);
                continue;
            }
            addAssistSet.add(pOrgAccassistEntryVO);
        }
    }

    protected void checkQty(BiTreeNode<String, AccountVO> accTreeNode, Table<Long, String, AccountRepairVO> accountRepairInfoTable, Long orgId, AccountRepairVO accountRepairVO, long parentOrgId) {
        String pAccNumber;
        AccountRepairVO pOrgAccInfo = (AccountRepairVO)accountRepairInfoTable.get((Object)parentOrgId, (Object)accTreeNode.getId());
        Tuple<Boolean, Boolean> currOrgIsQty = accountRepairVO.getAccPropInfo().getQty();
        if (Objects.nonNull(pOrgAccInfo)) {
            Tuple<Boolean, Boolean> pOrgIsQty = pOrgAccInfo.getAccPropInfo().getQty();
            if ((((Boolean)pOrgIsQty.item1).booleanValue() || ((Boolean)pOrgIsQty.item2).booleanValue()) && !((Boolean)currOrgIsQty.item1).booleanValue()) {
                accountRepairVO.getAccPropInfo().setIsQty((Tuple<Boolean, Boolean>)Tuple.create((Object)currOrgIsQty.item1, (Object)true));
            }
        }
        if (!StringUtils.isEmpty((Object)(pAccNumber = accTreeNode.getParentId()))) {
            Tuple<Boolean, Boolean> pQty = ((AccountRepairVO)accountRepairInfoTable.get((Object)orgId, (Object)pAccNumber)).getAccPropInfo().getQty();
            if ((((Boolean)pQty.item1).booleanValue() || ((Boolean)pQty.item2).booleanValue()) && !((Boolean)currOrgIsQty.item1).booleanValue()) {
                accountRepairVO.getAccPropInfo().setIsQty((Tuple<Boolean, Boolean>)Tuple.create((Object)currOrgIsQty.item1, (Object)true));
            }
        }
    }

    protected Set<AssistEntryVO> getDifAssistList(Set<AssistEntryVO> superAssistList, Set<AssistEntryVO> currAssistList) {
        HashSet<AssistEntryVO> difAssistList = new HashSet<AssistEntryVO>(8);
        Map<Long, AssistEntryVO> superAssistMap = superAssistList.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x));
        Map<Long, AssistEntryVO> currAssistMap = currAssistList.stream().collect(Collectors.toMap(AssistEntryVO::getId, x -> x));
        for (Map.Entry<Long, AssistEntryVO> superAssistInfoMap : superAssistMap.entrySet()) {
            Long assistItemId = superAssistInfoMap.getKey();
            AssistEntryVO superAssistInfo = superAssistInfoMap.getValue();
            AssistEntryVO assistEntryVO = currAssistMap.get(assistItemId);
            if (Objects.isNull(assistEntryVO)) {
                difAssistList.add(superAssistInfo);
                continue;
            }
            Optional<AssistEntryVO> diffRes = this.getDiffEntryVO(superAssistInfo, assistEntryVO);
            if (!diffRes.isPresent()) continue;
            difAssistList.add(diffRes.get());
        }
        return difAssistList;
    }

    protected Optional<AssistEntryVO> getDiffEntryVO(AssistEntryVO superAssistInfo, AssistEntryVO assistEntryVO) {
        boolean parIsRequire = superAssistInfo.getMustInput();
        boolean parIsDetail = superAssistInfo.getLeaf();
        boolean parEnAccheck = superAssistInfo.getAc();
        boolean subIsRequire = assistEntryVO.getMustInput();
        boolean subIsDetail = assistEntryVO.getLeaf();
        boolean subEnAccheck = assistEntryVO.getAc();
        boolean isSame = false;
        AssistEntryVO assEntryVO = new AssistEntryVO(assistEntryVO.getId(), false, false, false);
        if (parIsRequire && !subIsRequire) {
            assEntryVO.setMustInput(parIsRequire);
            isSame = true;
        } else {
            assEntryVO.setAc(assistEntryVO.getMustInput());
        }
        if (parIsDetail && !subIsDetail) {
            assEntryVO.setLeaf(parIsDetail);
            isSame = true;
        } else {
            assEntryVO.setLeaf(assistEntryVO.getLeaf());
        }
        if (parEnAccheck && !subEnAccheck) {
            assEntryVO.setAc(parEnAccheck);
            isSame = true;
        } else {
            assEntryVO.setAc(assistEntryVO.getAc());
        }
        return isSame ? Optional.of(assEntryVO) : Optional.empty();
    }

    protected String matechNameForProp(String prop) {
        String filedName = "";
        switch (prop) {
            case "isrequire": {
                filedName = ResManager.loadKDString((String)"\u5fc5\u5f55", (String)"AccountAssistRepairServiceImpl_3", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "isdetail": {
                filedName = ResManager.loadKDString((String)"\u660e\u7ec6", (String)"AccountAssistRepairServiceImpl_4", (String)"fi-bd-common", (Object[])new Object[0]);
                break;
            }
            case "isenaccheck": {
                filedName = ResManager.loadKDString((String)"\u5f80\u6765", (String)"AccountAssistRepairServiceImpl_5", (String)"fi-bd-common", (Object[])new Object[0]);
            }
        }
        return filedName;
    }

    public void postTravelOrgNode(BiTreeNode<Long, OrgVO> node, Map<Integer, List<BiTreeNode<Long, OrgVO>>> orgLevelMap) {
        OrgVO orgVO = node.getData();
        int level = orgVO.getLevel();
        orgLevelMap.computeIfAbsent(level, k -> new ArrayList(8)).add(node);
        List<BiTreeNode<Long, OrgVO>> subNodes = node.getChild();
        if (CollectionUtils.isEmpty(subNodes)) {
            return;
        }
        for (BiTreeNode<Long, OrgVO> subNode : subNodes) {
            this.postTravelOrgNode(subNode, orgLevelMap);
        }
    }

    public void postTravelAccNode(BiTreeNode<String, AccountVO> accountNode, Map<Integer, Set<BiTreeNode<String, AccountVO>>> accLevelNodeInfoMap) {
        AccountVO accountVo = accountNode.getData();
        Integer accountVoLevel = accountVo.getLevel();
        accLevelNodeInfoMap.computeIfAbsent(accountVoLevel, k -> new HashSet(8)).add(accountNode);
        List<BiTreeNode<String, AccountVO>> subAccNodes = accountNode.getChild();
        if (CollectionUtils.isEmpty(subAccNodes)) {
            return;
        }
        for (BiTreeNode<String, AccountVO> childAcc : subAccNodes) {
            this.postTravelAccNode(childAcc, accLevelNodeInfoMap);
        }
    }
}

