/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.business.service.metadata.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.metadata.IMetadataService;
import kd.fi.bd.business.service.metadata.IModifyParam;
import kd.fi.bd.business.service.metadata.MetadataFile;
import kd.fi.bd.business.service.metadata.enums.MulLang;
import kd.fi.bd.business.service.metadata.utils.XMLUtil;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class MetadataServiceImpl
implements IMetadataService {
    @Override
    public void deployMetadata(List<DeployMetadata> deployMetadataList) {
        try (TXHandle tx = TX.required();){
            try {
                HashSet<String> subFormIds = new HashSet<String>(deployMetadataList.size());
                for (DeployMetadata deployMetadata : deployMetadataList) {
                    MetadataDao.deployMetadata((DeployMetadata)deployMetadata, (String)deployMetadata.getBizunitId(), (String)deployMetadata.getBizappId());
                    if (deployMetadata.isMultilanguage()) continue;
                    for (AbstractDesignMeta abstractDesignMeta : deployMetadata.getDesignMetas()) {
                        if (!(abstractDesignMeta instanceof DesignMeta)) continue;
                        DesignMeta designMeta = (DesignMeta)abstractDesignMeta;
                        if ("2".equalsIgnoreCase(designMeta.getDevType())) {
                            subFormIds.add(designMeta.getMasterId());
                            continue;
                        }
                        subFormIds.add(designMeta.getId());
                    }
                }
                MetadataDao.clearSubRuntimeMeta(new ArrayList(subFormIds));
                for (String subFormId : subFormIds) {
                    MetadataDao.rebuildRuntimeMetaById((String)subFormId);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Override
    public DeployMetadata deserializeFromString(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        return (DeployMetadata)serializer.deserializeFromString(content, null);
    }

    @Override
    public List<DeployMetadata> loadMetadataFromResource(MetadataFile metadataFile) {
        ArrayList<DeployMetadata> result = new ArrayList<DeployMetadata>(2);
        String formNumber = metadataFile.getFormNumber();
        String subDir = metadataFile.getSubDir();
        result.add(this.load(subDir, formNumber + ".dym"));
        MulLang[] mulLang = metadataFile.getMulLang();
        if (mulLang != null) {
            for (MulLang lang : mulLang) {
                result.add(this.load(subDir, lang.getMetadataFileName(formNumber)));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeployMetadata load(String subDir, String fileName) {
        String path = StringUtils.isNotEmpty((String)subDir) ? "metadata/" + subDir : "metadata/";
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path + fileName);){
            if (inputStream == null) {
                throw new IllegalArgumentException("not find metadata: " + fileName);
            }
            DeployMetadata deployMetadata = this.deserializeFromString(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            return deployMetadata;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void modify(DeployMetadata deployMetadata, IModifyParam ... params) {
        for (AbstractDesignMeta designMeta : deployMetadata.getDesignMetas()) {
            Document dataXML = null;
            try {
                for (IModifyParam param : params) {
                    boolean modifiable = param.modifiable(designMeta);
                    if (!modifiable) continue;
                    if (dataXML == null) {
                        dataXML = XMLUtil.parseString(designMeta.getDataXml());
                    }
                    XMLUtil.updateNodeValue(dataXML, param.getModifyArgs());
                }
                if (dataXML == null) continue;
                designMeta.setDataXml(XMLUtil.xmlToString(dataXML));
            }
            catch (IOException | DocumentException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

