/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.cfversion.addassist;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.cfversion.addassist.CfitemAddingAssistService;
import kd.fi.bd.enhance.treetask.CashflowAddingAssistAdapter;
import kd.fi.bd.enhance.treetask.CfitemContext;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.bd.vo.AssistEntryVO;
import kd.fi.bd.vo.CashflowItemVo;
import kd.fi.bd.vo.OrgCfitemOwnershipVO;
import kd.fi.bd.vo.OrgVO;

public class CfitemAssistAddingContext {
    private static final Log LOG = LogFactory.getLog(CfitemAssistAddingContext.class);
    private final CfitemAddingAssistService addingAssistService;
    private final BiTreeNode<Long, OrgVO> rootOrg;
    private final long rootItemId;
    private final BiTreeNode<String, CashflowItemVo> rootCfItem;
    private DependBiTreeNode<CfitemContext> rootTask;
    private final String rootItemNumber;
    private final Date versionDate;
    private final List<AssistEntryVO> addingAssitList;
    private List<Long> useOrgIdList;
    private Map<Long, OrgCfitemOwnershipVO> orgCfitemNumberShip;
    private Set<Long> allCfitemIdSet;
    private Set<Long> allCreateOrgCfitemIdSet;
    private Map<Long, Map<String, Boolean>> orgIdCfitemIncudeAssistMap;
    private Map<Long, DynamicObject> itemId2DynMap;
    private Map<Long, DynamicObject> orgIdDynObjMap;
    private Map<Long, DynamicObject> assistIdDynObjMap;
    private Table<Long, Long, Integer> orgIditemIdBizTable;
    private Map<String, List<DynamicObject>> periodMap;
    private Set<Long> periodTypeIds;

    public CfitemAssistAddingContext(long rootCfitemId, long rootOrgId, Date versionDate, List<AssistEntryVO> addingAssitList, CfitemAddingAssistService addingAssistService) {
        long masterId;
        long tick = System.currentTimeMillis();
        this.addingAssistService = addingAssistService;
        DynamicObject cfitemObj = addingAssistService.queryCfitemObj(rootCfitemId, "number", "longnumber", "ctrlstrategy");
        boolean isShareCtrlStrategy = AccountVersionUtil.isShareCtrlStrategy(cfitemObj);
        this.rootItemNumber = cfitemObj.getString("number");
        this.rootItemId = masterId = CashflowItemVersionUtil.getCurrOrgFirstMasterId(rootCfitemId, rootOrgId, this.rootItemNumber);
        this.versionDate = versionDate;
        this.addingAssitList = Collections.unmodifiableList(addingAssitList);
        this.rootOrg = addingAssistService.buildSubTreeByOrgId(10, rootOrgId);
        if (isShareCtrlStrategy) {
            this.useOrgIdList = new ArrayList<Long>(10);
            this.useOrgIdList.add(rootOrgId);
            List<BiTreeNode<Long, OrgVO>> childs = this.rootOrg.getChild();
            if (!childs.isEmpty()) {
                for (int i = childs.size() - 1; i >= 0; --i) {
                    childs.get(i).disconnectParent();
                }
            }
        } else {
            this.useOrgIdList = Collections.unmodifiableList(new ArrayList<Long>(this.rootOrg.collect(BiTreeNode::getId)));
        }
        this.rootCfItem = addingAssistService.buildSubTreeByCfitemNumber(this.rootItemNumber, cfitemObj.getString("longnumber"), this.useOrgIdList);
        this.initContext();
        LOG.info(String.format("assist_adding_context initialization on org: %s, account id: %s cost: %s", rootOrgId, rootCfitemId, System.currentTimeMillis() - tick));
    }

    public final void initContext() {
        this.orgCfitemNumberShip = this.addingAssistService.getAllSubLatestCfitemInfoInUseOrgRange(this.rootItemId, this.useOrgIdList, this.versionDate);
        LOG.info(String.format("org_acc_number_ship init is : %s", this.orgCfitemNumberShip.values().stream().map(x -> x.getLogStr()).collect(Collectors.joining("\n"))));
        this.allCfitemIdSet = this.orgCfitemNumberShip.values().stream().flatMap(x -> x.getAllCfIds().stream()).collect(Collectors.toSet());
        this.itemId2DynMap = this.addingAssistService.loadCfitemIdDynObjMap(this.allCfitemIdSet);
        this.allCreateOrgCfitemIdSet = this.itemId2DynMap.values().stream().filter(x -> this.useOrgIdList.contains(x.getLong("createorg_id"))).map(x -> x.getLong("id")).collect(Collectors.toSet());
        this.orgIdDynObjMap = this.addingAssistService.loadOrgIdDynObjMap(this.useOrgIdList);
        Set<Long> assistIdSet = this.addingAssitList.stream().map(AssistEntryVO::getId).collect(Collectors.toSet());
        this.assistIdDynObjMap = this.addingAssistService.loadAssistIdDynObjMap(assistIdSet);
        this.orgIdCfitemIncudeAssistMap = this.addingAssistService.isCfitemIncludeAssist(this.orgCfitemNumberShip, this.addingAssitList);
        Map<Long, Set<Long>> orgAccountMap = this.orgCfitemNumberShip.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((OrgCfitemOwnershipVO)x.getValue()).getLatestCfIds()));
        this.orgIditemIdBizTable = this.addingAssistService.batchCheckAfterSpecificDate(orgAccountMap, this.versionDate);
        this.periodMap = new HashMap<String, List<DynamicObject>>(8);
        this.periodTypeIds = BDUtil.getPeriodType();
    }

    public final void initRootTask() {
        CashflowAddingAssistAdapter adapter = new CashflowAddingAssistAdapter();
        DependBiTreeNode rootTask = adapter.buildAccOrgTree(this.rootOrg, this.rootCfItem, this);
        this.rootTask = rootTask;
    }

    public Optional<Long> tryGetCfitemIdByOrgAndCfNum(long orgId, String number) {
        OrgCfitemOwnershipVO ownershipVO = this.getOrgCfitemNumberShip().get(orgId);
        if (Objects.isNull(ownershipVO)) {
            return Optional.empty();
        }
        Map<String, Long> cfitemNumberIdMap = ownershipVO.getNumberLatestCfId();
        Long itemId = cfitemNumberIdMap.get(number);
        if (Objects.isNull(itemId)) {
            return Optional.empty();
        }
        return Optional.of(itemId);
    }

    public Long getRootOrgId() {
        return this.rootOrg.getId();
    }

    public Long getRootItemId() {
        return this.rootItemId;
    }

    public String getRootItemNumber() {
        return this.rootItemNumber;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public List<AssistEntryVO> getAddingAssitList() {
        return this.addingAssitList;
    }

    public List<Long> getUseOrgIdList() {
        return this.useOrgIdList;
    }

    public void setUseOrgIdList(List<Long> useOrgIdList) {
        this.useOrgIdList = useOrgIdList;
    }

    public BiTreeNode<Long, OrgVO> getRootOrg() {
        return this.rootOrg;
    }

    public BiTreeNode<String, CashflowItemVo> getRootCfItem() {
        return this.rootCfItem;
    }

    public Map<Long, OrgCfitemOwnershipVO> getOrgCfitemNumberShip() {
        return this.orgCfitemNumberShip;
    }

    public Set<Long> getAllCfitemIdSet() {
        return this.allCfitemIdSet;
    }

    public Set<Long> getAllCreateOrgCfitemIdSet() {
        return this.allCreateOrgCfitemIdSet;
    }

    public Map<Long, Map<String, Boolean>> getOrgIdCfitemIncudeAssistMap() {
        return this.orgIdCfitemIncudeAssistMap;
    }

    public Map<Long, DynamicObject> getItemId2DynMap() {
        return this.itemId2DynMap;
    }

    public Map<Long, DynamicObject> getOrgIdDynObjMap() {
        return this.orgIdDynObjMap;
    }

    public Map<Long, DynamicObject> getAssistIdDynObjMap() {
        return this.assistIdDynObjMap;
    }

    public Table<Long, Long, Integer> getOrgIditemIdBizTable() {
        return this.orgIditemIdBizTable;
    }

    public DependBiTreeNode<CfitemContext> getRootTask() {
        return this.rootTask;
    }

    public Map<String, List<DynamicObject>> getPeriodMap() {
        return this.periodMap;
    }

    public void setPeriodMap(Map<String, List<DynamicObject>> periodMap) {
        this.periodMap = periodMap;
    }

    public Set<Long> getPeriodTypeIds() {
        return this.periodTypeIds;
    }

    public void setPeriodTypeIds(Set<Long> periodTypeIds) {
        this.periodTypeIds = periodTypeIds;
    }
}

