/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.checktools.account.check.AccountCheckType;
import kd.fi.bd.checktools.account.check.CheckHandle;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;

public class CheckTask
extends AbstractTask
implements FIDataCheckTask {
    private Log logger = LogFactory.getLog(CheckTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] tableObjs;
        String tenantId = RequestContext.get().getTenantId();
        String tenantName = RequestContext.get().getTenantInfo().getName();
        for (DynamicObject tableObj : tableObjs = BusinessDataServiceHelper.load((String)"bd_accounttable", (String)"id", null)) {
            ControlCheckCtx ctx = new ControlCheckCtx(null, tableObj.getLong("id"), AccountCheckType.ALL, null);
            new CheckHandle(ctx).handle();
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select forgid,forgname,faccountnumber,fresult,fdesc,ftype from t_bd_accountcheckrs where fresult='failed'", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"AccountAssistVersionControlCheckerTask", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sb);){
            for (Row row : dataSet) {
                Long forgid = row.getLong("forgid");
                this.logger.error("###### AccountAssistVersionControlCheckerTask acct data is repeat, please check![tenantId:" + tenantId + ",tenantName:" + tenantName + "]");
            }
        }
    }

    public boolean execute() {
        DynamicObject[] tableObjs;
        String tenantId = RequestContext.get().getTenantId();
        boolean result = true;
        String tenantName = RequestContext.get().getTenantInfo().getName();
        for (DynamicObject tableObj : tableObjs = BusinessDataServiceHelper.load((String)"bd_accounttable", (String)"id", null)) {
            ControlCheckCtx ctx = new ControlCheckCtx(null, tableObj.getLong("id"), AccountCheckType.ALL, null);
            new CheckHandle(ctx).handle();
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select forgid,forgname,faccountnumber,fresult,fdesc,ftype from t_bd_accountcheckrs where fresult='failed'", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"AccountAssistVersionControlCheckerTask", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sb);){
            if (dataSet != null && dataSet.hasNext()) {
                this.logger.error("###### AccountAssistVersionControlCheckerTask acct data is repeat, please check![tenantId:" + tenantId + ",tenantName:" + tenantName + "]");
                String checkResult = ResManager.loadKDString((String)"\u79d1\u76ee\u68c0\u67e5\u5de5\u5177\u68c0\u67e5\u51fa\u53ef\u80fd\u5b58\u5728\u95ee\u9898\u7684\u79d1\u76ee\u6570\u636e", (String)"CheckTask_0", (String)"fi-bd-common", (Object[])new Object[0]);
                FIDataCheckUtil.saveResult((String)"acctcheck", (String)"fibd", (boolean)false, (String)checkResult, (String)"AccountAssistVersionControlCheckerTask");
                boolean bl = false;
                return bl;
            }
        }
        return result;
    }
}

