/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.OrgVO;

public class SameLevelAcctCheck
extends AbstractFormPlugin {
    private List<Object[]> params = new ArrayList<Object[]>(500);
    private String sql = "insert into t_bd_accountcheckrs(fid,forgid,forgname,fdesc) values(?,?,?,?)";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "checkacct": {
                this.createRstTable();
                this.check();
                this.saveData();
                break;
            }
            case "checksamelevel": {
                this.createRstTable();
                this.checkSameLevel();
                this.saveData();
            }
        }
    }

    private void checkSameLevel() {
        Long accttableId = ((DynamicObject)this.getModel().getValue("accounttable")).getLong("id");
        BiTreeNode<Long, OrgVO> treeNode = BDUtil.buildSubTreeByOrgId(Optional.of(OrgUnitServiceHelper.getRootOrgId()));
        List<BiTreeNode<Long, OrgVO>> child = treeNode.getChild();
        this.checkSameLevel(child, accttableId, treeNode);
    }

    private void checkSameLevel(List<BiTreeNode<Long, OrgVO>> treeNode, Long accttableId, BiTreeNode<Long, OrgVO> parent) {
        if (treeNode.isEmpty()) {
            return;
        }
        if (this.params.size() > 500) {
            this.saveData();
        }
        List<Object> orgIds = treeNode.stream().map(x -> (Long)x.getId()).collect(Collectors.toList());
        orgIds.add(parent.getId());
        Map<Long, Set<String>> map = this.listUsedAccountNumbers(accttableId, orgIds);
        HashMap levelMap = new HashMap(map.size());
        for (Map.Entry<Long, Set<String>> entry : map.entrySet()) {
            Set<String> nums = entry.getValue();
            Map setMap = nums.parallelStream().collect(Collectors.groupingBy(x -> x.split("\\.").length, Collectors.toSet()));
            levelMap.put(entry.getKey(), setMap);
        }
        Map curNum = (Map)levelMap.remove(parent.getId());
        for (BiTreeNode<Long, OrgVO> node : treeNode) {
            HashMap leafNum = levelMap.get(node.getId()) == null ? new HashMap() : (Map)levelMap.get(node.getId());
            for (Map.Entry leaf : leafNum.entrySet()) {
                int level = (Integer)leaf.getKey();
                Set<String> leafSet = leaf.getValue() != null ? (Set)leaf.getValue() : new HashSet();
                Set parentNum = (Set)curNum.get(level);
                if (leaf.getValue() == null || ((Set)leaf.getValue()).size() <= 0 || parentNum == null) continue;
                leafSet.removeAll(parentNum);
                if (leafSet.isEmpty()) continue;
                Set<String> newSet = this.clearOnlyLeafNumber(leafSet, parentNum);
                leafSet.removeAll(newSet);
                if (leafSet.isEmpty()) continue;
                this.params.add(this.buildObject(node, leafSet.toString(), parent.getData().getName()));
            }
            List<BiTreeNode<Long, OrgVO>> child = node.getChild();
            this.checkSameLevel(child, accttableId, parent);
        }
    }

    private Set<String> clearOnlyLeafNumber(Set<String> leafSet, Set<String> parentNum) {
        HashSet<String> rvmSet = new HashSet<String>(10);
        for (String s : leafSet) {
            int endIndex = s.lastIndexOf(".") == -1 ? s.length() - 1 : s.lastIndexOf(".");
            String _parentNum = s.substring(0, endIndex);
            boolean exist = false;
            for (String num : parentNum) {
                if (!num.startsWith(_parentNum)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            rvmSet.add(s);
        }
        return rvmSet;
    }

    private void check() {
        Long accttableId = ((DynamicObject)this.getModel().getValue("accounttable")).getLong("id");
        BiTreeNode<Long, OrgVO> treeNode = BDUtil.buildSubTreeByOrgId(Optional.of(OrgUnitServiceHelper.getRootOrgId()));
        List<BiTreeNode<Long, OrgVO>> child = treeNode.getChild();
        this.check(child, accttableId, treeNode);
    }

    private void check(List<BiTreeNode<Long, OrgVO>> treeNode, Long accttableId, BiTreeNode<Long, OrgVO> parent) {
        if (treeNode.isEmpty()) {
            return;
        }
        if (this.params.size() > 500) {
            this.saveData();
        }
        List<Object> orgIds = treeNode.stream().map(x -> (Long)x.getId()).collect(Collectors.toList());
        orgIds.add(parent.getId());
        Map<Long, Set<String>> map = this.listUsedAccountNumbers(accttableId, orgIds);
        Set<String> curNum = map.remove(parent.getId());
        for (BiTreeNode<Long, OrgVO> node : treeNode) {
            HashSet leafNum = map.get(node.getId()) == null ? new HashSet() : map.get(node.getId());
            leafNum.removeAll(curNum);
            if (!leafNum.isEmpty()) {
                this.params.add(this.buildObject(node, ((Object)leafNum).toString(), parent.getData().getName()));
            }
            List<BiTreeNode<Long, OrgVO>> child = node.getChild();
            this.check(child, accttableId, parent);
        }
    }

    private void saveData() {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)this.sql, this.params);
        this.params.clear();
    }

    private Object[] buildObject(BiTreeNode<Long, OrgVO> node, String nums, String parname) {
        String desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u6bd4\u4e0a\u7ea7%2$s\u591a\u4e86\u4ee5\u4e0b\u79d1\u76ee\uff1a%3$s", (String)"SameLevelAcctCheck_0", (String)"fi-bd-common", (Object[])new Object[0]), node.getData().getName(), parname, nums);
        if (desc.length() > 400) {
            desc = desc.substring(0, 400);
        }
        return new Object[]{DB.genLongId((String)"t_bd_accountcheckrs"), node.getId(), node.getData().getName() == null ? " " : Boolean.valueOf(node.getData().getName() == null), desc};
    }

    private Map<Long, Set<String>> listUsedAccountNumbers(Long accTableId, List<Object> useOrgIds) {
        Preconditions.checkArgument((boolean)Objects.nonNull(accTableId));
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT u.FUSEORGID, a.FNUMBER from t_bd_account a ", new Object[0]);
        sqlBuilder.append(" inner join t_bd_account_u u ON a.fid = u.FDataID ", new Object[0]);
        sqlBuilder.append(" WHERE a.FACCOUNTTABLEID = ?", new Object[]{accTableId});
        sqlBuilder.appendIn(" AND u.fuseorgid ", useOrgIds);
        return (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<Long, Set<String>>>(){

            public Map<Long, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>();
                while (rs.next()) {
                    Set num = map.computeIfAbsent(rs.getLong("FUSEORGID"), k -> new HashSet());
                    num.add(rs.getString("FNUMBER"));
                }
                return map;
            }
        });
    }

    private void createRstTable() {
        boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)"fi"), (String)"t_bd_accountcheckrs");
        if (exitsTable) {
            StringBuilder createTbSql = new StringBuilder();
            createTbSql.append("delete from t_bd_accountcheckrs ");
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)createTbSql.toString());
        } else {
            StringBuilder createTbSql = new StringBuilder();
            createTbSql.append("CREATE TABLE t_bd_accountcheckrs( ").append(" FID BIGINT DEFAULT 0 NOT NULL primary key, ").append(" forgid bigint DEFAULT 0 not null, ").append(" forgname varchar(255) DEFAULT(' ') not null, ").append(" faccountnumber varchar(255) DEFAULT(' ') not null, ").append(" fresult varchar(40) DEFAULT(' ') not null, ").append(" fdesc varchar(500) DEFAULT(' ') not null, ").append(" ftype varchar(80) DEFAULT(' ') not null ").append(")");
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)createTbSql.toString());
        }
    }
}

