/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.accountchecktools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.fi.bd.util.POIUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AccountCheckUtil {
    private static final Log logger = LogFactory.getLog(AccountCheckUtil.class);
    protected static final DBRoute DB_ROUTE = DBRoute.of((String)"fi");

    public static Optional<String> downLoadErrorData(IFormView view, SXSSFWorkbook wb, String fileName) {
        RequestContext ctx = RequestContext.get();
        String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)view.getServiceAppId(view.getPageId()), (String)UUID.randomUUID().toString(), (String)fileName);
        try {
            String downUrl = POIUtils.getAttachmentDownloadUrl(wb, fileName, path);
            downUrl = downUrl + "&fId=" + view.getEntityId() + "&appId=" + view.getServiceAppId(view.getPageId());
            return Optional.of(downUrl);
        }
        catch (IOException ioException) {
            logger.info("upload excel error : {}", (Object)ioException.getMessage());
            return Optional.empty();
        }
    }

    public static boolean checkToRepair(IFormView view) {
        return Objects.isNull(view) ? false : Boolean.parseBoolean(view.getPageCache().get(view.getPageId()));
    }

    public static Set<Long> getSelectOrgs(long accountTableOrgId) {
        ArrayList<Long> selectOrgs = new ArrayList<Long>(8);
        selectOrgs.add(accountTableOrgId);
        return new HashSet<Long>(OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", selectOrgs, (boolean)true));
    }
}

