/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.asst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.checktools.account.check.asst.AbstractAccountCheckSubscribe;
import kd.fi.bd.checktools.account.check.asst.AccountCheckEvent;
import kd.fi.bd.checktools.account.check.asst.OrgAccount;
import kd.fi.bd.checktools.account.check.asst.OrgSingleAccountCtx;
import kd.fi.bd.util.AccountVersionUtil;

public class BuildDatas
extends AbstractAccountCheckSubscribe {
    @Override
    protected boolean process(AccountCheckEvent accountCheckEvent) throws Exception {
        boolean doNext = true;
        OrgSingleAccountCtx orgSingleAccountCtx = accountCheckEvent.getAccountChecker().getOrgSingleAccountCtx();
        doNext = orgSingleAccountCtx.isFather() ? this.queryDatas(orgSingleAccountCtx, f -> {
            SqlBuilder sql = new SqlBuilder();
            sql.append(" select a.fid ", new Object[0]).append("id", new Object[0]);
            sql.append(" from  t_bd_account_u u ", new Object[0]);
            sql.append(" inner join t_bd_account a ON u.fdataid=a.fid ", new Object[0]);
            sql.append(" where a.faccounttableid= ? ", new Object[]{f.getCtx().getAccountTableId()});
            sql.append(" and u.FUSEORGID = ? ", new Object[]{f.getOrgId()});
            ArrayList<Long> returnObjs = new ArrayList<Long>(10);
            try (DataSet dataSet = DB.queryDataSet((String)"LongNumberCheckSubscribeServiceImpl", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
                for (Row row : dataSet) {
                    returnObjs.add(row.getLong("id"));
                }
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            qFilterList.add(new QFilter("id", "in", returnObjs));
            return qFilterList;
        }) : this.queryDatas(orgSingleAccountCtx, f -> {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
            qFilterList.add(new QFilter("createorg.id", "=", (Object)f.getOrgId()));
            return qFilterList;
        });
        return doNext;
    }

    private boolean queryDatas(OrgSingleAccountCtx orgSingleAccountCtx, Function<OrgSingleAccountCtx, List<QFilter>> func) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.addAll((Collection)func.apply(orgSingleAccountCtx));
        qFilterList.add(new QFilter("accounttable.id", "=", (Object)orgSingleAccountCtx.getCtx().getAccountTableId()));
        qFilterList.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bd_accountview");
        Map accountsIdMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataEntityType, (QFilter[])qFilterList.toArray(new QFilter[0]));
        if (accountsIdMap == null || accountsIdMap.size() == 0) {
            return false;
        }
        HashMap<String, Set<OrgAccount>> accountsNumMap = new HashMap<String, Set<OrgAccount>>(accountsIdMap.size());
        for (Map.Entry accountsIdMapEntry : accountsIdMap.entrySet()) {
            DynamicObject accountObj = (DynamicObject)accountsIdMapEntry.getValue();
            accountsNumMap.compute(accountObj.getString("number"), (K, V) -> {
                if (V == null) {
                    V = new HashSet<OrgAccount>(10);
                }
                V.add(new OrgAccount(accountObj));
                return V;
            });
        }
        orgSingleAccountCtx.setAccounts(accountsNumMap);
        return true;
    }
}

