/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.asst;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.asst.AbstractAccountCheckSubscribe;
import kd.fi.bd.checktools.account.check.asst.AccountCheckEvent;
import kd.fi.bd.checktools.account.check.asst.OrgAccount;
import kd.fi.bd.checktools.account.check.asst.OrgSingleAccountCtx;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class CheckSubscribeWithOwnExcuter
extends AbstractAccountCheckSubscribe {
    @Override
    protected boolean process(AccountCheckEvent accountCheckEvent) throws Exception {
        OrgSingleAccountCtx orgSingleAccountCtx = accountCheckEvent.getAccountChecker().getOrgSingleAccountCtx();
        ControlCheckCtx ctx = orgSingleAccountCtx.getCtx();
        Map<String, Set<OrgAccount>> accounts = orgSingleAccountCtx.getAccounts();
        for (Map.Entry<String, Set<OrgAccount>> entry : accounts.entrySet()) {
            String k = entry.getKey();
            Set<OrgAccount> v = entry.getValue();
            for (OrgAccount orgAccount : v) {
                Map<String, Object> parentProp;
                DynamicObject account = orgAccount.getAccount();
                DynamicObject paccount = account.getDynamicObject("parent");
                if (paccount == null) continue;
                paccount = BusinessDataServiceHelper.loadSingle((Object)paccount.getLong("id"), (String)"bd_accountview");
                Map<String, Object> accountProp = AccountVersionControlChecker.getAccountProp(account);
                Optional<String> errMsg = AccountVersionControlChecker.validateAccountControlRelation(accountProp, parentProp = AccountVersionControlChecker.getAccountProp(paccount), AccountVersionControlChecker.AccPropType.allTypes());
                if (!errMsg.isPresent()) continue;
                String createorgName = Optional.ofNullable(account.getString("createorg.name")).orElseGet(() -> "null");
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u79d1\u76ee\uff0c\u4e0e\u7ec4\u7ec7\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u79d1\u76ee\u4e0d\u6ee1\u8db3\u7ba1\u63a7\u5173\u7cfb\u3002", (String)"ChecksWithOwnExcuter_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), paccount.getString("createorg.name") + "(" + paccount.getString("createorg.number") + ")", paccount.getString("name") + "(" + paccount.getString("number") + ")", createorgName + "(" + account.getString("createorg.number") + ")", account.getString("name") + "(" + account.getString("number") + ")") + errMsg.get();
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(account.getString("number"), orgSingleAccountCtx.getOrgId());
                ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u540c\u7ec4\u7ec7\u4e0a\u4e0b\u7ea7\u79d1\u76ee", (String)"ChecksWithOwnExcuter_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            }
        }
        return true;
    }
}

