/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.asst.AccountChecker;
import kd.fi.bd.checktools.account.check.asst.BuildDatas;
import kd.fi.bd.checktools.account.check.asst.CheckSubscribeWithOwnExcuter;
import kd.fi.bd.checktools.account.check.asst.CheckSubscribeWithSupOrgExcuter;
import kd.fi.bd.checktools.account.check.asst.IsChildCreate;
import kd.fi.bd.checktools.account.check.asst.OrgSingleAccountCtx;

public class AsstCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    private Log logger = LogFactory.getLog(AsstCheckSubscribeServiceImpl.class);
    private Set<Long> childIds = new HashSet<Long>(1000);

    public AsstCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
        ctx.buildOrgNodes();
    }

    @Override
    protected boolean process() {
        block5: {
            block4: {
                try {
                    HashSet<Long> topOrgIdSet = new HashSet<Long>(1);
                    topOrgIdSet.add(this.ctx.getTopOrgId());
                    this.doCheckSupOrg(this.ctx.getTopOrgId());
                    this.checkSupOrgFunc(topOrgIdSet);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    if (this.ctx.getView() == null) break block4;
                    this.ctx.getView().getPageCache().put("msg", e.getMessage());
                }
            }
            try {
                this.doCheckOwn();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                if (this.ctx.getView() == null) break block5;
                this.ctx.getView().getPageCache().put("msg", e.getMessage());
            }
        }
        return true;
    }

    private void checkSupOrgFunc(Set<Long> orgIds) throws Exception {
        this.childIds.clear();
        for (Long orgId : orgIds) {
            this.childIds.addAll(this.ctx.getOrgTreeNode().get(orgId).getChildIds());
        }
        if (this.childIds.size() == 0) {
            return;
        }
        for (Long childId : this.childIds) {
            if (childId == null) continue;
            this.doCheckSupOrg(childId);
        }
        this.checkSupOrgFunc(this.childIds);
    }

    private void doCheckSupOrg(Long orgId) throws Exception {
        OrgSingleAccountCtx porgSingleAccountCtx = new OrgSingleAccountCtx(orgId, this.ctx, true);
        AccountChecker paccountChecker = new AccountChecker(porgSingleAccountCtx, null);
        paccountChecker.addAccountChecks(new BuildDatas());
        paccountChecker.check();
        HashSet<Long> childIds = new HashSet<Long>(1000);
        this.collectAllOrgIds(childIds, orgId);
        CountDownLatch cdl = new CountDownLatch(childIds.size());
        for (Long childId : childIds) {
            ThreadService.execute(() -> {
                try {
                    OrgSingleAccountCtx orgSingleAccountCtx = new OrgSingleAccountCtx(childId, this.ctx, false);
                    AccountChecker accountChecker = new AccountChecker(orgSingleAccountCtx, porgSingleAccountCtx);
                    accountChecker.addAccountChecks(new BuildDatas()).addAccountChecks(new IsChildCreate()).addAccountChecks(new CheckSubscribeWithSupOrgExcuter());
                    accountChecker.check();
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.FIBD_ACCOUNT_ASST_CHECK_SUBSCRIBE_TASK);
        }
        try {
            boolean await = cdl.await(7200L, TimeUnit.SECONDS);
            if (!await) {
                this.logger.error("AsstCheckSubscribeServiceImpl_doCheckSupOrg_timeOut");
            }
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
        }
    }

    private void collectAllOrgIds(Set<Long> allOrgIds, Long orgId) {
        if (orgId == null) {
            return;
        }
        Set<Long> childIds = this.ctx.getOrgTreeNode().get(orgId).getChildIds();
        if (childIds == null || childIds.size() == 0) {
            return;
        }
        allOrgIds.addAll(childIds);
        for (Long childId : childIds) {
            this.collectAllOrgIds(allOrgIds, childId);
        }
    }

    private void doCheckOwn() throws KDBizException {
        Set<Long> allOrgIds = this.ctx.getOrgTreeNode().keySet();
        CountDownLatch cdl = new CountDownLatch(allOrgIds.size());
        for (Long childId : allOrgIds) {
            ThreadService.execute(() -> {
                try {
                    OrgSingleAccountCtx orgSingleAccountCtx = new OrgSingleAccountCtx(childId, this.ctx, false);
                    AccountChecker accountChecker = new AccountChecker(orgSingleAccountCtx, null);
                    accountChecker.addAccountChecks(new BuildDatas()).addAccountChecks(new CheckSubscribeWithOwnExcuter());
                    accountChecker.check();
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                    throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.FIBD_ACCOUNT_ASST_CHECK_SUBSCRIBE_TASK);
        }
        try {
            boolean await = cdl.await(7200L, TimeUnit.SECONDS);
            if (!await) {
                this.logger.error("AsstCheckSubscribeServiceImpl_doCheckOwn_timeOut");
            }
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
            throw new KDBizException(new ErrorCode("common", "%s"), new Object[]{e.getMessage()});
        }
    }
}

