/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class AsstRepeatCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    public AsstRepeatCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select  a.fnumber ,a.fcreateorgid from  (select distinct fid from t_bd_accountasstactitem  ", new Object[0]);
        sql.append(" group by fasstactitemid,fid having count(fasstactitemid)>1 ) s inner join t_bd_account a ", new Object[0]);
        sql.append(" on s.fid =a.fid where a.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)"AsstRepeatCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                long orgId = row.getLong("fcreateorgid");
                String number = row.getString("fnumber");
                DynamicObject bosOrg = this.ctx.getOrgById(orgId);
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", orgId);
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"FirstLevelSubscribeServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"FirstLevelSubscribeServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u91cd\u590d\u3002", (String)"AsstRepeatCheckSubscribeServiceImpl_0", (String)"fi-bd-common", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", number + "(" + number + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(number, orgId);
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u91cd\u590d\u3002", (String)"AsstRepeatCheckSubscribeServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0])));
            }
        }
        return true;
    }
}

