/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class BizAccountCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    private Log logger = LogFactory.getLog(BizAccountCheckSubscribeServiceImpl.class);

    public BizAccountCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        return true;
    }

    private void bizAccountCheck() {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select fuseorgid from t_bd_account_u group by fuseorgid ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"RelationIncompleteCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sb);){
            for (Row row : dataSet) {
                Long fuseorgid = row.getLong("fuseorgid");
                DynamicObject bosOrg = this.ctx.getOrgById(fuseorgid);
                if (bosOrg == null) continue;
                this.bizAccountCheckByOrg(fuseorgid);
            }
        }
    }

    private void bizAccountCheckByOrg(Long fuseorgid) {
        try (DataSet accounts = AccountUtils.queryAccountDataSet(fuseorgid, this.ctx.getAccountTableId(), "longnumber", null);){
            for (Row row : accounts) {
                this.bizAccountCheckByOrgAndAccountNum(fuseorgid, row.getString("longnumber"));
            }
        }
    }

    private void bizAccountCheckByOrgAndAccountNum(Long fuseorgid, String longNumber) {
        DynamicObject bosOrg = this.ctx.getOrgById(fuseorgid);
        if (null == bosOrg) {
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", fuseorgid);
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            return;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select tt.fperiodid, count(1) accountcount from ( ", new Object[0]);
        sb.append("\t\tselect v.fperiodid,a.flevel  ", new Object[0]);
        sb.append("     from t_gl_voucher as v ", new Object[0]);
        sb.append("     inner join t_gl_voucherentry as ve on v.fid=ve.fid ", new Object[0]);
        sb.append("     inner join t_bd_account as a on a.fid=ve.faccountid ", new Object[0]);
        sb.append("     where v.forgid = ? ", new Object[]{fuseorgid});
        sb.append("     and a.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        sb.append("     and a.flongnumber  like ? ", new Object[]{longNumber + "%"});
        sb.append("     group by v.fperiodid,a.flevel ", new Object[0]);
        sb.append(" ) tt group by tt.fperiodid ", new Object[0]);
        sb.append(" having count (tt.fperiodid) > 1 ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"BizAccountCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sb);){
            for (Row row : dataSet) {
                Integer accountcount = row.getInteger("accountcount");
                if (accountcount.compareTo(1) <= 0) continue;
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7'%1$s'\u7684'%2$s'\u79d1\u76ee\u5df2\u505a\u8d26\u79d1\u76ee\u5728\u95ee\u9898\uff0c\u671f\u95f4'%3$s'", (String)"BizAccountChecksServiceImpl_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", longNumber + "(" + longNumber + ")", row.getLong("fperiodid") + "(" + row.getLong("fperiodid") + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(longNumber, fuseorgid);
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u5df2\u505a\u8d26\u79d1\u76ee", (String)"BizAccountChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            }
        }
    }
}

