/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.accountchecktools.AccountCheckUtil;
import kd.fi.bd.checktools.account.check.accountchecktools.vo.AccountAssignInfo;
import kd.fi.bd.checktools.account.check.checkprop.BaseDataVO;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CheckAccAssignRelationShipServiceImpl
extends AbstractCheckSubscribeService {
    private Set<Long> selectedOrgs;
    private long accountTableId;
    private long accountTableOrgId;
    private IFormView view;
    private Map<Long, List<Long>> parentOrgIdMap;
    private Map<Long, Set<String>> orgAccountMap = new HashMap<Long, Set<String>>(8);
    private Map<Long, Map<String, Set<AccountAssignInfo>>> assignRelationMap = new HashMap<Long, Map<String, Set<AccountAssignInfo>>>(8);
    private Map<Long, Set<AccountAssignInfo>> missedMap = new HashMap<Long, Set<AccountAssignInfo>>(8);
    private Map<Long, BaseDataVO> orgInfoMap = new HashMap<Long, BaseDataVO>(8);

    public CheckAccAssignRelationShipServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
        DynamicObject accounttable = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"org_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ctx.getAccountTableId())});
        this.accountTableOrgId = accounttable.getLong("org_id");
        this.view = ctx.getView();
        this.selectedOrgs = ctx.getSelectOrgs();
        this.accountTableId = ctx.getAccountTableId();
    }

    @Override
    protected boolean process() {
        this.checkAssignRelationShip();
        return false;
    }

    private void checkAssignRelationShip() {
        String fileName;
        if (CollectionUtils.isEmpty(this.selectedOrgs) && this.accountTableId != 0L) {
            this.selectedOrgs = AccountCheckUtil.getSelectOrgs(this.accountTableOrgId);
        }
        if (this.selectedOrgs.isEmpty()) {
            return;
        }
        this.parentOrgIdMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", new ArrayList<Long>(this.selectedOrgs));
        for (Map.Entry<Long, List<Long>> entry : this.parentOrgIdMap.entrySet()) {
            this.selectedOrgs.addAll((Collection<Long>)entry.getValue());
        }
        Throwable throwable = null;
        try (DataSet orgSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter("id", "in", this.selectedOrgs).toArray(), null);){
            for (kd.bos.algo.Row orgRow : orgSet) {
                BaseDataVO baseDataVO = new BaseDataVO(orgRow.getLong("id"), orgRow.getString("number"), orgRow.getString("name"));
                this.orgInfoMap.put(orgRow.getLong("id"), baseDataVO);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        this.assignRelationMap = this.getAllOrgsAccAssignRelationShip();
        this.firstOrgAccountInfo();
        this.missedMap = this.getMissedAssignRelationShip();
        if (CollectionUtils.isEmpty(this.missedMap) || !AccountCheckUtil.checkToRepair(this.view)) {
            return;
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        SXSSFSheet sXSSFSheet = wb.createSheet("sheet1");
        Optional<String> downLoadUrl = this.generateExcelAndDownLoad(wb, (Sheet)sXSSFSheet, fileName = LocalDate.now().toString() + ".xlsx");
        if (downLoadUrl.isPresent()) {
            this.view.download(downLoadUrl.get());
        }
    }

    private void firstOrgAccountInfo() {
        QFilter orgFilter = new QFilter("createorg_id", "=", (Object)this.accountTableOrgId);
        QFilter tableFilter = new QFilter("accounttable_id", "=", (Object)this.accountTableId);
        QFilter ctrlFilter = new QFilter("ctrlstrategy", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"number,id", (QFilter[])new QFilter[]{orgFilter, tableFilter, ctrlFilter}, null);
        for (kd.bos.algo.Row row : dataSet) {
            String accNumber = row.getString("number");
            this.assignRelationMap.computeIfAbsent(this.accountTableOrgId, k -> new HashMap(8)).computeIfAbsent(accNumber, y -> new HashSet(8)).add(new AccountAssignInfo(accNumber, row.getLong("id"), this.accountTableOrgId));
            this.orgAccountMap.computeIfAbsent(this.accountTableOrgId, k -> new HashSet(8)).add(accNumber);
        }
    }

    private Optional<String> generateExcelAndDownLoad(SXSSFWorkbook wb, Sheet sh, String fileName) {
        String selectOrgIds = JSONObject.toJSONString(this.selectedOrgs);
        String backUpData = String.format("create table if not exists t_bd_accountusereg%s as select * from t_bd_accountusereg where fuseorgid in (%s) ;", LocalDate.now().toString().replace("-", ""), selectOrgIds.substring(1, selectOrgIds.length() - 1));
        Row backUpRow = sh.createRow(0);
        backUpRow.createCell(0).setCellValue(backUpData);
        int rowIndex = 1;
        for (Map.Entry<Long, Set<AccountAssignInfo>> accountAssignInfoMap : this.missedMap.entrySet()) {
            Long useOrgId = accountAssignInfoMap.getKey();
            BaseDataVO orgInfo = this.orgInfoMap.get(useOrgId);
            String orgMess = Objects.nonNull(orgInfo) ? orgInfo.getName() + "(" + orgInfo.getNumber() + ")" : useOrgId.toString();
            Row markRow = sh.createRow(rowIndex++);
            markRow.createCell(0).setCellValue("-- repair" + orgMess + ",assignShip");
            Set<AccountAssignInfo> accountAssignInfos = accountAssignInfoMap.getValue();
            ArrayList<AccountAssignInfo> accountAssignInfoList = new ArrayList<AccountAssignInfo>(accountAssignInfos);
            String assignColumn0 = "insert ignore into t_bd_accountusereg(fdataid,fcreateorgid,fadminorgid,fuseorgid,fctrlstrategy,fisassign,fassignorgid) values ";
            String excColumn = "insert ignore into t_bd_accountexc(fdataid,fuseorgid,fcreateorgid) values ";
            for (int j = 0; j < accountAssignInfoList.size(); ++j) {
                Row row = sh.createRow(rowIndex);
                AccountAssignInfo accountAssignInfo = (AccountAssignInfo)accountAssignInfoList.get(j);
                Long createOrgId = accountAssignInfo.getCreateOrgId();
                Long fdataid = accountAssignInfo.getAccId();
                String insert = String.format("(%1s,%2s,%3s,%4s,%5s,%6s,%7s);", fdataid, createOrgId, createOrgId, useOrgId, Character.valueOf('1'), Character.valueOf('1'), createOrgId);
                row.createCell(0).setCellValue(assignColumn0);
                row.createCell(1).setCellValue(insert);
                String exc = String.format("(%1s,%2s,%3s);", fdataid, useOrgId, createOrgId);
                row.createCell(7).setCellValue(excColumn);
                row.createCell(8).setCellValue(exc);
                ++rowIndex;
            }
        }
        Optional<String> downUrl = AccountCheckUtil.downLoadErrorData(this.view, wb, fileName);
        if (downUrl.isPresent()) {
            return downUrl;
        }
        return Optional.empty();
    }

    private Map<Long, Set<AccountAssignInfo>> getMissedAssignRelationShip() {
        HashMap<Long, Set<AccountAssignInfo>> missedMap = new HashMap<Long, Set<AccountAssignInfo>>(8);
        for (Map.Entry<Long, List<Long>> superOrgMap : this.parentOrgIdMap.entrySet()) {
            Long currOrgId = superOrgMap.getKey();
            List<Long> allSuperOrgIds = superOrgMap.getValue();
            ArrayList<Long> allSuperIncludeSelf = new ArrayList<Long>(allSuperOrgIds);
            allSuperIncludeSelf.add(currOrgId);
            int firstIndex = allSuperOrgIds.indexOf(this.accountTableOrgId);
            if (firstIndex < 0) continue;
            for (int i = firstIndex; i < allSuperIncludeSelf.size() - 1; ++i) {
                Long superOrg = (Long)allSuperIncludeSelf.get(i);
                Long currOrg = (Long)allSuperIncludeSelf.get(i + 1);
                Set<AccountAssignInfo> missedAssignRelSet = this.compareAccAssignRelationShip(superOrg, currOrg);
                if (missedMap.size() > 5000) {
                    return missedMap;
                }
                if (missedAssignRelSet.isEmpty()) continue;
                missedMap.put(currOrg, missedAssignRelSet);
                this.checkFailed(currOrg, missedAssignRelSet);
            }
        }
        return missedMap;
    }

    private void checkFailed(Long currOrg, Set<AccountAssignInfo> missedAssignRelSet) {
        DynamicObject bosOrg = this.ctx.getOrgById(currOrg);
        if (null == bosOrg) {
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", currOrg);
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"CheckAccAssignRelationShipServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"CheckAccAssignRelationShipServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0])));
            return;
        }
        for (AccountAssignInfo accountAssignInfo : missedAssignRelSet) {
            String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7'%1$s'\u7684'%2$s'\u79d1\u76ee\u7248\u672c\u5316\u65e5\u671f\u5b58\u5728\u95ee\u9898\uff08\u7248\u672c\u5316\u65e5\u671f\u4e0d\u6b63\u786e\uff09\u3002", (String)"CheckAccAssignRelationShipServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", accountAssignInfo.getNumber() + "(" + accountAssignInfo.getNumber() + ")");
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(accountAssignInfo.getNumber(), currOrg);
            accountOrgPairVO.setOrgName(bosOrg.getString("name"));
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u7248\u672c\u5316\u65e5\u671f", (String)"CheckAccAssignRelationShipServiceImpl_3", (String)"fi-bd-common", (Object[])new Object[0])));
        }
    }

    private Set<AccountAssignInfo> compareAccAssignRelationShip(Long superOrgId, Long currOrgId) {
        HashSet<AccountAssignInfo> missedAssignRelSet = new HashSet<AccountAssignInfo>(8);
        Set<String> superOrgAccNumbers = this.orgAccountMap.get(superOrgId);
        Set<String> currOrgAccNumbers = this.orgAccountMap.get(currOrgId);
        if (CollectionUtils.isEmpty(superOrgAccNumbers) || CollectionUtils.isEmpty(currOrgAccNumbers)) {
            return new HashSet<AccountAssignInfo>(8);
        }
        for (String number : superOrgAccNumbers) {
            Set<AccountAssignInfo> superOrgAccountRelationShips = this.assignRelationMap.get(superOrgId).get(number);
            if (!currOrgAccNumbers.contains(number)) continue;
            Set<AccountAssignInfo> currOrgAccountRelationShips = this.assignRelationMap.get(currOrgId).get(number);
            superOrgAccountRelationShips.removeAll(currOrgAccountRelationShips);
            if (superOrgAccountRelationShips.isEmpty()) continue;
            missedAssignRelSet.addAll(superOrgAccountRelationShips);
            currOrgAccountRelationShips.addAll(missedAssignRelSet);
        }
        return missedAssignRelSet;
    }

    private Map<Long, Map<String, Set<AccountAssignInfo>>> getAllOrgsAccAssignRelationShip() {
        HashMap<Long, Map<String, Set<AccountAssignInfo>>> currOrgAccountAssignRelationMap = new HashMap<Long, Map<String, Set<AccountAssignInfo>>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid as id,a.fnumber as number,a.fcreateorgid as createorg_id,", new Object[0]);
        sqlBuilder.append(" b.fuseorgid as useorg_id from t_bd_account a inner join ", new Object[0]);
        sqlBuilder.append(" t_bd_accountusereg b on a.fid = b.fdataid where a.fctrlstrategy = '1' ", new Object[0]);
        sqlBuilder.append(" and faccounttableid = ? ", new Object[]{this.accountTableId});
        sqlBuilder.appendIn(" and fuseOrgId  ", new ArrayList<Long>(this.selectedOrgs));
        DataSet dataSet = DB.queryDataSet((String)"queryAssignRelation", (DBRoute)DB_ROUTE, (SqlBuilder)sqlBuilder);
        for (kd.bos.algo.Row row : dataSet) {
            Long accId = row.getLong("id");
            String accNumber = row.getString("number");
            Long createOrgId = row.getLong("createorg_id");
            Long useOrgId = row.getLong("useorg_id");
            this.orgAccountMap.computeIfAbsent(useOrgId, k -> new HashSet(8)).add(accNumber);
            currOrgAccountAssignRelationMap.computeIfAbsent(useOrgId, k -> new HashMap(8)).computeIfAbsent(accNumber, x -> new HashSet(8)).add(new AccountAssignInfo(accNumber, accId, createOrgId));
        }
        return currOrgAccountAssignRelationMap;
    }
}

