/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import com.google.common.collect.HashBasedTable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.checktools.account.check.accountchecktools.AccountCheckUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;
import kd.fi.bd.vo.OrgVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CheckAccUseAndExcDataServiceImpl
extends AbstractCheckSubscribeService {
    private Map<Integer, Object[]> errorDatas = new HashMap<Integer, Object[]>(8);
    private static ConcurrentHashMap<String, Map<Integer, Object[]>> cache = new ConcurrentHashMap(8);
    private Set<Long> selectedOrgs;
    private Long accountTableId;
    private Long accountTableOrgId;
    private IFormView view;
    private Map<Long, List<Long>> parentOrgIdMap;
    private BiTreeNode<Long, OrgVO> treeNode;
    private Map<Long, BiTreeNode<Long, OrgVO>> nodeIdMap = new HashMap<Long, BiTreeNode<Long, OrgVO>>(8);

    public CheckAccUseAndExcDataServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
        DynamicObject accounttable = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"org_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ctx.getAccountTableId())});
        this.accountTableOrgId = accounttable.getLong("org_id");
        this.view = ctx.getView();
        this.selectedOrgs = ctx.getSelectOrgs();
        this.accountTableId = ctx.getAccountTableId();
    }

    @Override
    protected boolean process() {
        this.CheckUseTableData();
        if (AccountCheckUtil.checkToRepair(this.view)) {
            this.createEntryData();
        }
        this.batchRepair();
        return false;
    }

    private void batchRepair() {
        String pageId = this.view.getPageId();
        HashSet<String> selectDatas = new HashSet<String>(8);
        if (AccountCheckUtil.checkToRepair(this.view)) {
            Map<Integer, Object[]> excDatas = cache.get(pageId);
            if (CollectionUtils.isEmpty(excDatas)) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.view.getControl("entryentity");
            int[] nArray = entryGrid.getSelectRows();
            if (nArray.length != 0) {
                this.view.showSuccessNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\uff01\uff01\uff01", (String)"CheckAccUseAndExcDataServiceImpl_3", (String)"fi-bd-common", (Object[])new Object[0]));
                return;
            }
            for (int selectRow : nArray) {
                Object[] selectRowData = excDatas.get(selectRow);
                Long useOrgId = (Long)selectRowData[0];
                String number = (String)selectRowData[5];
                selectDatas.add(useOrgId + number);
            }
        }
        HashBasedTable table = HashBasedTable.create();
        for (Map.Entry<Integer, Object[]> entry : this.errorDatas.entrySet()) {
            Object[] objectArray = entry.getValue();
            Long useOrgId = (Long)objectArray[0];
            Long createOrgId = (Long)objectArray[1];
            Long accId = (Long)objectArray[2];
            String number = (String)objectArray[5];
            if (!selectDatas.isEmpty() && !selectDatas.contains(useOrgId + number)) continue;
            if (table.contains((Object)useOrgId, (Object)number)) {
                ((Map)table.get((Object)useOrgId, (Object)number)).computeIfAbsent(createOrgId, k -> new HashSet(8)).add(accId);
                continue;
            }
            HashMap<Long, Set> createOrgToIdMap = new HashMap<Long, Set>(8);
            createOrgToIdMap.computeIfAbsent(createOrgId, k -> new HashSet(8)).add(accId);
            table.put((Object)useOrgId, (Object)number, createOrgToIdMap);
        }
        HashMap<Long, List<Object[]>> needRepairDataMap = new HashMap<Long, List<Object[]>>(8);
        for (Map.Entry entry : table.rowMap().entrySet()) {
            Long useOrgId = (Long)entry.getKey();
            for (Map.Entry numberEntry : ((Map)entry.getValue()).entrySet()) {
                Map persionalIdMap = (Map)numberEntry.getValue();
                this.checkSupOrgPersionalAccount((String)numberEntry.getKey(), needRepairDataMap, useOrgId, useOrgId, persionalIdMap);
            }
        }
        if (!CollectionUtils.isEmpty(needRepairDataMap) && AccountCheckUtil.checkToRepair(this.ctx.getView())) {
            SXSSFWorkbook sXSSFWorkbook = new SXSSFWorkbook(50000);
            SXSSFSheet sXSSFSheet = sXSSFWorkbook.createSheet("sheet1");
            String fileName = LocalDate.now().toString() + ".xlsx";
            String selectOrgIds = this.selectedOrgs.toString();
            String backUpData = String.format("create table if not exists t_bd_accountexc%s as select * from t_bd_accountexc where fuseorgid in (%s) ;", LocalDate.now().toString().replace("-", ""), selectOrgIds.substring(1, selectOrgIds.length() - 1));
            Row backUpRow = sXSSFSheet.createRow(0);
            backUpRow.createCell(0).setCellValue(backUpData);
            String deleteSQL = "delete from t_bd_accountexc where fdataid = %1s and fuseorgid = %2s and fcreateorgid = %3s ;";
            int rowIndex = 1;
            for (Map.Entry currOrgNeedRepairData : needRepairDataMap.entrySet()) {
                Long useOrgId = (Long)currOrgNeedRepairData.getKey();
                DynamicObject orgInfo = this.ctx.getOrgById(useOrgId);
                String orgMess = Objects.nonNull(orgInfo) ? orgInfo.getString("name") + "(" + orgInfo.getString("number") + ")" : useOrgId.toString();
                Row markRow = sXSSFSheet.createRow(rowIndex++);
                markRow.createCell(0).setCellValue("-- repair" + orgMess + ",assignShip");
                List needRepairDatas = (List)currOrgNeedRepairData.getValue();
                for (Object[] needRepairData : needRepairDatas) {
                    String backUpSql = String.format(deleteSQL, needRepairData[0], needRepairData[1], needRepairData[2]);
                    Row row = sXSSFSheet.createRow(rowIndex);
                    row.createCell(0).setCellValue(backUpSql);
                    ++rowIndex;
                }
            }
            IDataModel m = this.view.getModel();
            m.deleteEntryData("entryentity");
            Optional<String> downUrl = AccountCheckUtil.downLoadErrorData(this.view, sXSSFWorkbook, fileName);
            if (downUrl.isPresent()) {
                this.view.download(downUrl.get());
            }
        }
        cache.clear();
    }

    private Set<Long> checkSupOrgPersionalAccount(String number, Map<Long, List<Object[]>> needRepairDataMap, Long useOrgId, Long createOrg, Map<Long, Set<Long>> persionalIdMap) {
        HashSet<Long> clearCacheOrgs = new HashSet<Long>(8);
        if (persionalIdMap.containsKey(createOrg) && needRepairDataMap.size() < 6000) {
            ArrayList persionalIds = new ArrayList(persionalIdMap.get(createOrg));
            persionalIds.forEach(x -> needRepairDataMap.computeIfAbsent(useOrgId, k -> new ArrayList(8)).add(new Object[]{x, useOrgId, createOrg}));
            clearCacheOrgs.add(createOrg);
            this.checkFailed(useOrgId, number);
            return clearCacheOrgs;
        }
        BiTreeNode<Long, OrgVO> currNode = this.nodeIdMap.get(createOrg);
        Long pOrgId = currNode.getParentId();
        return this.checkSupOrgPersionalAccount(number, needRepairDataMap, useOrgId, pOrgId, persionalIdMap);
    }

    private void checkFailed(Long currOrg, String number) {
        DynamicObject bosOrg = this.ctx.getOrgById(currOrg);
        if (null == bosOrg) {
            AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", currOrg);
            this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"CheckAccUseAndExcDataServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"CheckAccUseAndExcDataServiceImpl_1", (String)"fi-bd-common", (Object[])new Object[0])));
            return;
        }
        String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7'%1$s'\u7684'%2$s'\u79d1\u76ee\u5728\u6392\u9664\u8868\uff0c\u4e0d\u5728\u4f7f\u7528\u8868\u3002", (String)"CheckAccUseAndExcDataServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", number + "(" + number + ")");
        AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(number, currOrg);
        accountOrgPairVO.setOrgName(bosOrg.getString("name"));
        this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u6392\u9664\u8868\u6570\u636e\u5f02\u5e38", (String)"CheckAccUseAndExcDataServiceImpl_5", (String)"fi-bd-common", (Object[])new Object[0])));
    }

    private void CheckUseTableData() {
        if (CollectionUtils.isEmpty(this.selectedOrgs)) {
            this.selectedOrgs = AccountCheckUtil.getSelectOrgs(this.accountTableOrgId);
        }
        if (this.selectedOrgs.isEmpty()) {
            return;
        }
        this.parentOrgIdMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", new ArrayList<Long>(this.selectedOrgs));
        for (Map.Entry<Long, List<Long>> aLong : this.parentOrgIdMap.entrySet()) {
            this.selectedOrgs.addAll((Collection<Long>)aLong.getValue());
        }
        if (Objects.isNull(this.treeNode)) {
            this.buildOrgStructureInfo();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select ea.fcreateorgid,ec.fuseorgid,ea.fnumber,ea.fid ", new Object[0]);
        sql.append(" from t_bd_accountexc as ec ", new Object[0]);
        sql.append(" inner join t_Bd_account as ea on ec.fdataid = ea.fid", new Object[0]);
        sql.append(" where ea.faccounttableid = ? ", new Object[]{this.accountTableId});
        sql.appendIn(" and ec.fuseorgid", this.selectedOrgs.toArray());
        sql.append(" and not exists ( ", new Object[0]);
        sql.append("   select 1 from t_bd_account_u as uc", new Object[0]);
        sql.append("   inner join t_Bd_account as ua on uc.fdataid = ua.fid", new Object[0]);
        sql.append("   where uc.fuseorgid = ec.fuseorgid ", new Object[0]);
        sql.append("   and ua.fnumber = ea.fnumber ", new Object[0]);
        sql.append("   and ua.faccounttableid = ea.faccounttableid", new Object[0]);
        sql.append(" ) ", new Object[0]);
        int i = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"UseRangeExcCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (kd.bos.algo.Row row : dataSet) {
                Long id = row.getLong("fid");
                Long orgId = row.getLong("fcreateorgid");
                Long useOrgId = row.getLong("fuseorgid");
                String number = row.getString("fnumber");
                DynamicObject bosOrg = this.ctx.getOrgById(useOrgId);
                String resultTip = null;
                resultTip = null == bosOrg ? String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7'%1$s'\u7684'%2$s'\u79d1\u76ee\u5728\u6392\u9664\u8868\uff0c\u4e0d\u5728\u4f7f\u7528\u8868\u3002", (String)"CheckAccUseAndExcDataServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), useOrgId + "(" + useOrgId + ")", row.getString("fnumber") + "(" + row.getString("fnumber") + ")") : (StringUtils.isNotBlank(resultTip) ? null : String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7'%1$s'\u7684'%2$s'\u79d1\u76ee\u5728\u6392\u9664\u8868\uff0c\u4e0d\u5728\u4f7f\u7528\u8868\u3002", (String)"CheckAccUseAndExcDataServiceImpl_2", (String)"fi-bd-common", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", row.getString("fnumber")));
                Object[] errorData = new Object[]{useOrgId, orgId, row.getLong("fid"), resultTip, ResManager.loadKDString((String)"\u4f7f\u7528\u8868\u548c\u6392\u9664\u8868\u77db\u76fe\u7684\u9519\u8bef\u6570\u636e\u3002", (String)"CheckAccUseAndExcDataServiceImpl_4", (String)"fi-bd-common", (Object[])new Object[0]), number};
                this.errorDatas.put(i, errorData);
                ++i;
            }
        }
    }

    private void createEntryData() {
        IDataModel m = this.view.getModel();
        String entryKey = "entryentity";
        m.deleteEntryData(entryKey);
        if (!this.errorDatas.isEmpty()) {
            m.beginInit();
            for (Map.Entry<Integer, Object[]> errorData : this.errorDatas.entrySet()) {
                Object[] e = errorData.getValue();
                int i = m.createNewEntryRow(entryKey);
                m.setValue("org", e[0], i, i);
                m.setValue("createorg", e[1], i, i + 1);
                m.setValue("accountnumber", e[2], i, i + 2);
                m.setValue("descrption", e[3], i, i + 3);
                m.setValue("type", e[4], i, i + 4);
                this.errorDatas.put(i, e);
            }
            m.endInit();
            this.view.updateView(entryKey);
        }
        this.view.showSuccessNotification("check finish");
        String pageId = this.view.getPageId();
        cache.put(pageId, this.errorDatas);
    }

    private void buildOrgStructureInfo() {
        this.treeNode = BDUtil.buildSubTreeByOrgId(Optional.of(this.accountTableOrgId));
        this.nodeIdMap = BiTreeNode.toMap(this.treeNode);
    }
}

