/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.account.check.service;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.checktools.account.check.AbstractCheckSubscribeService;
import kd.fi.bd.checktools.account.check.ControlCheckCtx;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.AccountOrgPairVO;

public class LongNumberCheckSubscribeServiceImpl
extends AbstractCheckSubscribeService {
    private Log logger = LogFactory.getLog(LongNumberCheckSubscribeServiceImpl.class);

    public LongNumberCheckSubscribeServiceImpl(ControlCheckCtx ctx) {
        super(ctx);
    }

    @Override
    protected boolean process() {
        this.existsfname();
        this.existsfna();
        return true;
    }

    private void existsfname() {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select a.fcreateorgid,a.fnumber,a.flevel,a.flongnumber,l.fname,l.ffullname ", new Object[0]);
        sql.append(" from T_BD_ACCOUNT as a ", new Object[0]);
        sql.append(" left join t_Bd_account_l as l on a.fid=l.fid ", new Object[0]);
        sql.append(" where a.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        sql.append(" and (l.fname is null or l.ffullname is null or l.fname =' '  or l.ffullname = ' ' ) ", new Object[0]);
        sql.append(" and l.flocaleid = ? ", new Object[]{"zh_CN"});
        try (DataSet dataSet = DB.queryDataSet((String)"LongNumberCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                DynamicObject bosOrg = this.ctx.getOrgById(row.getLong("fcreateorgid"));
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", row.getLong("fcreateorgid"));
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u201c%1$s\u201d\u79d1\u76ee\u7684\u540d\u79f0\u201c%2$s\u201d\u6216\u8005\u957f\u540d\u79f0\u201c%3$s\u201d\u4e0d\u6b63\u786e\u3002", (String)"LongNumberChecksServiceImpl_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", row.getString("fnumber") + "(" + row.getString("fnumber") + ")", row.getString("flevel") + "(" + row.getString("flevel") + ")", row.getString("ffullname") + "(" + row.getString("ffullname") + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(row.getString("fnumber"), row.getLong("fcreateorgid"));
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"LongNumberChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            }
        }
    }

    private void existsfna() {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select a.fcreateorgid,a.fnumber,a.flevel,a.flongnumber ", new Object[0]);
        sql.append(" from T_BD_ACCOUNT as a ", new Object[0]);
        sql.append(" where (a.flevel <> (length(a.flongnumber) - length( replace (a.flongnumber, '_' , '' )) + 1)) ", new Object[0]);
        sql.append(" and a.faccounttableid = ? ", new Object[]{this.ctx.getAccountTableId()});
        try (DataSet dataSet = DB.queryDataSet((String)"LongNumberCheckSubscribeServiceImpl", (DBRoute)DB_ROUTE, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                DynamicObject bosOrg = this.ctx.getOrgById(row.getLong("fcreateorgid"));
                if (null == bosOrg) {
                    AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO("", row.getLong("fcreateorgid"));
                    this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"RelationIncompleteChecksServiceImpl_2", (String)"fi-bd-formplugin", (Object[])new Object[0])));
                    continue;
                }
                String resultTip = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u79d1\u76ee\u7684\u79d1\u76ee\u7ea7\u6b21\u201c%3$s\u201d\u6216\u8005\u957f\u7f16\u7801\u201c%4$s\u201d\u4e0d\u6b63\u786e\u3002", (String)"LongNumberChecksServiceImpl_3", (String)"fi-bd-formplugin", (Object[])new Object[0]), bosOrg.getString("name") + "(" + bosOrg.getString("number") + ")", row.getString("fnumber") + "(" + row.getString("fnumber") + ")", row.getString("flevel") + "(" + row.getString("flevel") + ")", row.getString("flongnumber") + "(" + row.getString("flongnumber") + ")");
                AccountOrgPairVO accountOrgPairVO = new AccountOrgPairVO(row.getString("fnumber"), row.getLong("fcreateorgid"));
                accountOrgPairVO.setOrgName(bosOrg.getString("name"));
                this.ctx.addTaskExecutionResult(TaskExecutionResult.failed(accountOrgPairVO, resultTip, ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"LongNumberChecksServiceImpl_4", (String)"fi-bd-formplugin", (Object[])new Object[0])));
            }
        }
    }
}

