/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.dtx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.checktools.asstacttype.AccountingDimensionCheckTask;

public class DtxFailedCheck
implements FIDataCheckTask {
    private final Log logger = LogFactory.getLog(AccountingDimensionCheckTask.class);
    private static final String[] SCENES_NUMBER = new String[]{"adjust_voucher", "delete_voucher", "submit_voucher", "modify_voucher"};

    public boolean execute() {
        DynamicObjectCollection businessScenes = QueryServiceHelper.query((String)"bos_kdtx_scenes", (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter("code", "in", (Object)SCENES_NUMBER).toArray());
        List scenesTxIds = businessScenes.stream().map(scenes -> scenes.getLong("id")).collect(Collectors.toList());
        String sql = "/*dialect*/SELECT distinct fscenes_tx_id FROM t_cbs_dtx_transaction WHERE (EXTRACT(DAY FROM (fupdate_time - fcreate_time)) > 1 OR fstatus IN ('6', '7')) AND EXTRACT(DAY FROM( NOW() - fcreate_time)) <= 7";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(sql, new Object[0]);
        sqlBuilder.appendIn("AND fscenes_tx_id", scenesTxIds.toArray());
        try (DataSet rows = DB.queryDataSet((String)"kd.fi.bd.checktools.dtx.DtxFailedCheck", (DBRoute)DBRoute.base, (SqlBuilder)sqlBuilder);){
            DataSet copy = rows.copy();
            if (!copy.isEmpty()) {
                Iterator iterator = copy.iterator();
                ArrayList<String> failedScenesTx = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    failedScenesTx.add(row.getString("fscenes_tx_id"));
                }
                if (CollectionUtils.isEmpty(failedScenesTx)) {
                    boolean row = true;
                    return row;
                }
                RequestContext requestContext = RequestContext.get();
                String tenantId = requestContext.getTenantId();
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_kdtx_scenes", (String)String.join((CharSequence)",", "code", "name"), (QFilter[])new QFilter("id", "in", failedScenesTx).toArray());
                if (collection.size() != 0) {
                    String tenantName = requestContext.getTenantInfo().getName();
                    StringBuilder builder = new StringBuilder();
                    this.logger.error("###### Distributed transactions that failed or took more than one day to execute in the past week are displayed in the scheduling task result. Please check in time! [tenantId:" + tenantId + ",tenantName:" + tenantName + "]");
                    builder.append(ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u5de5\u5177\u68c0\u67e5\u51fa\u8fc7\u53bb\u4e00\u5468\u5185\u53ef\u80fd\u5b58\u5728\u5931\u8d25\u6216\u8005\u6267\u884c\u65f6\u95f4\u8d85\u8fc7\u4e00\u5929\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\u3002 \u4e1a\u52a1\u573a\u666f\u7f16\u7801\u3001\u540d\u79f0\u5982\u4e0b\uff1a", (String)"DtxFailedCheck_1", (String)"fi-bd-common", (Object[])new Object[0]));
                    builder.append("\n");
                    List collect = collection.stream().map(x -> String.join((CharSequence)", ", x.getString("code"), x.getString("name"))).collect(Collectors.toList());
                    builder.append(String.join((CharSequence)"; ", collect));
                    FIDataCheckUtil.saveResult((String)"DtxFailedCheck", (String)"fibd", (boolean)false, (String)builder.toString(), (String)"DtxFailedCheck");
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }
}

