/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.checktools.mulcurrency;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.ai.FIDataCheckTask;
import kd.bos.ext.fi.util.FIDataCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.service.mulcur.MulLocalDeployServiceHelper;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;

public class MulCurConfigCheckTask
implements FIDataCheckTask {
    public boolean execute() {
        if (FIDataCheckUtil.isStop()) {
            return false;
        }
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bd_mulcurconfig", (String)String.join((CharSequence)",", "number", "finishupdatedb"), (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("finishupdatedb", "=", (Object)false)});
        HashSet<String> needUpdateConfigNumSet = new HashSet<String>(8);
        for (DynamicObject config : configs) {
            needUpdateConfigNumSet.add(config.getString("number"));
        }
        ArrayList<LocalCurrencyConfigVO> configVOList = new ArrayList<LocalCurrencyConfigVO>(needUpdateConfigNumSet.size());
        for (String configNum : needUpdateConfigNumSet) {
            configVOList.add(LocalCurrencyConfigService.getCurrencyConfig(configNum));
        }
        MulLocalDeployServiceHelper.checkAddConstraintAll(configVOList.toArray(new LocalCurrencyConfigVO[0]));
        for (DynamicObject config : configs) {
            config.set("finishupdatedb", (Object)true);
        }
        SaveServiceHelper.save((DynamicObject[])configs);
        LocalCurrencyConfigService.removeMulCurConfigCache();
        return true;
    }
}

