/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.consts;

import java.util.Arrays;
import java.util.List;
import kd.fi.bd.consts.MCT;

public enum ControlMetadata {
    GL_VOUCHER("gl_voucher", Arrays.asList(MCT.CURRENCY, MCT.CREDIT, MCT.DEBIT, MCT.EX_RATE, MCT.EX_RATE_TYPE)),
    GL_BALANCE_LOG("gl_balance_log", Arrays.asList(MCT.DEBIT, MCT.CREDIT)),
    GL_INIT_BALANCE("gl_initbalance", Arrays.asList(MCT.BEGIN_DEBIT, MCT.BEGIN_CREDIT, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT, MCT.YEAR_PROFIT_DEBIT, MCT.YEAR_PROFIT_CREDIT)),
    GL_BALANCE("gl_balance", Arrays.asList(MCT.BEGIN, MCT.DEBIT, MCT.CREDIT, MCT.YEAR_DEBIT, MCT.CREDIT, MCT.END));

    private String value;
    private List<MCT> fieldTypeList;

    private ControlMetadata(String value, List<MCT> fieldTypeList) {
        this.value = value;
        this.fieldTypeList = fieldTypeList;
    }

    public String getValue() {
        return this.value;
    }

    public List<MCT> getFieldTypeList() {
        return this.fieldTypeList;
    }

    public static ControlMetadata getControlMetadata(String value) {
        for (ControlMetadata controlMetadata : ControlMetadata.values()) {
            if (!controlMetadata.getValue().equals(value)) continue;
            return controlMetadata;
        }
        return null;
    }
}

