/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.consts;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.consts.AccountOperationType;
import kd.fi.bd.consts.OperationLogEntry;
import org.apache.commons.lang3.StringUtils;

public class OperationLog {
    private static final String KEY_OPERATION_ORG = "oporg";
    private static final String KEY_REQUEST_ID = "requestid";
    private static final String KEY_OPERATION_TYPE = "optype";
    private static final String KEY_OPERATOR_ID = "creator";
    private static final String KEY_OPERATION_TIME = "optime";
    private static final String KEY_ACCOUNT_TABLE = "accounttable";
    private static final String KEY_OPERATION_ACCOUNTIDS = "opaccountids";
    private static final String KEY_OPERATION_ORGIDS = "oporgids";
    private static final String KEY_BASEDATA = "fbasedataid";
    private static final String KEY_OPERATION_LOG = "oplog";
    private static final String KEY_OLD_ACCOUNT = "oldaccount";
    private static final String KEY_NEW_ACCOUNT = "newaccount";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_ENTITY_TRACEID = "traceid";
    private static final String KEY_ENTITY_OEG = "org";
    private static final String KEY_ENTITY_ACCOUNT_ID = "accountid";
    private static final String KEY_ENTITY_ACCOUNT_NUMBER = "number";
    private static final String KEY_ENTITY_ACCOUNT_FULLNAME = "fullname";
    private static final String KEY_ENTITY_OPERATION_TYPE = "operationtype";
    private static final String KEY_ENTITY_STATUS = "status";
    private static final String KEY_ENTITY_LOG = "log";
    private Long operationOrgId;
    private String requestId;
    private AccountOperationType operationType;
    private Long operatorId;
    private Date operationTime;
    private Long accountTableId;
    private Set<Long> accountIds;
    private Set<Long> orgIds;
    private String log;
    private List<DynamicObject> oldAccounts;
    private List<DynamicObject> newAccounts;
    private List<OperationLogEntry> entryEntity;

    public OperationLog(long operationOrgId, AccountOperationType operationType, Long accountTableId, Set<Long> accountIds) {
        this.operationOrgId = operationOrgId;
        this.requestId = RequestContext.get().getRequestId();
        this.operationType = operationType;
        this.operatorId = RequestContext.get().getCurrUserId();
        this.accountTableId = accountTableId;
        this.orgIds = new HashSet<Long>(8);
        this.entryEntity = new ArrayList<OperationLogEntry>(8);
        this.accountIds = accountIds != null ? accountIds : new HashSet<Long>(8);
        this.oldAccounts = new ArrayList<DynamicObject>(8);
        this.newAccounts = new ArrayList<DynamicObject>(8);
    }

    public DynamicObject toDynamicObject() {
        Preconditions.checkArgument((this.accountIds != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.operationOrgId != 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.operationType != null ? 1 : 0) != 0);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_account_oplog"));
        dynamicObject.set(KEY_OPERATION_ORG, (Object)this.operationOrgId);
        dynamicObject.set(KEY_REQUEST_ID, (Object)this.requestId);
        dynamicObject.set(KEY_OPERATION_TYPE, (Object)this.operationType.getDesc());
        dynamicObject.set(KEY_OPERATOR_ID, (Object)this.operatorId);
        dynamicObject.set(KEY_OPERATION_TIME, (Object)new Date());
        dynamicObject.set(KEY_ACCOUNT_TABLE, (Object)this.accountTableId);
        dynamicObject.set(KEY_OPERATION_ACCOUNTIDS, (Object)StringUtils.join((Object[])this.accountIds.toArray(), (String)","));
        if (this.orgIds != null) {
            DynamicObjectCollection orgs = dynamicObject.getDynamicObjectCollection(KEY_OPERATION_ORGIDS);
            orgs.clear();
            for (Long l : this.orgIds) {
                DynamicObject org = orgs.addNew();
                org.set(KEY_BASEDATA, (Object)l);
            }
        }
        dynamicObject.set(KEY_OPERATION_LOG, (Object)(StringUtils.isEmpty((CharSequence)this.log) ? ResManager.loadKDString((String)"\u6210\u529f", (String)"OperationLog_1", (String)"fi-bd-common", (Object[])new Object[0]) : StringUtils.truncate((String)this.log, (int)1000)));
        dynamicObject.set(KEY_OLD_ACCOUNT, (Object)this.dynamicObjectsToString(this.oldAccounts));
        dynamicObject.set(KEY_NEW_ACCOUNT, (Object)this.dynamicObjectsToString(this.newAccounts));
        HashMap<Long, DynamicObject> accountMap = new HashMap<Long, DynamicObject>(8);
        for (OperationLogEntry operationLogEntry : this.entryEntity) {
            accountMap.put(operationLogEntry.getAccountId(), null);
        }
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id, number, fullname", (QFilter[])new QFilter[]{new QFilter("id", "in", accountMap.keySet())});
        for (DynamicObject account : accounts) {
            accountMap.put(account.getLong("id"), account);
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        for (OperationLogEntry entryRow : this.entryEntity) {
            DynamicObject dyo = dynamicObjectCollection.addNew();
            dyo.set(KEY_ENTITY_TRACEID, (Object)entryRow.getTraceId());
            dyo.set(KEY_ENTITY_OEG, (Object)entryRow.getOrgId());
            dyo.set(KEY_ENTITY_ACCOUNT_ID, (Object)entryRow.getAccountId());
            dyo.set(KEY_ENTITY_ACCOUNT_NUMBER, (Object)entryRow.getNumber());
            dyo.set(KEY_ENTITY_ACCOUNT_FULLNAME, (Object)entryRow.getAccountName());
            DynamicObject account = (DynamicObject)accountMap.get(entryRow.getAccountId());
            if (account != null) {
                dyo.set(KEY_ENTITY_ACCOUNT_NUMBER, (Object)account.getString(KEY_ENTITY_ACCOUNT_NUMBER));
                dyo.set(KEY_ENTITY_ACCOUNT_FULLNAME, (Object)account.getString(KEY_ENTITY_ACCOUNT_FULLNAME));
            }
            dyo.set(KEY_ENTITY_OPERATION_TYPE, entryRow.getOperationType() == null ? dynamicObject.get(KEY_OPERATION_TYPE) : entryRow.getOperationType().getDesc());
            dyo.set(KEY_ENTITY_STATUS, (Object)(entryRow.isSuccess() ? ResManager.loadKDString((String)"\u6210\u529f", (String)"OperationLog_1", (String)"fi-bd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"OperationLog_2", (String)"fi-bd-common", (Object[])new Object[0])));
            if (entryRow.getLog() == null) continue;
            dyo.set(KEY_ENTITY_LOG, (Object)StringUtils.truncate((String)entryRow.getLog(), (int)1000));
        }
        dynamicObject.set(KEY_ENTRY_ENTITY, (Object)dynamicObjectCollection);
        return dynamicObject;
    }

    private String dynamicObjectsToString(List<DynamicObject> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>(8);
        for (DynamicObject dynamicObject : list) {
            result.add(this.toDynamicObjectJson(dynamicObject));
        }
        return ((Object)result).toString();
    }

    public long getOperationOrgId() {
        return this.operationOrgId;
    }

    public void setOperationOrgId(long operationOrgId) {
        this.operationOrgId = operationOrgId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public AccountOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(AccountOperationType operationType) {
        this.operationType = operationType;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Date getOperationTime() {
        return this.operationTime;
    }

    public void setOperationTime(Date operationTime) {
        this.operationTime = operationTime;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }

    public Set<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Set<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public Set<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(Set<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public List<OperationLogEntry> getEntryEntity() {
        return this.entryEntity;
    }

    public void setEntryEntity(List<OperationLogEntry> entryEntity) {
        this.entryEntity = entryEntity;
    }

    public List<DynamicObject> getOldAccounts() {
        return this.oldAccounts;
    }

    public void setOldAccounts(List<DynamicObject> oldAccounts) {
        this.oldAccounts = oldAccounts;
    }

    public void addOldAccount(DynamicObject oldAccount) {
        if (oldAccount != null) {
            this.oldAccounts.add(oldAccount);
        }
    }

    public void addOldAccount(List<DynamicObject> oldAccounts) {
        if (oldAccounts != null) {
            this.oldAccounts.addAll(oldAccounts);
        }
    }

    public List<DynamicObject> getNewAccounts() {
        return this.newAccounts;
    }

    public void setNewAccounts(List<DynamicObject> newAccounts) {
        this.newAccounts = newAccounts;
    }

    public void addNewAccount(DynamicObject newAccount) {
        if (newAccount != null) {
            this.newAccounts.add(newAccount);
        }
    }

    public void addNewAccount(List<DynamicObject> newAccounts) {
        if (newAccounts != null) {
            this.newAccounts.addAll(newAccounts);
        }
    }

    private String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }
}

