/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.enhance.treetask;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enhance.treetask.ITaskContext;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.OrgVO;

public abstract class AddingAssistAdapter<TK extends ITaskContext, VO extends Serializable, CT> {
    private static final Log LOG = ExtLogFactory.getLog(AddingAssistAdapter.class);
    private static final String ORG_MIRROR_TREE_ROOT = "orgMirrorTreeRoot";
    private static final String ORG_MIRROR_TREE_LOWEST = "orgMirrorTreeLowest";

    public DependBiTreeNode<TK> buildAccOrgTree(BiTreeNode<Long, OrgVO> orgNode, BiTreeNode<String, VO> accountNode, CT ct) {
        DependBiTreeNode orgMirrorTreeRoot;
        List accNodes;
        int accLevel;
        if (accountNode == null || orgNode == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddingAssistAdapter_0", (String)"fi-bd-common", (Object[])new Object[0]));
        }
        ListMultimap<Integer, BiTreeNode> accountLevelNodeMap = accountNode.tagNodeWithLevel(x -> {
            Tuple<DependBiTreeNode<TK>, DependBiTreeNode<TK>> rootAndLowestPair = this.buildOrgMirrorTree(orgNode, (BiTreeNode<String, VO>)x, ct);
            x.setPropValue(ORG_MIRROR_TREE_ROOT, rootAndLowestPair.item1);
            x.setPropValue(ORG_MIRROR_TREE_LOWEST, rootAndLowestPair.item2);
        });
        int maxAccLevel = (Integer)Collections.max(accountLevelNodeMap.keySet());
        for (accLevel = maxAccLevel - 1; accLevel >= 1; --accLevel) {
            accNodes = accountLevelNodeMap.get((Object)accLevel);
            List lowerLevelAccRoots = accountLevelNodeMap.get((Object)(accLevel + 1)).stream().map(x -> (DependBiTreeNode)x.getPropValue(ORG_MIRROR_TREE_ROOT)).collect(Collectors.toList());
            for (BiTreeNode accNode : accNodes) {
                orgMirrorTreeRoot = (DependBiTreeNode)accNode.getPropValue(ORG_MIRROR_TREE_ROOT);
                orgMirrorTreeRoot.preTravel(y -> {
                    if (CollectionUtils.isEmpty(y.getChild())) {
                        ((DependBiTreeNode)y).setDependencies(lowerLevelAccRoots);
                    }
                });
            }
        }
        for (accLevel = 2; accLevel <= maxAccLevel; ++accLevel) {
            accNodes = accountLevelNodeMap.get((Object)accLevel);
            for (BiTreeNode accNode : accNodes) {
                DependBiTreeNode parentOrgMirrorTreeLowest = (DependBiTreeNode)accNode.getParent().getPropValue(ORG_MIRROR_TREE_LOWEST);
                orgMirrorTreeRoot = (DependBiTreeNode)accNode.getPropValue(ORG_MIRROR_TREE_ROOT);
                orgMirrorTreeRoot.setParent(parentOrgMirrorTreeLowest);
            }
        }
        DependBiTreeNode taskRootNode = (DependBiTreeNode)accountNode.getPropValue(ORG_MIRROR_TREE_ROOT);
        LOG.info("build dependency after:" + taskRootNode.showFormatTree("\n", x -> Stream.concat(((DependBiTreeNode)x).getDependencies().stream(), x.getChild().stream()).map(c -> String.valueOf(c.getId())).collect(Collectors.joining("#"))));
        return taskRootNode;
    }

    private Tuple<DependBiTreeNode<TK>, DependBiTreeNode<TK>> buildOrgMirrorTree(BiTreeNode<Long, OrgVO> orgNodeRoot, BiTreeNode<String, VO> accountNode, CT ct) {
        HashMap orgToTaskMap = new HashMap(8);
        LinkedListMultimap taskLevelMap = LinkedListMultimap.create();
        orgNodeRoot.preTravel(x -> {
            TK TK = this.getTaskContext(accountNode, (BiTreeNode<Long, OrgVO>)x, ct);
            DependBiTreeNode<TK> taskNode = new DependBiTreeNode<TK>(String.format("%s_%s", accountNode.getId(), x.getId()), TK);
            taskNode.setPropValue("_orgId", x.getId());
            taskNode.setPropValue("_accNum", accountNode.getId());
            TK.bindNode(taskNode);
            orgToTaskMap.put(x, taskNode);
            if (Objects.nonNull(x.getParent())) {
                BiTreeNode orgParentNode = x.getParent();
                taskNode.setParent((BiTreeNode)orgToTaskMap.get(orgParentNode));
            }
            if (x == orgNodeRoot) {
                x.setPropValue("_level", 1);
            } else {
                x.setPropValue("_level", (Integer)x.getParent().getPropValue("_level") + 1);
            }
            int curLevel = (Integer)x.getPropValue("_level");
            taskLevelMap.put((Object)curLevel, taskNode);
        });
        DependBiTreeNode rootTask = (DependBiTreeNode)taskLevelMap.get((Object)1).get(0);
        DependBiTreeNode lowestTask = (DependBiTreeNode)taskLevelMap.get(Collections.max(taskLevelMap.keySet())).get(0);
        return Tuple.create((Object)rootTask, (Object)lowestTask);
    }

    protected abstract TK getTaskContext(BiTreeNode<String, VO> var1, BiTreeNode<Long, OrgVO> var2, CT var3);
}

