/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.enhance.treetask;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.CacheModule;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.cfversion.addassist.CfitemAssistAddingContext;
import kd.fi.bd.enhance.treetask.ITaskContext;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.TaskExecutionResult;
import kd.fi.bd.vo.CashflowItemOrgVo;
import kd.fi.bd.vo.CashflowItemVo;
import kd.fi.bd.vo.OrgVO;

public class CfitemContext
implements ITaskContext<Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>>, TaskExecutionResult<CashflowItemOrgVo>>,
Serializable {
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.GL_CFADDINGASSIT);
    private BiTreeNode<String, CfitemContext> bindNode;
    private ReentrantLock lock = new ReentrantLock();
    private final Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> cfOrgInfo;
    private final CfitemAssistAddingContext assistAddingContext;
    private TaskExecutionResult executionResult;

    public CfitemContext(CfitemAssistAddingContext assistAddingContext, Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> cfOrgInfo) {
        this.assistAddingContext = assistAddingContext;
        this.cfOrgInfo = cfOrgInfo;
    }

    public String getAccountNumber() {
        return (String)((BiTreeNode)this.cfOrgInfo.item1).getId();
    }

    public long getOrgId() {
        return (Long)((BiTreeNode)this.cfOrgInfo.item2).getId();
    }

    @Override
    public Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>> getData() {
        return this.cfOrgInfo;
    }

    @Override
    public <T extends ITaskContext<Tuple<BiTreeNode<String, CashflowItemVo>, BiTreeNode<Long, OrgVO>>, TaskExecutionResult<CashflowItemOrgVo>>> void bindNode(BiTreeNode<String, T> bindNode) {
        this.bindNode = bindNode;
    }

    @Override
    public BiTreeNode<String, CfitemContext> getBindNode() {
        return this.bindNode;
    }

    @Override
    public TaskExecutionResult<CashflowItemOrgVo> getExecutionResult() {
        return this.executionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecutionResult(TaskExecutionResult<CashflowItemOrgVo> result) {
        try {
            this.lock.lock();
            this.executionResult = result;
            String pageId = (String)ThreadCache.get((Object)"viewPageId");
            String finishedCountCacheKey = pageId + "finishedCount";
            if (Objects.nonNull(this.cache.get(finishedCountCacheKey))) {
                int finishedCount = Integer.parseInt(this.cache.get(finishedCountCacheKey));
                this.cache.put(finishedCountCacheKey, String.format("%s", finishedCount + 1));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public CfitemAssistAddingContext getAssistAddingContext() {
        return this.assistAddingContext;
    }

    public String toString() {
        return "TaskContext{executionResult=" + this.executionResult + '}';
    }
}

