/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.enhance.treetask;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.enhance.treetask.DependBiTreeNode;
import kd.fi.bd.enhance.treetask.ITaskContext;
import kd.fi.bd.enhance.treetask.ITaskResult;
import kd.fi.bd.enhance.treetask.ITaskService;
import kd.fi.bd.util.AccountOperationLogUtil;
import kd.fi.bd.util.BiTreeNode;

public class TreeDepthFirstScheduleExecutor<T extends ITaskContext> {
    private static final Log LOG = LogFactory.getLog(TreeDepthFirstScheduleExecutor.class);
    private final DependBiTreeNode<T> taskRootTreeNode;

    public TreeDepthFirstScheduleExecutor(DependBiTreeNode<T> taskRootTreeNode) {
        this.taskRootTreeNode = taskRootTreeNode;
        LOG.info("start_to_execute_TreeDepthFirstScheduleExecutor with: " + taskRootTreeNode.showFormatTree("\n"));
    }

    public <V extends ITaskResult> void execute(ITaskService<V, T> taskService) {
        int maxLevel;
        long executeTick = System.currentTimeMillis();
        ListMultimap<Integer, BiTreeNode> levelNodeMap = this.taskRootTreeNode.tagNodeWithLevel(null);
        int seq = 0;
        for (int level = maxLevel = ((Integer)Collections.max(levelNodeMap.keySet())).intValue(); level > 0; --level) {
            int i;
            List nodes = levelNodeMap.get((Object)level);
            Preconditions.checkState((!CollectionUtils.isEmpty((Collection)nodes) ? 1 : 0) != 0, (Object)"logic error");
            ++seq;
            for (DependBiTreeNode node2 : nodes) {
                node2.setScheduleSeq(seq);
            }
            Predicate isExistChildFailed = node -> !CollectionUtils.isEmpty(node.getDependencies()) && node.getDependencies().stream().anyMatch(x -> !((ITaskContext)x.getData()).getExecutionResult().isSuccessful()) || !CollectionUtils.isEmpty(node.getChild()) && node.getChild().stream().anyMatch(x -> !((ITaskContext)x.getData()).getExecutionResult().isSuccessful());
            nodes.stream().filter(node -> isExistChildFailed.test(node)).forEach(node -> ((ITaskContext)node.getData()).setExecutionResult(taskService.buildFastFailResult((ITaskContext)node.getData())));
            List needValidateNodes = nodes.stream().filter(x -> Objects.isNull(((ITaskContext)x.getData()).getExecutionResult())).collect(Collectors.toList());
            needValidateNodes.stream().forEach(x -> {
                try {
                    Optional validateResult = taskService.validateBeforeExecution((ITaskContext)x.getData());
                    if (validateResult.isPresent()) {
                        ((ITaskContext)x.getData()).setExecutionResult((ITaskResult)validateResult.get());
                    }
                }
                catch (Exception e) {
                    ((ITaskContext)x.getData()).setExecutionResult(taskService.buildExceptionResult((ITaskContext)x.getData(), e));
                }
            });
            List needOperateNodes = nodes.stream().filter(x -> Objects.isNull(((ITaskContext)x.getData()).getExecutionResult())).collect(Collectors.toList());
            if (needOperateNodes.isEmpty()) continue;
            long tick = System.currentTimeMillis();
            try {
                List<V> nodeResults = taskService.batchExecute(needOperateNodes.stream().map(x -> (ITaskContext)x.getData()).collect(Collectors.toList()));
                LOG.info(String.format("batchExecute count: %s, cost: %s", needOperateNodes.size(), System.currentTimeMillis() - tick));
                Preconditions.checkState((needOperateNodes.size() == nodeResults.size() ? 1 : 0) != 0, (Object)"logic error, result size not match feeds");
                for (i = 0; i < needOperateNodes.size(); ++i) {
                    ((ITaskContext)((BiTreeNode)needOperateNodes.get(i)).getData()).setExecutionResult((ITaskResult)nodeResults.get(i));
                }
                continue;
            }
            catch (Exception e) {
                for (i = 0; i < needOperateNodes.size(); ++i) {
                    BiTreeNode node3 = (BiTreeNode)needOperateNodes.get(i);
                    ((ITaskContext)node3.getData()).setExecutionResult(taskService.buildExceptionResult((ITaskContext)node3.getData(), e));
                }
                AccountOperationLogUtil.persistLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        LOG.info(String.format("%s tree_execute cost: %s", this.getClass().getName(), System.currentTimeMillis() - executeTick));
    }
}

