/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.enums;

import java.util.ArrayList;
import java.util.List;
import kd.fi.bd.enums.MultiLangEnumBridge;

public enum AccountPropDetail {
    ASST_TYPE("01", "1", new MultiLangEnumBridge("\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b", "AccountPropDetail_0", "fi-bd-common")),
    ASST_DETAIL("02", "1", new MultiLangEnumBridge("\u6838\u7b97\u7ef4\u5ea6\u660e\u7ec6", "AccountPropDetail_1", "fi-bd-common")),
    ASST_REQUIRE("03", "1", new MultiLangEnumBridge("\u6838\u7b97\u7ef4\u5ea6\u5fc5\u5f55", "AccountPropDetail_2", "fi-bd-common")),
    AC_CHECK("04", "1", new MultiLangEnumBridge("\u5f80\u6765\u6838\u7b97", "AccountPropDetail_3", "fi-bd-common")),
    QTY("05", "1", new MultiLangEnumBridge("\u6570\u91cf\u6838\u7b97", "AccountPropDetail_4", "fi-bd-common")),
    CASH("06", "3", new MultiLangEnumBridge("\u73b0\u91d1", "AccountPropDetail_5", "fi-bd-common")),
    BANK("07", "3", new MultiLangEnumBridge("\u94f6\u884c", "AccountPropDetail_6", "fi-bd-common")),
    CASH_EQUIVALENT("08", "3", new MultiLangEnumBridge("\u73b0\u91d1\u7b49\u4ef7\u7269", "AccountPropDetail_7", "fi-bd-common")),
    JOURNAL("09", "2", new MultiLangEnumBridge("\u767b\u65e5\u8bb0\u8d26", "AccountPropDetail_8", "fi-bd-common")),
    CHANGE_CURRENCY("10", "2", new MultiLangEnumBridge("\u671f\u672b\u8c03\u6c47", "AccountPropDetail_9", "fi-bd-common")),
    AC_NOTICE("11", "2", new MultiLangEnumBridge("\u5f80\u6765\u901a\u77e5", "AccountPropDetail_10", "fi-bd-common")),
    ACC_RUAL_DIRECTION("12", "2", new MultiLangEnumBridge("\u79d1\u76ee\u5f55\u5165\u65b9\u5411\u63a7\u5236", "AccountPropDetail_11", "fi-bd-common")),
    CONTROL_LEVEL("13", "3", new MultiLangEnumBridge("\u63a7\u5236\u7ea7\u6b21", "AccountPropDetail_12", "fi-bd-common")),
    ALLOW_ADD("14", "2", new MultiLangEnumBridge("\u5141\u8bb8\u516c\u53f8\u589e\u52a0\u4e0b\u7ea7\u79d1\u76ee", "AccountPropDetail_13", "fi-bd-common")),
    MANUAL("15", "2", new MultiLangEnumBridge("\u624b\u5de5\u5f55\u5165", "AccountPropDetail_14", "fi-bd-common")),
    CURRENCY("16", "3", new MultiLangEnumBridge("\u5e01\u79cd\u6838\u7b97", "AccountPropDetail_15", "fi-bd-common"));

    private final String type;
    private final String checkCategory;
    private MultiLangEnumBridge bridge;
    private static final List<String> CASH_PROP_TYPE_LIST;

    private AccountPropDetail(String type, String checkCategory, MultiLangEnumBridge bridge) {
        this.type = type;
        this.checkCategory = checkCategory;
        this.bridge = bridge;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getCheckCategory() {
        return this.checkCategory;
    }

    public static List<AccountPropDetail> getAccountPropDetails(String checkCategory) {
        ArrayList<AccountPropDetail> details = new ArrayList<AccountPropDetail>(8);
        for (AccountPropDetail detail : AccountPropDetail.values()) {
            if (!detail.getCheckCategory().equals(checkCategory)) continue;
            details.add(detail);
        }
        return details;
    }

    public static List<String> getAccountPropDetailTypes(String checkCategory) {
        ArrayList<String> details = new ArrayList<String>(8);
        for (AccountPropDetail detail : AccountPropDetail.values()) {
            if (!detail.getCheckCategory().equals(checkCategory)) continue;
            details.add(detail.getType());
        }
        return details;
    }

    public static AccountPropDetail getEnumByType(String type) {
        for (AccountPropDetail value : AccountPropDetail.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public static Boolean isCashPropType(String type) {
        return CASH_PROP_TYPE_LIST.contains(type);
    }

    static {
        CASH_PROP_TYPE_LIST = new ArrayList<String>(8);
        CASH_PROP_TYPE_LIST.add(BANK.getType());
        CASH_PROP_TYPE_LIST.add(CASH.getType());
        CASH_PROP_TYPE_LIST.add(CASH_EQUIVALENT.getType());
    }
}

