/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.enums;

import java.util.Set;

public enum CurrencyAccountingType {
    NO_CURRENCY("nocurrency", (curId, locCurId, accountingCurIds) -> curId.equals(locCurId)),
    DEST_CURRENCY("descurrency", (curId, locCurId, accountingCurIds) -> curId.equals(locCurId) || accountingCurIds.contains(curId)),
    ALL_CURRENCY("allcurrency", (curId, locCurId, accountingCurIds) -> true);

    private final String value;
    private final CurrencyChecker currencyChecker;

    private CurrencyAccountingType(String value, CurrencyChecker currencyChecker) {
        this.value = value;
        this.currencyChecker = currencyChecker;
    }

    public String getValue() {
        return this.value;
    }

    public CurrencyChecker getCurrencyChecker() {
        return this.currencyChecker;
    }

    public static CurrencyAccountingType fromValue(String value) {
        switch (value) {
            case "nocurrency": {
                return NO_CURRENCY;
            }
            case "descurrency": {
                return DEST_CURRENCY;
            }
            case "allcurrency": {
                return ALL_CURRENCY;
            }
        }
        throw new IllegalArgumentException("illegal type:" + value);
    }

    @FunctionalInterface
    public static interface CurrencyChecker {
        public boolean check(Long var1, Long var2, Set<Long> var3);
    }
}

