/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.format;

import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class UserFormatter {
    private final FormatObject formatObject;

    public UserFormatter() {
        this(Long.parseLong(RequestContext.get().getUserId()));
    }

    public UserFormatter(long userId) {
        this.formatObject = InteServiceHelper.getUserFormat((Long)userId);
    }

    public String formatAmount(BigDecimal amount, String currencySign, int amtprecision) {
        this.formatObject.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        this.formatObject.getCurrencyFormat().setCurrencySymbols(currencySign);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.formatObject);
        return format.format(amount);
    }

    public String formatNumber(BigDecimal number) {
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(this.formatObject);
        return format.format(number);
    }

    public Date parseDate(String source) {
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.formatObject);
        try {
            return (Date)format.parseObject(source);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a%s", (String)"UserFormatter_0", (String)"fi-bd-common", (Object[])new Object[0]), source));
        }
    }
}

