/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.cdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.indexing.cdc.StatisticDBServiceHelper;
import kd.fi.bd.indexing.constant.CDCConstant;
import kd.fi.bd.indexing.constant.CDCRecOperationTypeEnum;
import kd.fi.bd.indexing.constant.CDCStatusEnum;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.model.indexing.es.CDCTaskStatus;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.exception.KDExceptionBuilder;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public class CDCDBServiceHelper {
    private static final Log logger = LogFactory.getLog(CDCDBServiceHelper.class);
    public static final int Insert_Batch_Size = 1500;
    private static final String AlgoKey_Prefix = "fi/bd/CDCDBServiceHelper/";
    private static final String CDC_Begin_Trans_LockKeyTemplate = "fin/CDCTrans/%s/%s/%s";
    private static final String QUERY_RegisteredAsyncTasks = "id, orgId, taskType, lastCompTimeSlot, procCnt, taskClass";
    private static final String SQL_Insert_CDCTaskStatus = "Insert into t_bd_cdc_taskstatus (fid, fTaskType, fOrgID, fPeriodId, fTransRegDt, fInstanceID, fLastStatus)Values(?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_Update_CDCTaskStatus_Trans = "Update t_bd_cdc_taskstatus set fTransRegDt=?, fInstanceID=?, fLastStatus=? where fid=?";
    private static final String SQL_Update_CDCTaskStatus_Trans_2 = "Update t_bd_cdc_taskstatus set fInstanceID=?, fLastStatus=? where fid=?";
    private static final String SQL_Update_CDCTaskStatus_Stage = "Update t_bd_cdc_taskstatus set flastcomptime=?, flast_cdc_id=? where fid=?";
    private static final String SQL_Update_InitTaskStatus_Stage = "Update t_bd_cdc_taskstatus set flastcomptime=?, flast_max_srcid=?, flast_max_srcentryid=? where fid=?";
    private static final String SQL_Update_TaskStatus_Stage = "Update t_bd_cdc_taskstatus set flastcomptime=?, flast_cdc_id=?, flast_max_srcid=?, flast_max_srcentryid=? where fid=?";
    private static final String SQL_Select_CDCTaskStatus = "id, taskType, org, period, transRegDt, lastCompTime, instanceID, last_cdc_id, last_max_srcid, last_max_srcentryId, lastStatus";
    public static final int Default_TimeSlot_Size = 600000;
    private static final String AlgoKey_getCDCTaskStatus = "fi/bd/CDCDBServiceHelper/getCDCTaskStatus";
    private static final String AlgoKey_isCDCChangedRecHistRowExisted = "fi/bd/CDCDBServiceHelper/isCDCChangedRecHistRowExisted";
    private static final String SQL_isCDCChangedRecHistRowExisted = "Select top 1 fid from T_BD_CDC_ChangedRecHist where fStatus = '0' and fOrgID=? and fPeriodId = ?";
    private static final String SQL_update_CDCChangedRecHistStatus = "update T_BD_CDC_ChangedRecHist set fStatus=? where fid in %s";
    private static final String AlgoKey_getLockCDCChangedRecHist = "fi/bd/CDCDBServiceHelper/getLockCDCChangedRecHist";
    private static final String SQL_getLockCDCChangedRecHist = "Select fid, fSrcRecId from t_bd_cdc_changedrechist where forgid=? and fperiodid=? and fstatus=? and fid >? order by fid";
    private static final String SQL_Select_AvailableCDCTaskGroup = "select forgid, fperiodid from t_bd_cdc_changedrechist tbcc where fstatus =1 and fid > ? ";
    private static final String SQL_Select_MinCompleted_CDC_ID = "select min(flast_cdc_id) from t_bd_cdc_taskstatus tbct where ftasktype =? ";
    private static final String SQL_Query_Valid_CDC_Task_Group = "select tbct.forgid, tbct.fperiodid from t_bd_cdc_taskstatus tbct inner join t_bd_cdc_changedrechist tbcc on tbct.forgid = tbcc.forgid and tbct.fperiodid = tbcc.fperiodid where tbct.fInstanceID = ' ' and tbcc.fstatus = '1' ";
    private static final String SQL_Insert_CDCChangedRecord = "Insert into t_bd_cdc_changedrechist(fID, fSrcRecId, fOrgID, fPeriodId, fOperType, fCreateTime, fStatus) values(?, ?, ?, ?, ?, ?, '0')";
    private static final String SQL_Select_CDC_ChangeedRecHist_Ids = "select top %s fid from t_bd_cdc_changedrechist where forgId=? and fperiodId=? and fid <=?";
    private static final String SQL_Count_CDC_ChangeedRecHist_Ids = "select count(A.fid) as count from (select top %s fid from t_bd_cdc_changedrechist where forgId=? and fperiodId=? and fid <=?) A";
    private static final String SQL_Delete_CDC_ChangeedRecHist = "Delete From t_bd_cdc_changedrechist where fid in (select top %s fid from t_bd_cdc_changedrechist where forgId=? and fperiodId=? and fid <=?)";

    public static long getTimeSlot(long srcTimeStamp, int timeSlotSize) {
        return srcTimeStamp / (long)timeSlotSize;
    }

    public static long getTimeSlot() {
        return System.currentTimeMillis() / 600000L;
    }

    public static <T> T doLockOperation(String lockKey, boolean reEntryLock, Function<String, T> operation) {
        try (DLock lock = (reEntryLock ? DLock.createReentrant((String)lockKey) : DLock.create((String)lockKey)).fastMode();){
            if (lock.tryLock()) {
                T t = operation.apply(lockKey);
                return t;
            }
            logger.error(String.format("doLockOperation.tryLock Failed: lockKey=%s, reEntryLock=%s", lockKey, reEntryLock));
            T t = null;
            return t;
        }
    }

    public static LinkedList<CDCTaskStatus> getCDCTaskStatus(QFilter[] filters) {
        LinkedList<CDCTaskStatus> result = new LinkedList<CDCTaskStatus>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)AlgoKey_getCDCTaskStatus, (String)"bd_cdc_taskstatus", (String)SQL_Select_CDCTaskStatus, (QFilter[])filters, (String)"lastCompTime, TaskType");){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row dataRow = ds.next();
                    result.add(new CDCTaskStatus(dataRow.getLong(0), dataRow.getInteger(1), dataRow.getLong(2), dataRow.getLong(3), dataRow.getDate(4), dataRow.getDate(5), dataRow.getString(6), dataRow.getLong(7), dataRow.getLong(8), dataRow.getLong(9), dataRow.getString(10)));
                }
            }
        }
        return result;
    }

    public static CDCTaskStatus loadCDCTaskStatus(int taskType, long orgId, long periodId) {
        QFilterBuilder filterBuilder = new QFilterBuilder().add("taskType", "=", taskType).add("org", "=", orgId).add("period", "=", periodId);
        LinkedList<CDCTaskStatus> taskStatusList = CDCDBServiceHelper.getCDCTaskStatus(filterBuilder.toArray(new QFilter[0]));
        return !taskStatusList.isEmpty() ? taskStatusList.getFirst() : null;
    }

    private static CDCTaskStatus insertNewCDCTaskStatus(int taskType, long orgId, long periodId, String instanceId) {
        CDCTaskStatus result = new CDCTaskStatus(DB.genGlobalLongId(), taskType, orgId, periodId, instanceId);
        if (!DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Insert_CDCTaskStatus, (Object[])new Object[]{result.getId(), result.getTaskType(), result.getOrgId(), result.getPeriodId(), result.getTransRegDt(), result.getInstanceID(), result.getStatus()})) {
            throw KDExceptionBuilder.buildKDBizException("Insert CDCTaskStatus Failed: " + result);
        }
        return result;
    }

    private static boolean updateCDCTaskTransStatus(long taskId, Date transRegDt, String instanceId, String newStatus) {
        if (transRegDt == null) {
            return DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Update_CDCTaskStatus_Trans_2, (Object[])new Object[]{instanceId, newStatus, taskId});
        }
        return DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Update_CDCTaskStatus_Trans, (Object[])new Object[]{transRegDt, instanceId, newStatus, taskId});
    }

    public static boolean updateCDCTaskCompletedStatus(long taskId, long last_cdc_id) {
        return DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Update_CDCTaskStatus_Stage, (Object[])new Object[]{new Date(System.currentTimeMillis()), last_cdc_id, taskId});
    }

    public static boolean updateInitTaskCompletedStatus(long taskId, long last_max_srcId, long last_max_srcEntryId) {
        return DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Update_InitTaskStatus_Stage, (Object[])new Object[]{new Date(System.currentTimeMillis()), last_max_srcId, last_max_srcEntryId, taskId});
    }

    public static boolean updateTaskStatusByType(CDCTaskStatus taskStatus, int taskType) {
        return DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Update_TaskStatus_Stage, (Object[])new Object[]{new Date(System.currentTimeMillis()), taskStatus.getLast_cdc_id(), taskStatus.getLast_max_srcId(), taskStatus.getLast_max_srcEntryId(), taskStatus.getId()});
    }

    public static boolean updateCDCTaskCompletedStatus(CDCTaskStatus taskStatus, boolean asInitTask) {
        return asInitTask ? CDCDBServiceHelper.updateInitTaskCompletedStatus(taskStatus.getId(), taskStatus.getLast_max_srcId(), taskStatus.getLast_max_srcEntryId()) : CDCDBServiceHelper.updateCDCTaskCompletedStatus(taskStatus.getId(), taskStatus.getLast_cdc_id());
    }

    public static CDCTaskStatus registerNewCDCTaskTrans(int taskType, long orgId, long periodId, String instanceId) {
        if (instanceId == null) {
            throw new IllegalArgumentException("Instance ID cannot be null!");
        }
        CDCTaskStatus status = CDCDBServiceHelper.loadCDCTaskStatus(taskType, orgId, periodId);
        if (status == null) {
            status = CDCDBServiceHelper.insertNewCDCTaskStatus(taskType, orgId, periodId, instanceId);
        } else {
            String oldInstanceId = status.getInstanceID();
            oldInstanceId = oldInstanceId == null ? "" : oldInstanceId.trim();
            boolean canUpdateTask = "".equals(oldInstanceId);
            if (!canUpdateTask && CDCConstant.checkTimeout(status.getLastCompTime()) && !DLock.isInstanceAlive((String)status.getInstanceID())) {
                canUpdateTask = true;
            }
            if (canUpdateTask) {
                status.setTransRegDt(new Date(System.currentTimeMillis()));
                if (!CDCDBServiceHelper.updateCDCTaskTransStatus(status.getId(), status.getTransRegDt(), instanceId, CDCStatusEnum.PROCESSING.getStringValue())) {
                    logger.error("{}.registerNewCDCTaskTrans Update lock Failed: Org={}, Period={}, instance:{}", new Object[]{"CDCDBServiceHelper", orgId, periodId, status.getInstanceID()});
                    status = null;
                }
            } else {
                logger.info("{}.registerNewCDCTaskTrans Failed: Org={}, Period={} Already lock by other instance:{}, current InstanceId:{}", new Object[]{"CDCDBServiceHelper", orgId, periodId, status.getInstanceID(), Instance.getInstanceId()});
                status = null;
            }
        }
        return status;
    }

    public static CDCTaskStatus registerNewCDCTaskTrans(int taskType, long orgId, long periodId) {
        return CDCDBServiceHelper.registerNewCDCTaskTrans(taskType, orgId, periodId, Instance.getInstanceId());
    }

    public static CDCTaskStatus endCDCTaskTrans(int taskType, long orgId, long periodId, String newStatus) {
        CDCTaskStatus taskStatus = CDCDBServiceHelper.loadCDCTaskStatus(taskType, orgId, periodId);
        if (taskStatus != null && CDCDBServiceHelper.updateCDCTaskTransStatus(taskStatus.getId(), null, "", newStatus)) {
            taskStatus.setStatus(newStatus);
            return taskStatus;
        }
        return null;
    }

    public static CDCTaskStatus endCDCTaskTrans(CDCTaskStatus taskStatus, String newStatus) {
        if (CDCDBServiceHelper.updateCDCTaskTransStatus(taskStatus.getId(), null, "", newStatus)) {
            taskStatus.setStatus(newStatus);
            return taskStatus;
        }
        return null;
    }

    public static boolean isCDCChangedRecHistRowExisted(long orgId, long periodId) {
        try (DataSet ds = DB.queryDataSet((String)AlgoKey_isCDCChangedRecHistRowExisted, (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_isCDCChangedRecHistRowExisted, (Object[])new Object[]{orgId, periodId});){
            boolean bl = ds != null ? ds.hasNext() : false;
            return bl;
        }
    }

    public static boolean updateCDCChangedRecHistStatus(Collection<Long> pks, String newStatus) {
        if (pks == null || pks.isEmpty()) {
            return false;
        }
        Object[] params = new Object[pks.size() + 1];
        params[0] = newStatus;
        int i = 1;
        for (Long o : pks) {
            params[i++] = o;
        }
        return DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_update_CDCChangedRecHistStatus, QFilterBuilder.buildSQLParamHolder(pks.size())), (Object[])params);
    }

    public static void fetchCDCChangedRecHist(long periodId, long orgId, long lastCompCDCRecId, int batchSize, Function<Row, Boolean> consumerFunc) {
        try (DataSet ds = DB.queryDataSet((String)AlgoKey_getLockCDCChangedRecHist, (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_getLockCDCChangedRecHist, (Object[])new Object[]{orgId, periodId, Character.valueOf(CDCStatusEnum.NEW.getValue()), lastCompCDCRecId});){
            if (ds != null) {
                int cnt = batchSize;
                while (cnt-- > 0 && ds.hasNext()) {
                    if (consumerFunc.apply(ds.next()).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    public static List<long[]> getCDCChangedRecHistIds(long periodId, long orgId, int batchSize, long lastCompCDCRecId) {
        LinkedList<long[]> result = new LinkedList<long[]>();
        CDCDBServiceHelper.fetchCDCChangedRecHist(periodId, orgId, lastCompCDCRecId, batchSize, dataRow -> result.add(new long[]{dataRow.getLong(0), dataRow.getLong(1)}));
        return result;
    }

    public static String appendOrgPeriodClause(String orginalSql, Collection<Long> orgIds, Collection<Long> periodIds) {
        if (orgIds != null) {
            orginalSql = orginalSql + " and forgid in " + QFilterBuilder.buildSQLParamHolder(orgIds.size());
        }
        if (periodIds != null) {
            orginalSql = orginalSql + " and fperiodid in " + QFilterBuilder.buildSQLParamHolder(periodIds.size());
        }
        return orginalSql;
    }

    public static Long getMinCompleted_CDC_ID(int taskType, Collection<Long> orgIds, Collection<Long> periodIds) {
        String querySQL = orgIds != null || periodIds != null ? CDCDBServiceHelper.appendOrgPeriodClause(SQL_Select_MinCompleted_CDC_ID, orgIds, periodIds) : SQL_Select_MinCompleted_CDC_ID;
        try (DataSet ds = DB.queryDataSet((String)"fi/bd/CDCDBServiceHelper/getMinCompleted_CDC_ID", (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)querySQL, (Object[])IDataValueUtil.concatToArray(taskType, orgIds, periodIds));){
            if (ds != null && ds.hasNext()) {
                Long l = ds.next().getLong(0);
                return l;
            }
        }
        return 0L;
    }

    public static Long getMinCompleted_CDC_ID(int taskType) {
        return CDCDBServiceHelper.getMinCompleted_CDC_ID(taskType, null, null);
    }

    public static boolean getAvailableCDCTaskGroup(int taskType, Collection<Long> filterOrgIds, Collection<Long> filterPeriodIds, Function<PairTuple<Long, Long>, Boolean> processFunc) {
        if (processFunc == null) {
            return false;
        }
        TimeCostMeter timeMeter = TimeCostMeter.create((template, params) -> logger.info(template, params), 2);
        String querySQL = filterOrgIds != null || filterPeriodIds != null ? CDCDBServiceHelper.appendOrgPeriodClause(SQL_Select_AvailableCDCTaskGroup, filterOrgIds, filterPeriodIds) : SQL_Select_AvailableCDCTaskGroup;
        LinkedHashSet<PairTuple<Long, Long>> existCheckGroup = new LinkedHashSet<PairTuple<Long, Long>>(1024);
        int batchSize = 99;
        int batchCnt = 0;
        HashSet<Long> result_orgIds = new HashSet<Long>(batchSize);
        HashSet<Long> result_periodIds = new HashSet<Long>(batchSize);
        QFilterBuilder filterBuilder = new QFilterBuilder();
        long minCDCRecordID = CDCDBServiceHelper.getMinCompleted_CDC_ID(taskType);
        int totalGroupCnt = 0;
        try (DataSet ds = DB.queryDataSet((String)"fi/bd/CDCDBServiceHelper/getAvailableCDCTaskGroup", (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)querySQL, (Object[])IDataValueUtil.concatToArray(minCDCRecordID, filterOrgIds, filterPeriodIds));){
            if (!ds.hasNext()) {
                boolean bl = false;
                return bl;
            }
            timeMeter.outputTimeLog("--> \tgetAvailableCDCTaskGroup: minCDCRecordID={}, Query Time :{} ", minCDCRecordID, timeMeter.getAndReset(0));
            DataSet distinctDS = ds.distinct();
            distinctDS.hasNext();
            timeMeter.outputTimeLog("--> \tgetAvailableCDCTaskGroup: minCDCRecordID={}, distinct first time hasNext Check :{} ", minCDCRecordID, timeMeter.getAndReset(0));
            do {
                ++totalGroupCnt;
                Row dataRow = distinctDS.next();
                result_orgIds.add(dataRow.getLong(0));
                result_periodIds.add(dataRow.getLong(1));
                existCheckGroup.add(new PairTuple<Long, Long>(dataRow.getLong(0), dataRow.getLong(1)));
                if (batchCnt++ <= batchSize) continue;
                batchCnt = 0;
                if (CDCDBServiceHelper.checkValidCDCTask(existCheckGroup, filterBuilder, result_orgIds, result_periodIds, processFunc)) {
                    boolean bl = !distinctDS.hasNext();
                    return bl;
                }
                existCheckGroup.clear();
            } while (distinctDS.hasNext());
            if (!result_orgIds.isEmpty() && !CDCDBServiceHelper.checkValidCDCTask(existCheckGroup, filterBuilder, result_orgIds, result_periodIds, processFunc)) {
                boolean bl = !distinctDS.hasNext();
                return bl;
            }
        }
        timeMeter.outputTimeLog("--> \tgetAvailableCDCTaskGroup: Completed: Total Process Group:{}, Total Time:{} ", totalGroupCnt, timeMeter.getTimeCost(1));
        return true;
    }

    private static boolean checkValidCDCTask(Set<PairTuple<Long, Long>> existCheckGroup, QFilterBuilder filterBuilder, Set<Long> orgIds, Set<Long> periodIds, Function<PairTuple<Long, Long>, Boolean> processFunc) {
        filterBuilder.addIn("org", orgIds);
        filterBuilder.addIn("period", periodIds);
        PairTuple<Long, Long> checkKeyBuf = new PairTuple<Long, Long>(0L, 0L);
        try (DataSet subDS = QueryServiceHelper.queryDataSet((String)"fi/bd/CDCDBServiceHelper/getAvailableCDCTaskGroup-Sub", (String)"bd_cdc_taskstatus", (String)"org, period, InstanceID", (QFilter[])filterBuilder.toArray(new QFilter[0]), null);){
            orgIds.clear();
            periodIds.clear();
            filterBuilder.clear();
            while (subDS.hasNext()) {
                Row dataRow = subDS.next();
                existCheckGroup.remove(checkKeyBuf.reset(dataRow.getLong(0), dataRow.getLong(1)));
                String instanceIdBuf = dataRow.getString(2);
                if (instanceIdBuf == null || !"".equals(instanceIdBuf.trim()) || processFunc.apply(checkKeyBuf).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
        }
        if (!existCheckGroup.isEmpty()) {
            for (PairTuple<Long, Long> grp : existCheckGroup) {
                if (processFunc.apply(grp).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerCDCChangedRecord(CDCRecOperationTypeEnum operationType, String[] propertyNames, DynamicObject[] changeRecords) {
        if (changeRecords == null || changeRecords.length <= 0) {
            return;
        }
        if (propertyNames == null || propertyNames.length < 3) {
            throw new IllegalArgumentException("Required Property Name for[id, org, period], but propertyNames=" + Arrays.deepToString(propertyNames));
        }
        IDataEntityProperty[] pReaders = IDataValueUtil.getDynamicObjectProperty(changeRecords[0].getDataEntityType().getProperties(), propertyNames);
        Date time = new Date(System.currentTimeMillis());
        long[] ids = DB.genGlobalLongIds((int)changeRecords.length);
        int batchCnt = 0;
        int recIndex = 0;
        ArrayList<Object[]> bufferList = new ArrayList<Object[]>(1500);
        LinkedHashSet<PairTuple<Long, Long>> orgPeriodGroups = new LinkedHashSet<PairTuple<Long, Long>>(16);
        try (TXHandle tx = TX.requiresNew((String)"registerCDCChangedRecord");){
            for (DynamicObject dyn : changeRecords) {
                Object[] objectArray = new Object[6];
                objectArray[0] = ids[recIndex++];
                objectArray[1] = pReaders[0].getValueFast((Object)dyn);
                Long orgId = (Long)pReaders[1].getValueFast((Object)dyn);
                objectArray[2] = orgId;
                Long periodId = (Long)pReaders[2].getValueFast((Object)dyn);
                objectArray[3] = periodId;
                objectArray[4] = operationType.getCode();
                objectArray[5] = time;
                bufferList.add(objectArray);
                orgPeriodGroups.add(new PairTuple<Long, Long>(orgId, periodId));
                if (batchCnt++ <= 1500) continue;
                DB.executeBatch((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Insert_CDCChangedRecord, bufferList);
                bufferList.clear();
                batchCnt = 0;
            }
            if (!bufferList.isEmpty()) {
                DB.executeBatch((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Insert_CDCChangedRecord, bufferList);
            }
            StatisticDBServiceHelper.tryRegisterOrgPeriodDimGroup(orgPeriodGroups);
            orgPeriodGroups.clear();
        }
    }

    private static void getCDCRecordIds(long orgId, long periodId, long endCDCId, int batchSize, Consumer<Row> processFunc) {
        try (DataSet ds = DB.queryDataSet((String)"fi/bd/CDCDBServiceHelper/getCDCRecordIds", (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_Select_CDC_ChangeedRecHist_Ids, batchSize), (Object[])new Object[]{orgId, periodId, endCDCId});){
            if (ds != null) {
                while (ds.hasNext()) {
                    processFunc.accept(ds.next());
                }
            }
        }
    }

    private static int getCDCRecordCnt(long orgId, long periodId, long endCDCId, int maxBatchSize) {
        try (DataSet ds = DB.queryDataSet((String)"fi/bd/CDCDBServiceHelper/getCDCRecordCnt", (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_Count_CDC_ChangeedRecHist_Ids, maxBatchSize), (Object[])new Object[]{orgId, periodId, endCDCId});){
            if (ds != null && ds.hasNext()) {
                int n = ds.next().getInteger(0);
                return n;
            }
        }
        return 0;
    }

    public static int deleteCDCRecords(long orgId, long periodId, long endCDCId) {
        int batchCnt;
        int deleteCnt = 0;
        while ((batchCnt = CDCDBServiceHelper.getCDCRecordCnt(orgId, periodId, endCDCId, 1500)) > 0) {
            if (!DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_Delete_CDC_ChangeedRecHist, 1500), (Object[])new Object[]{orgId, periodId, endCDCId})) continue;
            deleteCnt += batchCnt;
        }
        return deleteCnt;
    }
}

