/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.cdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.iterators.impl.BaseBufferedIterator;

public class RegTextDBServiceHelper {
    private static final Log logger = LogFactory.getLog(RegTextDBServiceHelper.class);
    private static final String AlgoKey_Prefix = "fi/bd/RegTextDBServiceHelper/";
    private static final String SQL_queryExistingRegText = "select fid, fregtext from t_bd_regtextinfo where fstatus ='3' and  forgid=? and fperiodid=? and fregtext in %s order by fid";
    private static final String AlgoKey_queryExistingRegText = "fi/bd/RegTextDBServiceHelper/queryExistingRegText";
    private static final String SQL_Insert_RegText = "Insert into t_bd_regtextinfo (fid, fOrgID, fPeriodId, fRegText, fCreateTime, fRefCount, fStatus)Values(?, ?, ?, ?, ?, ?, '3')";
    private static final String SQL_Update_RegText_RefCnt = "update t_bd_regtextinfo set fRefCount=fRefCount+? where fid=? and fstatus ='3' ";
    private static final String SQL_Select_RegTextOwnership = "Select fEntryId, fid, fOwnerRecId from T_BD_RegTextOwnership where fEntryId in %s order by fid";
    private static final String AlgoKey_RegTextOwnership = "fi/bd/RegTextDBServiceHelper/RegTextOwnership";
    private static final String SQL_Select_DeletedRegTextOwnership = "Select fEntryId from T_BD_RegTextOwnership where fEntryId in %s order by fEntryId";
    private static final String SQL_DeletedRegTextOwnership = "delete from T_BD_RegTextOwnership where fEntryId in %s";
    private static final String SQL_Insert_RegTextOwnership = "Insert into T_BD_RegTextOwnership (fEntryId, fid, fOwnerRecId)Values(?, ?, ?)";
    private static final String SQL_Delete_RegTextOwnership_Batch = "Delete from t_bd_regtextownership r1 where fentryid in (select top %s fentryid from t_gl_voucherentry v1 where fid in %s)";
    private static final String SQL_QUERY_MAX_FENTRYID = "SELECT MAX(FENTRYID) FROM T_GL_VOUCHERENTRY WHERE FORGID = ? AND FPERIODID = ?";
    private static final String SQL_Select_RegText = "select top %s fid from T_BD_RegTextInfo where 1=1 %s order by fid";
    private static final String SQL_Delete_RegText = "Delete from T_BD_RegTextInfo where fid in (select top %s fid from T_BD_RegTextInfo where 1=1 %s order by fid)";
    private static final String SQL_DeletedRegTextOwnership_1 = "delete from T_BD_RegTextOwnership where fid in (select top %s fid from T_BD_RegTextInfo where 1=1 %s order by fid)";

    public static void queryExistingRegText(long orgId, long periodId, Object[] queryTexts, Function<Row, Boolean> resultHandler) {
        if (queryTexts == null || resultHandler == null) {
            throw new IllegalArgumentException("Query Text or Process Function is null!");
        }
        if (queryTexts.length <= 0) {
            return;
        }
        ArrayList<Object> batchParams = new ArrayList<Object>(ExIndexConstant.RegText_DB_PARAM_LENTH / 255 + 1);
        int paramLength = 0;
        for (Object queryText : queryTexts) {
            int queryTextLength = String.valueOf(queryText).length();
            if ((paramLength += queryTextLength) > ExIndexConstant.RegText_DB_PARAM_LENTH) {
                RegTextDBServiceHelper.innerQueryExistingRegText(orgId, periodId, resultHandler, batchParams);
                paramLength = queryTextLength;
                batchParams.clear();
            }
            batchParams.add(queryText);
        }
        RegTextDBServiceHelper.innerQueryExistingRegText(orgId, periodId, resultHandler, batchParams);
    }

    private static void innerQueryExistingRegText(long orgId, long periodId, Function<Row, Boolean> resultHandler, List<Object> batchParams) {
        if (batchParams.isEmpty()) {
            return;
        }
        int paramSize = batchParams.size();
        int sqlParamSize = paramSize + 2;
        Object[] sqlParams = new Object[sqlParamSize];
        sqlParams[0] = orgId;
        sqlParams[1] = periodId;
        System.arraycopy(batchParams.toArray(), 0, sqlParams, 2, paramSize);
        try (DataSet ds = DB.queryDataSet((String)AlgoKey_queryExistingRegText, (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_queryExistingRegText, QFilterBuilder.buildSQLParamHolder(paramSize)), (Object[])sqlParams);){
            if (ds != null) {
                while (ds.hasNext() && resultHandler.apply(ds.next()).booleanValue()) {
                }
            }
        }
    }

    public static int[] batchInsertRegText(List<Object[]> params) {
        if (params == null || params.isEmpty()) {
            return new int[0];
        }
        int[] result = null;
        BaseBufferedIterator<Object[]> batchIterator = new BaseBufferedIterator<Object[]>(params.iterator(), 1500);
        while (batchIterator.hasNext()) {
            result = RegTextDBServiceHelper.mergeIntArray(result, DB.executeBatch((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Insert_RegText, Arrays.asList(batchIterator.next())));
        }
        return result;
    }

    public static int[] mergeIntArray(int[] src, int[] target) {
        if (target == null) {
            return src;
        }
        if (src == null) {
            return target;
        }
        int length = Math.min(src.length, target.length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            src[n] = src[n] + target[i];
        }
        return src;
    }

    public static int[] batchUpdateRegTextRefCnt(List<Long> pks, boolean deleteNonRef) {
        int[] result;
        block29: {
            result = new int[2];
            Arrays.fill(result, 0);
            if (pks == null) {
                return result;
            }
            QFilterBuilder builder = new QFilterBuilder();
            builder.addIn("id", pks);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi/bd/RegTextDBServiceHelper/batchUpdateRegTextRefCnt", (String)"bd_regtextinfo", (String)"id", (QFilter[])builder.toArray(new QFilter[0]), null);){
                if (ds == null) break block29;
                LinkedList<Object[]> updateRefParams = new LinkedList<Object[]>();
                LinkedList<Long> deletePks = new LinkedList<Long>();
                DataSet grpDs = ds.groupBy(new String[]{"id"}).count("cnt").finish();
                while (grpDs.hasNext()) {
                    Row dataRow = grpDs.next();
                    int refCnt = dataRow.getInteger(1);
                    long idBuf = dataRow.getLong(0);
                    if (refCnt <= 0) {
                        if (!deleteNonRef) continue;
                        deletePks.add(idBuf);
                        continue;
                    }
                    updateRefParams.add(new Object[]{refCnt, idBuf});
                }
                result[0] = updateRefParams.size();
                result[1] = deletePks.size();
                if (updateRefParams.isEmpty() && deletePks.isEmpty()) break block29;
                try (TXHandle tx = TX.required((String)"batchUpdateRegTextRefCnt");){
                    if (!deletePks.isEmpty()) {
                        BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_regtextinfo"), (Object[])deletePks.toArray());
                    }
                    if (!updateRefParams.isEmpty()) {
                        DB.executeBatch((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Update_RegText_RefCnt, updateRefParams);
                    }
                }
            }
        }
        return result;
    }

    public static void getRegTextOwnership(Object[] entryPKs, Function<Row, Boolean> resultHandler) {
        if (entryPKs == null || entryPKs.length <= 0) {
            return;
        }
        BaseBufferedIterator bufferedIterator = new BaseBufferedIterator(Arrays.stream(entryPKs).iterator(), ExIndexConstant.RegText_DB_IN_PARAM_SIZE);
        while (bufferedIterator.hasNext()) {
            Object[] next = bufferedIterator.next();
            DataSet ds = DB.queryDataSet((String)AlgoKey_RegTextOwnership, (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_Select_RegTextOwnership, QFilterBuilder.buildSQLParamHolder(next.length)), (Object[])next);
            Throwable throwable = null;
            try {
                if (ds == null) continue;
                while (ds.hasNext() && resultHandler.apply(ds.next()).booleanValue()) {
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    public static boolean deleteRegTextOwnership(Long[] pks) {
        if (pks == null || pks.length <= 0) {
            return false;
        }
        BaseBufferedIterator bufferedIterator = new BaseBufferedIterator(Arrays.stream(pks).iterator(), ExIndexConstant.RegText_DB_IN_PARAM_SIZE);
        boolean result = true;
        while (bufferedIterator.hasNext()) {
            Object[] next = bufferedIterator.next();
            result &= DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)String.format(SQL_DeletedRegTextOwnership, QFilterBuilder.buildSQLParamHolder(next.length)), (Object[])next);
        }
        return result;
    }

    public static int deleteRegText(Collection<Long> orgIds, Collection<Long> periodIds) {
        String sqlClause = QFilterBuilder.buildClause("forgid", orgIds) + QFilterBuilder.buildClause("fperiodid", periodIds);
        String deleteEntrySql = String.format(SQL_DeletedRegTextOwnership_1, 1500, sqlClause);
        String deleteMainSql = String.format(SQL_Delete_RegText, 1500, sqlClause);
        String checkExistSql = String.format(SQL_Select_RegText, 1, sqlClause);
        Object[] params = IDataValueUtil.concatToArray(orgIds, periodIds);
        int batchCnt = 0;
        while (DB.queryDataSet((String)"fi/bd/RegTextDBServiceHelper/deleteRegText", (DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)checkExistSql, (Object[])params).hasNext()) {
            DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)deleteEntrySql, (Object[])params);
            DB.execute((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)deleteMainSql, (Object[])params);
            ++batchCnt;
        }
        return batchCnt;
    }

    public static int[] batchInsertRegTextOwnership(List<Object[]> params) {
        if (params == null || params.isEmpty()) {
            return new int[0];
        }
        return DB.executeBatch((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Insert_RegTextOwnership, params);
    }

    public static long getMaxEntryId(Long orgId, Long periodId) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)SQL_QUERY_MAX_FENTRYID, (Object[])new Object[]{orgId, periodId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong(1);
            }
            return 0L;
        });
    }
}

