/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.cdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.iterators.impl.BufferedIterator;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public class StatisticDBServiceHelper {
    private static final Log logger = LogFactory.getLog(StatisticDBServiceHelper.class);
    private static final int Insert_Batch_Size = 1000;
    private static final String AlgoKey_Prefix = "fi/bd/StatisticDBServiceHelper/";
    private static final String SQL_Insert_OrgPeriodDimGroup = "insert into t_bd_grp_orgprd(fid, forgId, fPeriodId, fCreateTime, fstatus) values(?, ?, ?, ?, '0')";
    private static final String SQL_Select_OrgPeriodDimGroup = "Select forgId, fPeriodId, fid from t_bd_grp_orgprd where fstatus='0' ";
    private static final String SQL_Select_GL_Voucher = "Select forgId, fPeriodId from t_gl_voucher where 1=1 ";

    public static int[] initOrgPeriodDimGroupFromGLVoucher(QFilter[] queryGLVoucherFilters) {
        int totalGrpCnt = 0;
        int batchCnt = 0;
        TimeCostMeter timeCostMeter = TimeCostMeter.create((template, params) -> logger.info(template, params), 2);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi/bd/StatisticDBServiceHelper/initOrgPeriodDimGroupFromGLVoucher", (String)"gl_voucher", (String)"org, period", (QFilter[])queryGLVoucherFilters, null);){
            if (ds != null) {
                timeCostMeter.outputTimeLog("initOrgPeriodDimGroupFromGLVoucher : Query GL_VOUCHER Time Cost={}", timeCostMeter.getAndReset(0));
                DataSet distinctDs = ds.distinct();
                timeCostMeter.outputTimeLog("initOrgPeriodDimGroupFromGLVoucher : Distinct GL_VOUCHER(Org, Period) Time Cost={}", timeCostMeter.getAndReset(0));
                distinctDs.hasNext();
                timeCostMeter.outputTimeLog("initOrgPeriodDimGroupFromGLVoucher : Distinct GL_VOUCHER(Org, Period) First hasNext Time Cost={}", timeCostMeter.getAndReset(0));
                ArrayList<PairTuple<Long, Long>> buffer = new ArrayList<PairTuple<Long, Long>>(1000);
                int cnt = 0;
                while (distinctDs.hasNext()) {
                    Row row = distinctDs.next();
                    buffer.add(new PairTuple<Long, Long>(row.getLong(0), row.getLong(1)));
                    if (++cnt < 1000) continue;
                    StatisticDBServiceHelper.tryRegisterOrgPeriodDimGroup(buffer);
                    timeCostMeter.outputTimeLog("initOrgPeriodDimGroupFromGLVoucher : tryRegisterOrgPeriodDimGroup, TotalGrpCnt={}, BatchCnt={}, Time Cost={}", totalGrpCnt, batchCnt, timeCostMeter.getAndReset(0));
                    buffer.clear();
                    totalGrpCnt += cnt;
                    cnt = 0;
                    ++batchCnt;
                }
                if (!buffer.isEmpty()) {
                    StatisticDBServiceHelper.tryRegisterOrgPeriodDimGroup(buffer);
                    buffer.clear();
                    ++batchCnt;
                }
            }
        }
        timeCostMeter.outputTimeLog("Completed initOrgPeriodDimGroupFromGLVoucher : TotalGrpCnt={}, BatchCnt={}, Time Cost={}", totalGrpCnt, batchCnt, timeCostMeter.getAndReset(1));
        return new int[]{totalGrpCnt, batchCnt};
    }

    public static long[] deleteOrgPeriodDimGroup(Collection<Long> orgIds, Collection<Long> periodIds) {
        boolean continueDelete;
        QFilterBuilder filterBuilder = new QFilterBuilder();
        filterBuilder.addIn("org", orgIds, true);
        if (periodIds != null) {
            filterBuilder.addIn("period", periodIds);
        }
        long totalGrpCnt = 0L;
        long batchCnt = 0L;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_grp_orgprd");
        do {
            List deletePks;
            if (!(continueDelete = (deletePks = QueryServiceHelper.queryPrimaryKeys((String)"bd_grp_orgprd", (QFilter[])filterBuilder.toArray(new QFilter[0]), null, (int)1000)) != null && !deletePks.isEmpty())) continue;
            BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])deletePks.toArray());
            totalGrpCnt += (long)deletePks.size();
            ++batchCnt;
        } while (continueDelete);
        return new long[]{totalGrpCnt, batchCnt};
    }

    public static long[] insertOrgPeriodDimGroup(Iterator<PairTuple<Long, Long>> orgPeriodGroups) {
        if (orgPeriodGroups == null || !orgPeriodGroups.hasNext()) {
            return new long[0];
        }
        Date time = new Date(System.currentTimeMillis());
        long[] ids = DB.genGlobalLongIds((int)1000);
        BufferedIterator<Object[], PairTuple> iterator = new BufferedIterator<Object[], PairTuple>(orgPeriodGroups, () -> new Object[1000][], (seq, orgPeriod) -> new Object[]{ids[seq], orgPeriod.getKey(), orgPeriod.getValue(), time});
        while (iterator.hasNext()) {
            DB.executeBatch((DBRoute)ExIndexConstant.getRegTextDBRoute(), (String)SQL_Insert_OrgPeriodDimGroup, Arrays.asList(iterator.next()));
            long[] newIds = DB.genGlobalLongIds((int)ids.length);
            System.arraycopy(newIds, 0, ids, 0, ids.length);
        }
        return ids;
    }

    public static int checkExistOrgPeriodDimGroup(Map<PairTuple<Long, Long>, Long> srcDimGroupMap) {
        PairTuple<Long, Long> orgPeriod;
        if (srcDimGroupMap == null || srcDimGroupMap.isEmpty()) {
            return 0;
        }
        HashSet<Long> orgIds = new HashSet<Long>(srcDimGroupMap.size());
        HashSet<Long> perioIds = new HashSet<Long>(srcDimGroupMap.size());
        for (Map.Entry<PairTuple<Long, Long>, Long> en : srcDimGroupMap.entrySet()) {
            orgPeriod = en.getKey();
            if (orgPeriod == null) continue;
            if (orgPeriod.getKey() != null) {
                orgIds.add(orgPeriod.getKey());
            }
            if (orgPeriod.getValue() == null) continue;
            perioIds.add(orgPeriod.getValue());
        }
        QFilterBuilder builder = new QFilterBuilder().addEqual("status", "0");
        if (!orgIds.isEmpty()) {
            builder.addIn("org", orgIds);
        }
        if (!perioIds.isEmpty()) {
            builder.addIn("period", perioIds);
        }
        int result = 0;
        orgPeriod = new PairTuple<Object, Object>(null, null);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi/bd/StatisticDBServiceHelper/checkExistOrgPeriodDimGroup", (String)"bd_grp_orgprd", (String)"org, period, id", (QFilter[])builder.toArray(new QFilter[0]), null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row dataRow = ds.next();
                    if (!srcDimGroupMap.containsKey(orgPeriod.reset(dataRow.getLong(0), dataRow.getLong(1)))) continue;
                    srcDimGroupMap.put(orgPeriod, dataRow.getLong(2));
                    ++result;
                }
            }
        }
        return result;
    }

    public static Map<PairTuple<Long, Long>, Long> checkExistOrgPeriodDimGroup(Collection<PairTuple<Long, Long>> orgPeriodGroups) {
        LinkedHashMap<PairTuple<Long, Long>, Long> resultMap = new LinkedHashMap<PairTuple<Long, Long>, Long>(orgPeriodGroups.size());
        orgPeriodGroups.forEach(v -> {
            Long cfr_ignored_0 = resultMap.put((PairTuple<Long, Long>)v, (Long)null);
        });
        StatisticDBServiceHelper.checkExistOrgPeriodDimGroup(resultMap);
        return resultMap;
    }

    public static long[] tryRegisterOrgPeriodDimGroup(Collection<PairTuple<Long, Long>> orgPeriodGroups) {
        if (orgPeriodGroups == null || orgPeriodGroups.isEmpty()) {
            return new long[0];
        }
        Map<PairTuple<Long, Long>, Long> resultMap = StatisticDBServiceHelper.checkExistOrgPeriodDimGroup(orgPeriodGroups);
        LinkedList newDimGrp = new LinkedList();
        resultMap.entrySet().forEach(en -> {
            if (en.getValue() == null) {
                newDimGrp.add(en.getKey());
            }
        });
        return StatisticDBServiceHelper.insertOrgPeriodDimGroup(newDimGrp.iterator());
    }

    public static void getAvailableOrgPeriodGrp(BiFunction<Long, Long, Boolean> processFunc, Collection<Long> filterOrgIds, Collection<Long> filterPeriodIds) {
        QFilterBuilder filterBuilder = new QFilterBuilder();
        filterBuilder.addEqual("status", "0");
        filterBuilder.addIn("org", filterOrgIds, true);
        filterBuilder.addIn("period", filterPeriodIds, true);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fi/bd/StatisticDBServiceHelper/getAvailableOrgPeriodGrp", (String)"bd_grp_orgprd", (String)"org, period", (QFilter[])filterBuilder.toArray(new QFilter[0]), null);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row dataRow = ds.next();
                    if (processFunc.apply(dataRow.getLong(0), dataRow.getLong(1)).booleanValue()) continue;
                    return;
                }
            }
        }
    }
}

