/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.constant;

import kd.bos.db.DBRoute;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.bd.indexing.constant.CDCConstant;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.optimizor.OptimizeControlPanel;

public class ExIndexConstant {
    public static final int ES_UploadBatchSize = 5000;
    public static final int ES_Upload_Thread_Cnt = OptimizeControlPanel.getSysPropertyInteger("fi.cdc.thread.esindex", 2);
    public static final int ES_Query_Thread_Cnt = OptimizeControlPanel.getSysPropertyInteger("fi.ex-indexing.querythread.es", 1);
    public static final int MAX_USE_ES_INDEX_SIZE = OptimizeControlPanel.getSysPropertyInteger("fi.ex-indexing.MAX_USE_ES_INDEX_SIZE", 10000);
    public static final int MAX_DB_MATCH_CNT = OptimizeControlPanel.getSysPropertyInteger("fi.ex-indexing.MAX_DB_MATCH_CNT", 100000);
    public static final int RDSMS_Taks_ParalleCnt = CDCConstant.availableProcessors;
    public static final int ES_QueryValidateBatchSize = 500;
    public static final int ES_Query_Page_Size = OptimizeControlPanel.getSysPropertyInteger("fi.ex-indexing.es_page_size", 50);
    public static final int RegText_DB_IN_PARAM_SIZE = OptimizeControlPanel.getSysPropertyInteger("fi.ex-indexing.reg_text_in_param_size", 10000);
    public static final int RegText_DB_PARAM_LENTH = OptimizeControlPanel.getSysPropertyInteger("fi.ex-indexing.reg_text_param_length", 10000);
    public static final int ES_Query_Max_Cnt = OptimizeControlPanel.getSysPropertyInteger("fulltext.maxmatchsize", 2000) - ES_Query_Page_Size;
    private static final String ES_Server_Connect_Str_Prefix = "fi.ex-indexing.es.connect_str.";
    public static final String ES_Server_Module_FI = "fi";
    private static final String ES_Index_Enable_Prefix = "fi.ex-indexing.enable.es.";
    public static final int MAX_SQL_LENGTH = 30000;
    public static final ThreadPool Ex_Index_Task_Pool = ThreadPools.newCachedThreadPool((String)"FI/Ex_Index_Task_Pool", (int)1, (int)4);
    public static final String ES_Region_FI_FullText = "bd_regtextinfo";
    public static final String EN_RegTextInfo = "bd_regtextinfo";
    public static final String EN_RegTextOwnership = "bd_regtextownership";
    public static final String PK_ID = "id";
    private static final DBRoute _cache_RegTextInfo_DBRoute = DBRoute.of((String)"fi");
    public static final DBRoute _cache_FI_DBRoute = DBRoute.of((String)"fi");

    public static DBRoute getRegTextDBRoute() {
        return _cache_RegTextInfo_DBRoute;
    }

    public static DBRoute getFI_DBRoute() {
        return _cache_FI_DBRoute;
    }

    public static boolean isESIndexEnabled(String esIndexEntityName) {
        return OptimizeControlPanel.isESIndexEnabled() && IDataValueUtil.getBoolean(OptimizeControlPanel.getSysPropertyString(ES_Index_Enable_Prefix + esIndexEntityName, "N")) != false;
    }

    public static String getESRegionServerConnectionStrTemplate(String moduleName) {
        return System.getProperty(ES_Server_Connect_Str_Prefix + moduleName);
    }

    public static boolean isESIndexRegisteredOnSystemProperty(String esIndexEntityName) {
        return OptimizeControlPanel.getSysPropertyString("elasticsearch.server." + esIndexEntityName) != null;
    }

    public static void registerESIndexOnSystemProperty(String moduleName, String esIndexEntityName) {
        String connectionString = ExIndexConstant.getESRegionServerConnectionStrTemplate(moduleName);
        if (StringUtils.isEmpty((String)connectionString)) {
            throw new IllegalArgumentException("Cannot found Connection String for " + moduleName);
        }
        String esIndexFullName = "elasticsearch.server." + esIndexEntityName;
        OptimizeControlPanel.registerSystemPropertyDirect(esIndexFullName, String.format(connectionString, esIndexFullName));
        OptimizeControlPanel.registerSystemPropertyDirect(ES_Index_Enable_Prefix + esIndexEntityName, "Y");
    }
}

