/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.es;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bd.indexing.constant.RecordCheckStatus;
import kd.fi.bd.indexing.es.ElasticSearchHelper;
import kd.fi.bd.model.indexing.IExIndexQueryResult;
import kd.fi.bd.model.indexing.context.QueryPageInfo;
import kd.fi.bd.model.indexing.context.es.ESIndexQueryTextContext;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.pipe.AsyncStreamPipe;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public class ESIndexQueryHelper {
    private static final Log logger = LogFactory.getLog(ESIndexQueryHelper.class);

    public static FTFilter buildESFilter(String property, FTCompare cp, FTDataType dataType, Object value) {
        return new FTFilter(property, cp, FTValue.normal((FTDataType)dataType, (Object[])IDataValueUtil.concatToArray(value)));
    }

    public static FTFilter buildESInFilter(String property, FTDataType dataType, Collection values) {
        return new FTFilter(property, FTCompare.IN, FTValue.normal((FTDataType)dataType, (Object[])IDataValueUtil.concatToArray(values)));
    }

    public static FTFilter buildESLikeFilter(String property, FTDataType dataType, Object value) {
        return new FTFilter(property, FTCompare.LIKE, FTValue.normal((FTDataType)dataType, (Object[])new Object[]{value}));
    }

    public static void doESSearchMain(ESIndexQueryTextContext esIndexQueryTextContext, BiFunction<Integer, List<FTRowData>, Boolean> esResultProcFunc) {
        List esQueryResult;
        FTFilter finalEsQueryFilter;
        String esIndexName;
        if (esIndexQueryTextContext == null || StringUtils.isEmpty((String)(esIndexName = esIndexQueryTextContext.getIndexName())) || esIndexQueryTextContext.getEsQueryResultValidator() == null || (finalEsQueryFilter = esIndexQueryTextContext.getSingleESQueryFilter()) == null) {
            return;
        }
        TimeCostMeter timeMeter = TimeCostMeter.create(true, (template, params) -> logger.info(template, params), "stage", "Total");
        String esQueryTarget = esIndexQueryTextContext.getEsQueryTarget();
        FullTextQuery fullTextQuery = ElasticSearchHelper.instance.getFullTextQuery(esIndexName);
        timeMeter.outputTimeLog("Get Full Text Query: Time Cost={}", timeMeter.getAndReset(0));
        QueryPageInfo esQueryPageInfo = esIndexQueryTextContext.getQueryPageInof(1);
        boolean continueESQuery = true;
        int esQueryPageSize = esIndexQueryTextContext.getPageSize();
        int esQueryPageCnt = esIndexQueryTextContext.getTotalPageCnt();
        int maxESQueryCount = esQueryPageCnt * esQueryPageSize;
        String[] esSortProps = esIndexQueryTextContext.getESSortProps();
        String esQueryString = esIndexQueryTextContext.buildESSelectString();
        if (esIndexQueryTextContext.isTestESQueryExceedLimit()) {
            timeMeter.getAndReset(0);
            RecordCheckStatus checkStatus = RecordCheckStatus.Exceed_Limit;
            esQueryResult = fullTextQuery.search(esQueryTarget, esQueryString, finalEsQueryFilter, esSortProps, esQueryPageCnt, esQueryPageSize);
            continueESQuery = esQueryResult == null || esQueryResult.isEmpty();
            if (continueESQuery) {
                checkStatus = RecordCheckStatus.Within_Limit;
            }
            esIndexQueryTextContext.getExternalIndexQueryResult().setRecordCheckStatus(checkStatus);
            timeMeter.outputTimeLog("\t-->Test ES Query Exceed Limit [{}.{}]: continueESQuery={} (Page={}, PageSize={}): Time Cost={}, Filter={}", esIndexName, esQueryTarget, continueESQuery, esQueryPageCnt, esQueryPageSize, timeMeter.getAndReset(0), finalEsQueryFilter);
        }
        if (continueESQuery) {
            int curESPageIndex;
            do {
                timeMeter.getAndReset(0);
                curESPageIndex = esQueryPageInfo.getAndMoveNextPage();
                esQueryResult = fullTextQuery.search(esQueryTarget, esQueryString, finalEsQueryFilter, esSortProps, curESPageIndex, esQueryPageSize);
                timeMeter.outputTimeLog("\t-->ES Query [{}.{}] (Page={}, PageSize={}): Time Cost={}, Filter={}", esIndexName, esQueryTarget, curESPageIndex, esQueryPageSize, timeMeter.getAndReset(0), finalEsQueryFilter);
                if (!esQueryResult.isEmpty()) continue;
                timeMeter.outputTimeLog("\t-->ES Query Completed!", new Object[0]);
                esResultProcFunc.apply(curESPageIndex, null);
                break;
            } while ((continueESQuery = esResultProcFunc.apply(curESPageIndex, esQueryResult).booleanValue()) && esQueryPageInfo.getCurPageOffsetIndex() < (long)maxESQueryCount);
            timeMeter.outputTimeLog("ES Query [{}.{}]: Total ES Found Cnt={}, ES Page={}, Total Time={}(ms)", esQueryTarget, esQueryString, esQueryPageInfo.getTotalMatchCnt(), curESPageIndex, timeMeter.getAndReset(1));
        }
    }

    public static <E, T extends IExIndexQueryResult> T doESSearchAndValidate(ESIndexQueryTextContext<E, T> esIndexQueryTextContext) {
        TimeCostMeter timeMeter = TimeCostMeter.create(true, (template, params) -> logger.info(template, params), "stage", "total");
        BiFunction esQueryResultValidator = esIndexQueryTextContext.getEsQueryResultValidator();
        QueryPageInfo esQueryPageInfo = esIndexQueryTextContext.getQueryPageInof(1);
        long totalMatchCnt = esIndexQueryTextContext.getQueryPageInof(0).getTotalMatchCnt();
        AtomicBoolean continueESQuery = new AtomicBoolean(true);
        AsyncStreamPipe pipe = new AsyncStreamPipe();
        pipe.attach((index, dataBlock) -> {
            IExIndexQueryResult convertBuf;
            timeMeter.resetMeter(0);
            if (continueESQuery.get() && (convertBuf = (IExIndexQueryResult)esQueryResultValidator.apply(esIndexQueryTextContext, (List)dataBlock.getData())) != null && !convertBuf.isEmpty()) {
                ESIndexQueryTextContext eSIndexQueryTextContext = esIndexQueryTextContext;
                synchronized (eSIndexQueryTextContext) {
                    if (convertBuf.getRecordCheckStatus() == RecordCheckStatus.Exceed_Limit) {
                        esIndexQueryTextContext.setExternalIndexQueryResult(convertBuf);
                        continueESQuery.set(false);
                    } else if (esIndexQueryTextContext.getExternalIndexQueryResult() == null) {
                        esIndexQueryTextContext.setExternalIndexQueryResult(convertBuf);
                    } else {
                        esIndexQueryTextContext.getExternalIndexQueryResult().merge(convertBuf);
                    }
                }
                if (totalMatchCnt <= esQueryPageInfo.addMatchCnt(convertBuf.getActualMatchCnt())) {
                    continueESQuery.set(false);
                }
            }
            timeMeter.outputTimeLog("\t-->{} Validate ES Query Result: Loop Cnt={}, TotalMatchCnt={}, continueESQuery={}, Time Cost={}", continueESQuery.get() ? "" : "Skip", index, esQueryPageInfo.getTotalMatchCnt(), continueESQuery.get(), timeMeter.getAndReset(0));
        });
        Function esResultExtrator = esIndexQueryTextContext.getEsResultExtrator();
        ESIndexQueryHelper.doESSearchMain(esIndexQueryTextContext, (index, esQueryResult) -> {
            if (esQueryResult == null || esQueryResult.isEmpty()) {
                continueESQuery.set(false);
                esIndexQueryTextContext.getExternalIndexQueryResult().setRecordCheckStatus(RecordCheckStatus.Within_Limit);
            } else {
                pipe.putToQueue(esResultExtrator.apply((List<FTRowData>)esQueryResult));
            }
            return continueESQuery.get();
        });
        pipe.close();
        timeMeter.outputTimeLog("[After Pipe Close] ES Query [{}.{}]: Total ES Found Cnt={}, ES Page={}, Total Time={}(ms)", esIndexQueryTextContext.getIndexName(), esIndexQueryTextContext.getEsQueryTarget(), esQueryPageInfo.getTotalMatchCnt(), esQueryPageInfo.getCurrentPageIndex(), timeMeter.getAndReset(1));
        T queryResult = esIndexQueryTextContext.getExternalIndexQueryResult();
        RecordCheckStatus preSetStatus = esIndexQueryTextContext.getExternalIndexQueryResult().getRecordCheckStatus();
        if (RecordCheckStatus.UnCheck == preSetStatus || RecordCheckStatus.Within_Limit == preSetStatus) {
            int _MaxESQuerySize = esIndexQueryTextContext.getPageSize() * esIndexQueryTextContext.getTotalPageCnt();
            if (esQueryPageInfo.getCurPageOffsetIndex() > (long)_MaxESQuerySize) {
                queryResult.setRecordCheckStatus(RecordCheckStatus.Exceed_Limit);
            } else {
                queryResult.setRecordCheckStatus(queryResult.isEmpty() ? RecordCheckStatus.No_Record : RecordCheckStatus.Within_Limit);
            }
        }
        return queryResult.pack();
    }
}

