/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.es;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.storage.highlevel.HighLevelAccess;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.indexing.constant.ESTextMatchModeEnum;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.filter.WildcardMatcher;
import kd.fi.bd.util.filter.WildcardPositionEnum;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSearchHelper {
    private Map<String, FullTextUpdater> fullTextUpdaterMap = new ConcurrentHashMap<String, FullTextUpdater>(4);
    private static Map<String, FullTextQuery> fullTextQueryMap;
    public static final ElasticSearchHelper instance;

    private ElasticSearchHelper() {
        fullTextQueryMap = new ConcurrentHashMap<String, FullTextQuery>(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(ESConnectorType cacheType) {
        switch (cacheType) {
            case Updater: {
                Map<String, FullTextUpdater> map = this.fullTextUpdaterMap;
                synchronized (map) {
                    this.fullTextUpdaterMap.clear();
                    break;
                }
            }
            case Query: {
                Map<String, FullTextQuery> map = fullTextQueryMap;
                synchronized (map) {
                    fullTextQueryMap.clear();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextUpdater getFullTextUpdater(String indexName) {
        FullTextUpdater updater = this.fullTextUpdaterMap.get(indexName);
        if (updater == null) {
            Map<String, FullTextUpdater> map = this.fullTextUpdaterMap;
            synchronized (map) {
                updater = this.fullTextUpdaterMap.get(indexName);
                if (updater == null) {
                    updater = FullTextFactory.getFullTextUpdater((String)indexName);
                    this.fullTextUpdaterMap.put(indexName, updater);
                }
            }
        }
        return updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextQuery getFullTextQuery(String esIndexName) {
        FullTextQuery fullTextQuery = fullTextQueryMap.get(esIndexName);
        if (fullTextQuery == null) {
            Map<String, FullTextQuery> map = fullTextQueryMap;
            synchronized (map) {
                fullTextQuery = fullTextQueryMap.get(esIndexName);
                if (fullTextQuery == null) {
                    fullTextQuery = FullTextFactory.getFullTextQuery((String)esIndexName);
                    fullTextQueryMap.put(esIndexName, fullTextQuery);
                }
            }
        }
        return fullTextQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadFullTextClient(String esIndexName) {
        Map<String, FullTextUpdater> map = this.fullTextUpdaterMap;
        synchronized (map) {
            this.fullTextUpdaterMap.put(esIndexName, FullTextFactory.getFullTextUpdater((String)esIndexName));
        }
        map = fullTextQueryMap;
        synchronized (map) {
            fullTextQueryMap.put(esIndexName, FullTextFactory.getFullTextQuery((String)esIndexName));
        }
    }

    public static boolean isIndexExist(String esIndexName) {
        return HighLevelAccess.isIndexExist((RestHighLevelClient)HighLevelAccess.createRestHighLevelClient((String)esIndexName), (String)ElasticSearchHelper.buildIndexFullName(esIndexName));
    }

    public static String buildIndexFullName(String esIndexEntityName) {
        return CommonUtil.getIndexNamePrefix((String)esIndexEntityName) + "_data";
    }

    public static Map<String, String> getSystemConfiguredESIndex(String subPrefix) {
        String esPrefix = "elasticsearch.server.";
        String lookupPrefix = subPrefix == null ? "elasticsearch.server." : "elasticsearch.server." + subPrefix;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(8);
        WildcardMatcher.filterSystemConfigured(WildcardPositionEnum.Prefix, Collections.singleton(lookupPrefix), (name, value) -> {
            result.put(name.replace("elasticsearch.server.", ""), (String)value);
            return true;
        });
        return result;
    }

    public static FTCompare convertFilterQCP(String srcQcp, ESTextMatchModeEnum forceMatchMode) {
        switch (srcQcp.toLowerCase()) {
            case "=": {
                return FTCompare.EQ;
            }
            case ">=": 
            case ">": {
                return FTCompare.GT;
            }
            case "<=": 
            case "<": {
                return FTCompare.LT;
            }
            case "in": {
                return FTCompare.IN;
            }
            case "exists": 
            case "like": 
            case "ilike": 
            case "match": 
            case "ftlike": {
                return forceMatchMode.getValue();
            }
            case "is not null": {
                return FTCompare.NOTNULL;
            }
        }
        throw new IllegalArgumentException("Unsupported Query Operator: " + srcQcp);
    }

    public static void convertQFilterToESFilter(ESTextMatchModeEnum textMatchMode, Map<String, PairTuple<String, FTDataType>> esFilterProps, BiConsumer<FTFilter, Integer> convertProcFunc, Collection<QFilter> srcFilters) {
        if (convertProcFunc == null || srcFilters == null || srcFilters.isEmpty() || esFilterProps == null || esFilterProps.isEmpty()) {
            return;
        }
        QFilterBuilder.collectFilterInfos(srcFilters, (filter, index) -> {
            PairTuple esProp = (PairTuple)esFilterProps.get(filter.getProperty());
            if (FTDataType.STRING.equals(esProp.getValue())) {
                switch (filter.getCP().toLowerCase()) {
                    case "like": 
                    case "match": 
                    case "ftlike": {
                        filter.__setValue((Object)WildcardMatcher.trimWildcardKeys(WildcardPositionEnum.Pre_Suffix, filter.getValue()));
                        break;
                    }
                }
            }
            FTValue ftValue = filter.getValue() instanceof Collection ? FTValue.normal((FTDataType)((FTDataType)esProp.getValue()), (Object[])((Collection)filter.getValue()).toArray()) : FTValue.normal((FTDataType)((FTDataType)esProp.getValue()), (Object[])new Object[]{filter.getValue()});
            convertProcFunc.accept(new FTFilter((String)esProp.getKey(), ElasticSearchHelper.convertFilterQCP(filter.getCP(), textMatchMode), ftValue), (Integer)index);
        }, esFilterProps.keySet().toArray(new String[0]));
    }

    public static void convertQFilterToESFilter(ESTextMatchModeEnum textMatchMode, Map<String, PairTuple<String, FTDataType>> esFilterProps, BiConsumer<FTFilter, Integer> convertProcFunc, QFilter ... srcFilters) {
        ElasticSearchHelper.convertQFilterToESFilter(textMatchMode, esFilterProps, convertProcFunc, Arrays.asList(srcFilters));
    }

    public static List<FTFilter> convertQFilterToESFilter(ESTextMatchModeEnum textMatchMode, Map<String, PairTuple<String, FTDataType>> esFilterProps, Collection<QFilter> srcFilters) {
        LinkedList<FTFilter> esFilters = new LinkedList<FTFilter>();
        ElasticSearchHelper.convertQFilterToESFilter(textMatchMode, esFilterProps, (FTFilter f, Integer i) -> esFilters.add((FTFilter)f), srcFilters);
        return esFilters;
    }

    public static FTValue cloneFTValue(FTValue src) {
        if (src == null) {
            return null;
        }
        FTValue newValue = src.isLang() ? FTValue.lang((Lang)src.getLang(), (String[])IDataValueUtil.enumerateObjectToArray(src.getValues(), String.class)) : (src.isPinyin() ? FTValue.pinyin((String[])IDataValueUtil.enumerateObjectToArray(src.getValues(), String.class)) : FTValue.normal((FTDataType)src.getDataType(), (Object[])src.getValues()));
        return newValue;
    }

    static {
        instance = new ElasticSearchHelper();
    }

    public static enum ESConnectorType {
        Updater,
        Query;

    }
}

