/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.es;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.PropertyValue;
import kd.bos.util.StringUtils;

public class FullTextSearchIndexMeta
implements Function<Row, BatchValue> {
    private String indexName;
    private DBRoute dbRoute;
    private String queryTarget;
    private MainEntityType srcDataEntityType;
    private MatchProperty pk;
    private Map<String, List<MatchProperty>> valueProps;
    private Function<Row, Boolean> dataRowValidator;
    private MatchProperty[] _convertPropCache;

    protected FullTextSearchIndexMeta(String indexName, String pkFieldName, FTDataType pkDataType) {
        this.indexName = indexName;
        this.valueProps = new LinkedHashMap<String, List<MatchProperty>>(2);
        this.dataRowValidator = row -> true;
        this.pk = new MatchProperty(pkFieldName, pkDataType);
    }

    public FullTextSearchIndexMeta(String indexName, String entityName, String pkFieldName, FTDataType pkDataType) {
        this(indexName, pkFieldName, pkDataType);
        this.queryTarget = entityName;
        this.srcDataEntityType = EntityMetadataCache.getDataEntityType((String)this.queryTarget);
        this.dbRoute = DBRoute.of((String)this.srcDataEntityType.getDBRouteKey());
    }

    public FullTextSearchIndexMeta(String indexName, DBRoute dbRoute, String queryTarget, String pkFieldName, FTDataType pkDataType) {
        this(indexName, pkFieldName, pkDataType);
        this.queryTarget = queryTarget;
        this.dbRoute = dbRoute;
    }

    public String toString() {
        return "FullTextSearchIndexMeta{indexName='" + this.indexName + '\'' + ", dbRoute=" + this.dbRoute + ", queryTarget='" + this.queryTarget + '\'' + ", srcDataEntityType=" + this.srcDataEntityType + ", pk=" + this.pk + ", valueProps=" + this.valueProps + ", dataRowValidator=" + this.dataRowValidator + '}';
    }

    public static boolean isValidEntityProp(MainEntityType srcDataEntityType, String fieldPrefix, String fieldName) {
        DataEntityPropertyCollection propertyCollection = srcDataEntityType.getProperties();
        String[] paths = fieldPrefix.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            IDataEntityProperty propertyBuf = (IDataEntityProperty)propertyCollection.get((Object)paths[i]);
            if (propertyBuf == null) {
                throw new KDBizException(String.format("Invalid Property Name: %s in %s", propertyBuf, fieldPrefix));
            }
            if (i >= paths.length - 1) continue;
            if (propertyBuf instanceof DynamicCollectionProperty) {
                propertyCollection = ((DynamicCollectionProperty)propertyBuf).getDynamicCollectionItemPropertyType().getProperties();
                continue;
            }
            throw new KDBizException(String.format("Invalid Property Type: %s in %s expect DynamicCollectionProperty, but found %s", propertyBuf, fieldPrefix, propertyBuf.getClass()));
        }
        return propertyCollection != null ? propertyCollection.containsKey((Object)fieldName) : false;
    }

    public FullTextSearchIndexMeta addValueProp(String fieldPrefix, String fieldName, FTDataType dataType) {
        if (dataType == null || StringUtils.isEmpty((String)fieldName)) {
            return this;
        }
        if (StringUtils.isEmpty((String)fieldPrefix)) {
            if (fieldName.equalsIgnoreCase(this.pk.getPropertyName())) {
                return this;
            }
        } else if (this.srcDataEntityType != null && !FullTextSearchIndexMeta.isValidEntityProp(this.srcDataEntityType, fieldPrefix, fieldName)) {
            throw new KDBizException(String.format("Invalid Property Name: %s in %s", fieldName, fieldPrefix));
        }
        this.valueProps.computeIfAbsent(fieldPrefix != null ? fieldPrefix : "", v -> new LinkedList()).add(new MatchProperty(fieldName, dataType));
        return this;
    }

    public void processProps(BiConsumer<String, MatchProperty> propertyBiConsumer) {
        propertyBiConsumer.accept("", this.pk);
        for (Map.Entry<String, List<MatchProperty>> en : this.valueProps.entrySet()) {
            String prefix = StringUtils.isEmpty((String)en.getKey()) ? "" : en.getKey() + ".";
            for (MatchProperty property : en.getValue()) {
                propertyBiConsumer.accept(prefix, property);
            }
        }
    }

    public MatchProperty[] getQueryProps(boolean includePK) {
        LinkedList resultList = new LinkedList();
        this.processProps((prefix, prop) -> {
            if (!includePK && prop.getPropertyName().equalsIgnoreCase(this.pk.getPropertyName())) {
                return;
            }
            resultList.add(new MatchProperty(prefix + prop.getPropertyName(), prop.getDataType()));
        });
        return resultList.toArray(new MatchProperty[0]);
    }

    public String buildQueryString() {
        StringBuilder buf = new StringBuilder();
        this.processProps((prefix, prop) -> buf.append((String)prefix).append(prop.getPropertyName()).append(","));
        int length = buf.length();
        return length > 0 ? buf.substring(0, length - 2) : "";
    }

    public MatchProperty[] refreashESConvertProps() {
        this._convertPropCache = this.getQueryProps(false);
        return this._convertPropCache;
    }

    @Override
    public BatchValue apply(Row row) {
        Object[] valueBuf;
        if (!this.dataRowValidator.apply(row).booleanValue()) {
            return null;
        }
        if (row instanceof AbstractRow) {
            valueBuf = ((AbstractRow)row).values();
        } else {
            valueBuf = new Object[this._convertPropCache.length];
            for (int i = 0; i < this._convertPropCache.length; ++i) {
                valueBuf[i] = row.get(i);
            }
        }
        return this.apply(valueBuf);
    }

    @Override
    public BatchValue apply(Object[] valueParams) {
        if (valueParams == null) {
            return null;
        }
        PropertyValue[] fetchValueBuf = new PropertyValue[this._convertPropCache.length];
        int i = 0;
        for (MatchProperty prop : this._convertPropCache) {
            fetchValueBuf[i] = new PropertyValue(prop.getPropertyName(), prop.getDataType(), valueParams[i + 1]);
            ++i;
        }
        return new BatchValue(valueParams[0], fetchValueBuf);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public MatchProperty getPk() {
        return this.pk;
    }

    public void setPk(MatchProperty pk) {
        this.pk = pk;
    }

    public Map<String, List<MatchProperty>> getValueProps() {
        return this.valueProps;
    }

    public DBRoute getDbRoute() {
        return this.dbRoute;
    }

    public void setDbRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public String getQueryTarget() {
        return this.queryTarget;
    }

    public void setQueryTarget(String queryTarget) {
        this.queryTarget = queryTarget;
    }

    public Function<Row, Boolean> getDataRowValidator() {
        return this.dataRowValidator;
    }

    public FullTextSearchIndexMeta setDataRowValidator(Function<Row, Boolean> dataRowValidator) {
        this.dataRowValidator = dataRowValidator;
        return this;
    }

    public boolean isDirectDBQuery() {
        return this.srcDataEntityType == null;
    }
}

