/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.tasks;

import java.util.Arrays;
import java.util.Collection;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.indexing.cdc.CDCDBServiceHelper;
import kd.fi.bd.indexing.constant.CDCStatusEnum;
import kd.fi.bd.model.indexing.es.CDCTaskStatus;
import kd.fi.bd.tasks.common.AbstractBaseWorkTask;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public abstract class AbstractCDCProcessTask<CONTEXT, PK, RESULT>
extends AbstractBaseWorkTask<String, String, RESULT> {
    private static final Log logger = LogFactory.getLog(AbstractCDCProcessTask.class);
    private static final long Task_Status_Format_Version = 1L;
    private static final int batchSize = 5000;
    protected CDCTaskStatus _cdc_task_status;
    protected CONTEXT taskProcessContext;
    protected Collection<PK> _currentBatchPks;
    protected QFilterBuilder _taskBaseFilter;
    protected transient TimeCostMeter _timeCostMeter;
    protected Long orgId;
    protected Long periodId;

    public AbstractCDCProcessTask(String groupId, Long orgId, Long periodId, QFilterBuilder taskBaseFilter) {
        super(groupId, periodId + "_" + orgId);
        this.orgId = orgId;
        this.periodId = periodId;
        this._taskBaseFilter = taskBaseFilter;
    }

    protected TimeCostMeter getTimeCostMeter() {
        if (this._timeCostMeter == null) {
            this._timeCostMeter = new TimeCostMeter(2);
            this._timeCostMeter.setFixLogPrefix(String.format("[Task:%s, Org:%s, Period:%s]:", this.getTaskType(), this.orgId, this.periodId));
            this.customizeTimeCostMeter(this._timeCostMeter);
        }
        return this._timeCostMeter;
    }

    protected void customizeTimeCostMeter(TimeCostMeter timeCostMeter) {
        timeCostMeter.addLogOutput((template, params) -> logger.info(template, params));
    }

    @Override
    protected void initialization() {
        super.initialization();
        this.getTimeCostMeter();
    }

    protected abstract int getTaskType();

    protected abstract String getLockKey();

    protected static <T extends Number> void mergerStatisticCnt(Long[] total, T[] subset) {
        if (subset == null) {
            return;
        }
        for (int i = 0; i < Math.min(total.length, subset.length); ++i) {
            if (subset[i] == null) continue;
            if (total[i] == null) {
                total[i] = 0L;
            }
            Long[] longArray = total;
            int n = i;
            Long.valueOf(longArray[n] + ((Number)subset[i]).longValue());
        }
    }

    protected String getDefaultTaskStatus() {
        return CDCStatusEnum.ENABLE.getStringValue();
    }

    protected abstract <T> void mergerTaskStatisticResult(RESULT var1, T var2);

    @Override
    protected RESULT doTaskJob() {
        block23: {
            String lockKey = this.getLockKey();
            Object[] totalCnt = new Long[4];
            Arrays.fill(totalCnt, (Object)0L);
            String taskStatus = this.getDefaultTaskStatus();
            try (DLock lock = DLock.create((String)lockKey).fastMode();){
                if (lock.tryLock()) {
                    this._cdc_task_status = this.beginNewCDCTrans();
                    if (this._cdc_task_status != null) {
                        try {
                            while (this.fetchNextBatchCDCChangedRecHist(5000)) {
                                this.mergerTaskStatisticResult(this.taskResult, this.processCDCChangeRecords(this.taskProcessContext, this._taskBaseFilter, this._currentBatchPks));
                            }
                            break block23;
                        }
                        catch (Exception e) {
                            taskStatus = CDCStatusEnum.FAILURE.getStringValue();
                            throw e;
                        }
                        finally {
                            if (this._cdc_task_status != null) {
                                CDCDBServiceHelper.endCDCTaskTrans(this._cdc_task_status, taskStatus);
                            }
                        }
                    }
                    this.onBeginNewCDCTransFailed();
                    break block23;
                }
                logger.error("{}.tryLock Failed: Org={}, Period={}", new Object[]{this.getClass().getSimpleName(), this.orgId, this.periodId});
            }
            catch (Exception ex) {
                logger.error("Error: {} --> on taskProcessContext={}, baseFilter={}, _currentBatchPks={}", new Object[]{ex.getMessage(), this.taskProcessContext, this._taskBaseFilter, this._currentBatchPks});
                logger.error((Throwable)ex);
            }
        }
        return (RESULT)this.taskResult;
    }

    protected void onBeginNewCDCTransFailed() {
    }

    protected CDCTaskStatus beginNewCDCTrans() {
        return CDCDBServiceHelper.registerNewCDCTaskTrans(this.getTaskType(), this.orgId, this.periodId);
    }

    protected abstract boolean fetchNextBatchCDCChangedRecHist(int var1);

    protected abstract RESULT processCDCChangeRecords(CONTEXT var1, QFilterBuilder var2, Collection<PK> var3);
}

