/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.indexing.cdc.CDCDBServiceHelper;
import kd.fi.bd.indexing.constant.ExIndexConstant;
import kd.fi.bd.indexing.tasks.AbstractCDCProcessTask;
import kd.fi.bd.indexing.tasks.CDCGLVoucherTextProcessTask;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.tasks.common.AbstractBaseWorkTask;
import kd.fi.bd.util.exception.KDExceptionBuilder;
import kd.fi.bd.util.timemeter.TimeCostMeter;

public class GLVoucherTextProcessGroupTask
extends AbstractBaseWorkTask<String, String, Long[]> {
    private static final Log logger = LogFactory.getLog(GLVoucherTextProcessGroupTask.class);
    protected Collection<Long> filterOrgIds;
    protected Collection<Long> filterPeriodIds;
    protected Integer outputIndexRegNum;
    protected BiFunction<Integer, PairTuple<Long, Long>, AbstractCDCProcessTask> taskCreator;

    public GLVoucherTextProcessGroupTask(String groupId, Integer outputIndexRegNum, Collection<Long> filterOrgIds, Collection<Long> filterPeriodIds) {
        this(groupId, outputIndexRegNum, filterOrgIds, filterPeriodIds, (Integer regNum, PairTuple<Long, Long> orgPeriod) -> new CDCGLVoucherTextProcessTask((Object)groupId, (Integer)regNum, (Long)orgPeriod.getKey(), (Long)orgPeriod.getValue()));
    }

    public GLVoucherTextProcessGroupTask(String groupId, Integer outputIndexRegNum, Collection<Long> filterOrgIds, Collection<Long> filterPeriodIds, BiFunction<Integer, PairTuple<Long, Long>, AbstractCDCProcessTask> taskCreator) {
        super(groupId, groupId);
        this.outputIndexRegNum = outputIndexRegNum;
        this.filterOrgIds = filterOrgIds;
        this.filterPeriodIds = filterPeriodIds;
        this.taskCreator = taskCreator;
    }

    public GLVoucherTextProcessGroupTask(String groupId, Integer outputIndexRegNum) {
        this(groupId, outputIndexRegNum, null, null, (Integer regNum, PairTuple<Long, Long> orgPeriod) -> new CDCGLVoucherTextProcessTask((Object)groupId, (Integer)regNum, (Long)orgPeriod.getKey(), (Long)orgPeriod.getValue()));
    }

    protected void generateCDCTask(List<Future<Long[]>> taskRefList) {
        CDCDBServiceHelper.getAvailableCDCTaskGroup(0, this.filterOrgIds, this.filterPeriodIds, grp -> {
            logger.info("Start CDC_TASK_RegText for {}", grp);
            AbstractCDCProcessTask task = this.taskCreator.apply(this.outputIndexRegNum, (PairTuple<Long, Long>)grp);
            task.setTaskGroupCondition(this.taskGroupCondition);
            taskRefList.add(ExIndexConstant.Ex_Index_Task_Pool.submit((Callable)task));
            return true;
        });
    }

    protected boolean waitForGroupTaskCompleted(List<Future<Long[]>> taskRefList) {
        Long[] batchTotalCnt = new Long[4];
        for (Future<Long[]> taskFuture : taskRefList) {
            try {
                CDCGLVoucherTextProcessTask.mergerStatisticCnt((Long[])batchTotalCnt, (Number[])taskFuture.get());
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw KDExceptionBuilder.buildKDBizException("Wait For Task Result Error: " + ex.getMessage());
            }
        }
        int checkBatchCnt = 0;
        for (int i = 0; i < batchTotalCnt.length; ++i) {
            if (batchTotalCnt[i] == null) continue;
            checkBatchCnt = (int)((long)checkBatchCnt + batchTotalCnt[i]);
            Long[] longArray = (Long[])this.taskResult;
            int n = i;
            Long.valueOf(longArray[n] + batchTotalCnt[i]);
        }
        return checkBatchCnt <= 0;
    }

    @Override
    protected Long[] doTaskJob() {
        boolean continueCheckTaskGroup;
        TimeCostMeter timeMeter = TimeCostMeter.create((template, params) -> logger.info(template, params), "stage", "total");
        this.taskResult = new Long[4];
        Arrays.fill((Object[])this.taskResult, (Object)0L);
        LinkedList<Future<Long[]>> taskResultList = new LinkedList<Future<Long[]>>();
        int checkLoopCnt = 1;
        do {
            taskResultList.clear();
            this.generateCDCTask(taskResultList);
            continueCheckTaskGroup = this.waitForGroupTaskCompleted(taskResultList);
            long totalTime = timeMeter.getAndReset(1);
            timeMeter.outputTimeLog("--> [GLVoucherCDCGroupTask Completed -- checkLoopCnt={}, continueCheckTaskGroup:{}]: Total Batch Group:{} Statistic: {}\tTotal Time:{}(ms), AvgTime={}(ms)", checkLoopCnt, continueCheckTaskGroup, taskResultList.size(), Arrays.deepToString((Object[])this.taskResult), totalTime, totalTime / (long)(taskResultList.isEmpty() ? 1 : taskResultList.size()));
        } while (continueCheckTaskGroup && ++checkLoopCnt < 3);
        return (Long[])this.taskResult;
    }
}

