/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.indexing.tasks;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.indexing.cdc.StatisticDBServiceHelper;
import kd.fi.bd.indexing.tasks.AbstractCDCProcessTask;
import kd.fi.bd.indexing.tasks.GLVoucherTextProcessGroupTask;
import kd.fi.bd.indexing.tasks.GLVoucherTextProcessTask;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.threads.FIConfigurableThreadService;
import kd.fi.bd.threads.ThreadCategoryEnum;

public class InitGLVoucherTextGroupTask
extends GLVoucherTextProcessGroupTask {
    private static final Log logger = LogFactory.getLog(InitGLVoucherTextGroupTask.class);

    public InitGLVoucherTextGroupTask(String groupId, Integer outputIndexRegNum, Collection<Long> filterOrgIds, Collection<Long> filterPeriodIds) {
        super(groupId, outputIndexRegNum, filterOrgIds, filterPeriodIds, (Integer regNum, PairTuple<Long, Long> orgPeriod) -> new GLVoucherTextProcessTask(groupId, (Integer)regNum, (Long)orgPeriod.getKey(), (Long)orgPeriod.getValue()));
    }

    public InitGLVoucherTextGroupTask(String groupId, Integer outputIndexRegNum) {
        super(groupId, outputIndexRegNum);
    }

    @Override
    protected void generateCDCTask(List<Future<Long[]>> taskRefList) {
        StatisticDBServiceHelper.getAvailableOrgPeriodGrp((org, period) -> {
            logger.info("Start Init GLVoucherTextProcessTask for org={}, period={}", org, period);
            AbstractCDCProcessTask task = (AbstractCDCProcessTask)this.taskCreator.apply(this.outputIndexRegNum, new PairTuple<Long, Long>((Long)org, (Long)period));
            task.setTaskGroupCondition(this.taskGroupCondition);
            return taskRefList.add(FIConfigurableThreadService.getInstance().submit(ThreadCategoryEnum.FI_TEMP, task));
        }, this.filterOrgIds, this.filterPeriodIds);
    }

    @Override
    protected boolean waitForGroupTaskCompleted(List<Future<Long[]>> taskRefList) {
        super.waitForGroupTaskCompleted(taskRefList);
        return false;
    }
}

