/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.lock;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AssisstAddingLockHelper {
    private static final Log LOG = LogFactory.getLog(AssisstAddingLockHelper.class);

    private AssisstAddingLockHelper() {
    }

    public static String createLockKey(long accountTableId, String accountNumber) {
        Preconditions.checkArgument((accountTableId > 0L ? 1 : 0) != 0, (Object)("invalid account table id:" + accountTableId));
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accountNumber}), (Object)("invalid account num:" + accountNumber));
        return String.format("fi/bd/assistadding/%s_%s", accountNumber, accountTableId);
    }

    public static void assistAddingWithLock(long accountTableId, String accountNumber, String lockDesc, Consumer<DLock> processor) {
        String key = AssisstAddingLockHelper.createLockKey(accountTableId, accountNumber);
        try (DLock dLock = DLock.create((String)key, (String)lockDesc).fastMode();){
            boolean success = dLock.tryLock();
            if (!success) {
                LOG.info("assist adding had been locked on key: " + key);
                Optional<DLockInfo> lockingInfo = AssisstAddingLockHelper.getLockInfo(accountTableId, accountNumber);
                if (lockingInfo.isPresent()) {
                    throw new KDBizException(lockingInfo.get().getDesc());
                }
                throw new KDBizException("assist adding got lock faild: " + key);
            }
            LOG.info("assist adding got lock success: " + key + ", detail info: " + AssisstAddingLockHelper.getWorkingLockInfo(accountTableId, accountNumber).toString());
            try {
                processor.accept(dLock);
            }
            catch (Exception e) {
                LOG.error("failed assist adding on locking account: " + accountNumber + " accountTableId: " + accountTableId, (Throwable)e);
                dLock.unlock();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
            }
        }
    }

    private static Optional<DLockInfo> getLockInfo(long accountTableId, String accountNumber) {
        String key = AssisstAddingLockHelper.createLockKey(accountTableId, accountNumber);
        return Optional.ofNullable(DLock.getLockInfo((String)key));
    }

    public static Optional<DLockInfo> getWorkingLockInfo(long accountTableId, String accountNumber) {
        Optional<DLockInfo> lockInfo = AssisstAddingLockHelper.getLockInfo(accountTableId, accountNumber);
        if (lockInfo.isPresent()) {
            if (DateUtils.addMinutes((Date)lockInfo.get().getCreateTime(), (int)30).compareTo(new Date()) < 0) {
                AssisstAddingLockHelper.forceUnlock(lockInfo.get().getKey());
                return Optional.empty();
            }
            return lockInfo;
        }
        return Optional.empty();
    }

    public static void forceUnlock(String key) {
        DLock.forceClear((String[])new String[]{key});
    }

    public static void assistAddingWithLock(String itemNumber, String lockDesc, Consumer<DLock> processor) {
        String key = "fi/bd/cfassistadding/" + itemNumber;
        try (DLock dLock = DLock.create((String)key, (String)lockDesc).fastMode();){
            boolean success = dLock.tryLock();
            if (!success) {
                LOG.info("assist adding had been locked on key: " + key);
                Optional<DLockInfo> lockingInfo = AssisstAddingLockHelper.getLockInfo(itemNumber);
                if (lockingInfo.isPresent()) {
                    throw new KDBizException(lockingInfo.get().getDesc());
                }
                throw new KDBizException("assist adding got lock faild: " + key);
            }
            try {
                processor.accept(dLock);
            }
            catch (Exception e) {
                LOG.error("failed assist adding on locking cashflowitem: " + itemNumber, (Throwable)e);
                dLock.unlock();
                throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
            }
        }
    }

    public static Optional<DLockInfo> getWorkingLockInfo(String itemNumber) {
        Optional<DLockInfo> lockInfo = AssisstAddingLockHelper.getLockInfo(itemNumber);
        if (lockInfo.isPresent()) {
            if (DateUtils.addMinutes((Date)lockInfo.get().getCreateTime(), (int)30).compareTo(new Date()) < 0) {
                AssisstAddingLockHelper.forceUnlock(lockInfo.get().getKey());
                return Optional.empty();
            }
            return lockInfo;
        }
        return Optional.empty();
    }

    private static Optional<DLockInfo> getLockInfo(String itemNumber) {
        String key = "fi/bd/cfassistadding/" + itemNumber;
        return Optional.ofNullable(DLock.getLockInfo((String)key));
    }
}

