/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.indexing.context.es;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.db.DB;
import kd.fi.bd.model.indexing.es.CDCTaskStatus;
import kd.fi.bd.model.indexing.es.RegTextOwnership;
import kd.fi.bd.model.indexing.es.RegistedTextInfoModel;

public class VoucherTextProcContext {
    private long orgId;
    private long periodId;
    private long[] _cache_max_Ids;
    private Function<Integer, long[]> idGenerator;
    private transient List<RegTextOwnership> _cache_regTextOwnerships;
    private RegTextOwnership[] _regTextOwnerships;
    private Map<Long, Integer> _regTextOwnershipsIndex;
    private transient Map<String, List<Integer>> _cache_TextToRefRecIndex;
    private List<Long> needUpdateRefCntTextIds;
    private Set<Long> needCheckExistSrcEntryIds;
    private transient List<Object[]> _cache_NewTextProcList;
    private Map<Long, RegistedTextInfoModel> _regTextInfos;
    private List<Integer>[] recCategory;

    public VoucherTextProcContext(long orgId, long periodId) {
        this(orgId, periodId, cnt -> DB.genGlobalLongIds((int)cnt));
    }

    public VoucherTextProcContext(long orgId, long periodId, Function<Integer, long[]> idGenerator) {
        this.orgId = orgId;
        this.periodId = periodId;
        this.idGenerator = idGenerator;
        this._cache_TextToRefRecIndex = new LinkedHashMap<String, List<Integer>>(64);
        this._cache_regTextOwnerships = new LinkedList<RegTextOwnership>();
        this.recCategory = new List[3];
        this.recCategory[0] = new LinkedList<Integer>();
        this.recCategory[1] = new LinkedList<Integer>();
        this.recCategory[2] = new LinkedList<Integer>();
        this._cache_max_Ids = new long[3];
        this._cache_max_Ids[0] = 0L;
        this._cache_max_Ids[1] = 0L;
        this._cache_max_Ids[2] = 0L;
    }

    public String toString() {
        return "VoucherTextProcContext{orgId=" + this.orgId + ", periodId=" + this.periodId + ", _cache_max_Ids=" + Arrays.toString(this._cache_max_Ids) + ", idGenerator=" + this.idGenerator + ", _cache_regTextOwnerships=" + this._cache_regTextOwnerships + ", _regTextOwnerships=" + Arrays.toString(this._regTextOwnerships) + ", _regTextOwnershipsIndex=" + this._regTextOwnershipsIndex + ", _cache_TextToRefRecIndex=" + this._cache_TextToRefRecIndex + ", _cache_NewTextProcList=" + this._cache_NewTextProcList + ", _regTextInfos=" + this._regTextInfos + ", recCategory=" + Arrays.toString(this.recCategory) + '}';
    }

    public void addNewVoucherTextProcRec(boolean asNewRecord, long srcId, long srcEntryId, String text) {
        if (text == null || "".equals(text = text.trim())) {
            return;
        }
        int refRecIndex = this._cache_regTextOwnerships.size();
        this._cache_TextToRefRecIndex.computeIfAbsent(text, v -> new LinkedList()).add(refRecIndex);
        this.updateLastMaxID(1, srcId);
        this.updateLastMaxID(2, srcEntryId);
        this._cache_regTextOwnerships.add(new RegTextOwnership((Long)srcEntryId, srcId));
        this.recCategory[asNewRecord ? 0 : 1].add(refRecIndex);
    }

    public String[] getRegTextQueryParam() {
        return this._cache_TextToRefRecIndex.keySet().toArray(new String[0]);
    }

    private void updateExistingRegTextId(boolean asNewRecord, long textId, Collection<Integer> srcRecIndex) {
        if (srcRecIndex != null) {
            for (Integer idx : srcRecIndex) {
                this._regTextOwnerships[idx].setRegTextId(textId);
            }
            this._regTextInfos.computeIfAbsent(textId, v -> new RegistedTextInfoModel(textId)).addRefCount(srcRecIndex.size()).setNewRec(asNewRecord);
        }
    }

    public void updateExistingRegTextId(long textId, String text) {
        text = text.trim();
        this.updateExistingRegTextId(false, textId, (Collection<Integer>)this._cache_TextToRefRecIndex.remove(text));
        this.needUpdateRefCntTextIds.add(textId);
    }

    private void updateNewRegTextId(Function<Integer, long[]> idGenerator) {
        this._cache_NewTextProcList = new LinkedList<Object[]>();
        HashSet<Long> removeSrcEntryIds = new HashSet<Long>();
        if (this.needCheckExistSrcEntryIds == null) {
            this.needCheckExistSrcEntryIds = new HashSet<Long>(this._regTextOwnershipsIndex.size() - removeSrcEntryIds.size());
        } else {
            this.needUpdateRefCntTextIds.clear();
        }
        if (!this._cache_TextToRefRecIndex.isEmpty()) {
            long[] textIdCache = idGenerator.apply(this._cache_TextToRefRecIndex.size());
            int textIndex = 0;
            Date currentDate = new Date(System.currentTimeMillis());
            for (Map.Entry<String, List<Integer>> en : this._cache_TextToRefRecIndex.entrySet()) {
                long textId = textIdCache[textIndex++];
                this.updateExistingRegTextId(true, textId, (Collection<Integer>)en.getValue());
                this._cache_NewTextProcList.add(new Object[]{textId, this.orgId, this.periodId, en.getKey(), currentDate, en.getValue().size()});
                for (Integer idx : en.getValue()) {
                    removeSrcEntryIds.add(this._regTextOwnerships[idx].getId());
                }
            }
        }
        this._regTextOwnershipsIndex.keySet().forEach(k -> this.needCheckExistSrcEntryIds.add((Long)k));
    }

    public List<Object[]> getInsertNewRegTextParamList() {
        return this._cache_NewTextProcList;
    }

    public List<Long> getNeedUpdateRefCntTextIds() {
        return this.needUpdateRefCntTextIds;
    }

    public Long[] getNeedCheckExistSrcEntryIds() {
        return this.needCheckExistSrcEntryIds.toArray(new Long[0]);
    }

    public void addInvalidedOwnerEntryTextRefCnt(long ownerEntryId, long textID) {
        Integer index = this._regTextOwnershipsIndex.get(ownerEntryId);
        if (index != null) {
            if (this._regTextOwnerships[index].getRegTextId() != textID) {
                this.recCategory[1].add(index);
            } else {
                this.recCategory[2].add(index);
            }
        }
    }

    public Long[] getDeleteTextRefOwnerShipSQLParams() {
        HashSet<Integer> excludedRecIndexes = new HashSet<Integer>(this.recCategory[2]);
        HashSet<Long> ids = new HashSet<Long>(this.recCategory[1].size());
        for (Integer idx : this.recCategory[1]) {
            if (excludedRecIndexes.contains(idx)) continue;
            ids.add(this._regTextOwnerships[idx].getId());
        }
        return ids.toArray(new Long[0]);
    }

    public List<Object[]> getInsertTextRefOwnerShipSQLParams() {
        RegTextOwnership ownership;
        long id;
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        HashSet<Long> idSet = new HashSet<Long>(this.recCategory[0].size() + this.recCategory[1].size());
        HashSet<Integer> excludedRecIndexes = new HashSet<Integer>(this.recCategory[2]);
        for (Integer idx : this.recCategory[0]) {
            if (excludedRecIndexes.contains(idx) || idSet.contains(id = (ownership = this._regTextOwnerships[idx]).getId())) continue;
            idSet.add(id);
            result.add(new Object[]{id, ownership.getRegTextId(), ownership.getOwnerRecId()});
        }
        for (Integer idx : this.recCategory[1]) {
            if (excludedRecIndexes.contains(idx) || idSet.contains(id = (ownership = this._regTextOwnerships[idx]).getId())) continue;
            idSet.add(id);
            result.add(new Object[]{id, ownership.getRegTextId(), ownership.getOwnerRecId()});
        }
        return result;
    }

    public void finishAddChangeRecs() {
        int size = this._cache_regTextOwnerships.size();
        if (this._regTextOwnershipsIndex == null) {
            this._regTextOwnershipsIndex = new HashMap<Long, Integer>(size);
        } else {
            this._regTextOwnershipsIndex.clear();
        }
        this._regTextOwnerships = new RegTextOwnership[size];
        int i = 0;
        Iterator<RegTextOwnership> iterator = this._cache_regTextOwnerships.iterator();
        while (iterator.hasNext()) {
            RegTextOwnership textOwnership;
            this._regTextOwnerships[i] = textOwnership = iterator.next();
            this._regTextOwnershipsIndex.put(this._regTextOwnerships[i].getId(), i);
            ++i;
        }
        this._cache_regTextOwnerships.clear();
        if (this._regTextInfos == null) {
            this._regTextInfos = new HashMap<Long, RegistedTextInfoModel>(this._cache_TextToRefRecIndex.size());
        } else {
            this._regTextInfos.clear();
        }
        if (this.needUpdateRefCntTextIds == null) {
            this.needUpdateRefCntTextIds = new LinkedList<Long>();
        } else {
            this.needUpdateRefCntTextIds.clear();
        }
    }

    public void finishUpdateTextRefID() {
        this.updateNewRegTextId(this.idGenerator);
        this._cache_TextToRefRecIndex.clear();
    }

    public void finishInsertNewRegText() {
        this._cache_NewTextProcList.clear();
    }

    public CDCTaskStatus finishContextProcessing(CDCTaskStatus outputStatus) {
        outputStatus.increaseLast_cdc_id(this._cache_max_Ids[0]);
        outputStatus.increaseLast_max_srcId(this._cache_max_Ids[1]);
        outputStatus.increaseLast_max_srcEntryId(this._cache_max_Ids[2]);
        return outputStatus;
    }

    public boolean updateLastMaxID(int type, long newMaxID) {
        if (newMaxID > this._cache_max_Ids[type]) {
            this._cache_max_Ids[type] = newMaxID;
            return true;
        }
        return false;
    }

    public boolean updateLastMaxCDCId(long newMaxID) {
        return this.updateLastMaxID(0, newMaxID);
    }

    public long getLastMaxID(int type) {
        return this._cache_max_Ids[type];
    }

    public void reset() {
        this._cache_regTextOwnerships.clear();
        this._regTextOwnerships = null;
        if (this._regTextOwnershipsIndex != null) {
            this._regTextOwnershipsIndex.clear();
        }
        if (this._cache_regTextOwnerships != null) {
            this._cache_regTextOwnerships.clear();
        }
        if (this._regTextInfos != null) {
            this._regTextInfos.clear();
        }
        if (this._cache_TextToRefRecIndex != null) {
            this._cache_TextToRefRecIndex.clear();
        }
        if (this._cache_NewTextProcList != null) {
            this._cache_NewTextProcList.clear();
        }
        if (this.needUpdateRefCntTextIds != null) {
            this.needUpdateRefCntTextIds.clear();
        }
        if (this.needCheckExistSrcEntryIds != null) {
            this.needCheckExistSrcEntryIds.clear();
        }
        if (this.recCategory != null) {
            for (List<Integer> list : this.recCategory) {
                if (list == null) continue;
                list.clear();
            }
        }
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    protected void test1() {
        int i;
        for (i = 1; i <= 10; ++i) {
            this.addNewVoucherTextProcRec(i % 2 == 0, i, i * 10, "Text-" + i);
        }
        System.out.println("RegTextQueryParam = " + Arrays.toString(this.getRegTextQueryParam()));
        System.out.println("New Add Records: " + this.recCategory[0]);
        System.out.println("Need to Delete Records: " + this.recCategory[1]);
        System.out.println("Need to Exclude Entry Records: " + this.recCategory[2]);
        this.finishAddChangeRecs();
        for (i = 0; i <= 10; i += 3) {
            this.updateExistingRegTextId(i * 100, "Text-" + i);
        }
        this.finishUpdateTextRefID();
        System.out.println("New Add Records: " + this.recCategory[0]);
        System.out.println("Need to Delete Records: " + this.recCategory[1]);
        System.out.println("Need to Exclude Entry Records: " + this.recCategory[2]);
        List<Object[]> insertRegText = this.getInsertNewRegTextParamList();
        StringBuilder builder = new StringBuilder();
        for (Object[] objs : insertRegText) {
            builder.append("\t").append(Arrays.deepToString(objs)).append("\n");
        }
        System.out.println("Insert Reg Text = \n" + builder);
        this.finishInsertNewRegText();
        System.out.println("Query Existing OwnerShip: Src EntryIds = " + Arrays.toString((Object[])this.getNeedCheckExistSrcEntryIds()));
        System.out.println("Query Changed OwnerShip Filter = \n" + builder);
        this.addInvalidedOwnerEntryTextRefCnt(9000L, 2L);
        this.addInvalidedOwnerEntryTextRefCnt(9004L, 4L);
        builder.setLength(0);
        for (Object[] param : this.getInsertTextRefOwnerShipSQLParams()) {
            builder.append("\n\t").append(Arrays.deepToString(param));
        }
        System.out.println("Insert Text Ref OwnerShip SQL Params: " + builder);
    }

    public static void main(String[] args) {
        VoucherTextProcContext context = new VoucherTextProcContext(99L, 20220906L, idGenCnt -> {
            long[] result = new long[idGenCnt.intValue()];
            for (int i = 0; i < idGenCnt; ++i) {
                result[i] = i + 9000;
            }
            return result;
        });
        for (int i = 0; i < 3; ++i) {
            context.test1();
            context.reset();
        }
    }
}

