/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.muldims;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.fi.bd.model.muldims.AbstractDimTreeNode;

public abstract class AbstractDimTree<DIM_KEY, TREE_NODE extends AbstractDimTreeNode<DIM_KEY, TREE_NODE>> {
    protected final DIM_KEY wildcardDimKey;
    protected DIM_KEY key;
    protected Map<DIM_KEY, TREE_NODE> childNodes;
    protected TREE_NODE wildcardNode;
    protected Map<String, Integer> dimNameIndexMap;
    public static final int DefaultHashSize = 4;

    public AbstractDimTree(DIM_KEY treeKey, DIM_KEY wildcardDimKey) {
        this(treeKey, wildcardDimKey, null);
    }

    public AbstractDimTree(DIM_KEY treeKey, DIM_KEY wildcardDimKey, String[] dimNames) {
        this.wildcardDimKey = wildcardDimKey;
        this.key = treeKey;
        this.dimNameIndexMap = new LinkedHashMap<String, Integer>(4);
        this.childNodes = new HashMap<DIM_KEY, TREE_NODE>(4);
        if (dimNames != null && dimNames.length > 0) {
            int i = 0;
            for (String dimName : dimNames) {
                this.dimNameIndexMap.put(dimName, i++);
            }
        }
    }

    public String toString() {
        return "AbstractDimTree{key=" + this.key + ", dimNameIndexMap=" + this.dimNameIndexMap + ", wildcardNode=" + this.wildcardNode + ", childNodes=" + this.childNodes + '}';
    }

    public abstract TREE_NODE createTreeNode(DIM_KEY var1);

    public TREE_NODE addNestNode(DIM_KEY[] nestNodePath) {
        return this.addNestNode(Arrays.asList(nestNodePath));
    }

    public TREE_NODE addNestNode(Collection<DIM_KEY> nestNodePath) {
        if (nestNodePath == null || nestNodePath.isEmpty()) {
            return null;
        }
        AbstractDimTreeNode childNode = null;
        boolean firstLevel = true;
        for (DIM_KEY dimKey : nestNodePath) {
            boolean _isWildcardKey = this.wildcardDimKey.equals(dimKey);
            if (firstLevel) {
                firstLevel = false;
                if (_isWildcardKey) {
                    TREE_NODE TREE_NODE;
                    if (this.wildcardNode != null) {
                        TREE_NODE = this.wildcardNode;
                    } else {
                        TREE_NODE = this.createTreeNode(dimKey);
                        this.wildcardNode = this.wildcardNode;
                    }
                    childNode = TREE_NODE;
                } else {
                    childNode = this.childNodes.computeIfAbsent(dimKey, key -> this.createTreeNode(key));
                }
            } else {
                Object childNode_buf = childNode.getChild(dimKey, _isWildcardKey);
                if (childNode_buf == null) {
                    childNode_buf = this.createTreeNode(dimKey);
                    childNode.addChildNode(childNode_buf, _isWildcardKey);
                }
                childNode = childNode_buf;
            }
            if (childNode != null) continue;
            throw new IllegalArgumentException("Create createTreeNode Failed: " + dimKey);
        }
        return (TREE_NODE)childNode;
    }

    public TREE_NODE addNestNode(Map<String, DIM_KEY> nestNodeMap, boolean wildcardForMissingDim) {
        if (nestNodeMap == null || nestNodeMap.isEmpty() || this.childNodes.isEmpty()) {
            return null;
        }
        ArrayList<String> dimNameBufList = new ArrayList<String>(this.dimNameIndexMap.size());
        for (Map.Entry<String, Integer> en : this.dimNameIndexMap.entrySet()) {
            dimNameBufList.set(en.getValue(), en.getKey());
        }
        LinkedList<DIM_KEY> nodeDimKeyBufList = new LinkedList<DIM_KEY>();
        for (String dimName : dimNameBufList) {
            DIM_KEY nodeKeyBuf = nestNodeMap.get(dimName);
            if (nodeKeyBuf == null) {
                if (!wildcardForMissingDim) break;
                nodeKeyBuf = this.wildcardDimKey;
            }
            nodeDimKeyBufList.add(nodeKeyBuf);
        }
        return this.addNestNode(nodeDimKeyBufList);
    }

    public boolean hasChild(DIM_KEY ... nodePath) {
        return this.hasChild(Arrays.asList(nodePath));
    }

    public boolean hasChild(List<DIM_KEY> nodePath) {
        if (nodePath == null || this.childNodes.isEmpty()) {
            return false;
        }
        int pathLength = nodePath.size();
        if (pathLength > 1) {
            AbstractDimTreeNode childNode = (AbstractDimTreeNode)this.childNodes.get(nodePath.get(0));
            if (childNode != null) {
                return childNode.containNestChild(nodePath.subList(1, nodePath.size()));
            }
        } else if (pathLength == 1) {
            return this.childNodes.containsKey(nodePath.get(0));
        }
        return false;
    }

    public void matchChild(Consumer<Collection<TREE_NODE>> matchProceesor, DIM_KEY ... nodePath) {
        boolean hasNextLevel;
        int pathLength;
        if (nodePath == null || (pathLength = nodePath.length) <= 0) {
            return;
        }
        DIM_KEY currentLevelDimKey = nodePath[0];
        boolean bl = hasNextLevel = pathLength > 1;
        if (this.wildcardNode != null) {
            if (hasNextLevel) {
                ((AbstractDimTreeNode)this.wildcardNode).matchChild(matchProceesor, 1, nodePath);
            } else {
                matchProceesor.accept(Collections.singletonList(this.wildcardNode));
            }
        }
        if (this.wildcardDimKey.equals(currentLevelDimKey)) {
            if (hasNextLevel) {
                for (AbstractDimTreeNode childNode : this.childNodes.values()) {
                    childNode.matchChild(matchProceesor, 1, nodePath);
                }
            } else {
                matchProceesor.accept(this.childNodes.values());
            }
        } else {
            AbstractDimTreeNode childNode = (AbstractDimTreeNode)this.childNodes.get(currentLevelDimKey);
            if (childNode != null) {
                if (hasNextLevel) {
                    childNode.matchChild(matchProceesor, 1, nodePath);
                } else {
                    matchProceesor.accept(Collections.singletonList(childNode));
                }
            }
        }
    }

    public List<TREE_NODE> getChildEx(DIM_KEY ... nodePath) {
        boolean hasNextLevel;
        int pathLength;
        LinkedList<Object> foundList = new LinkedList<Object>();
        if (nodePath == null || (pathLength = nodePath.length) <= 0) {
            return foundList;
        }
        DIM_KEY currentLevelDimKey = nodePath[0];
        boolean bl = hasNextLevel = pathLength > 1;
        if (this.wildcardNode != null) {
            if (hasNextLevel) {
                foundList.addAll(((AbstractDimTreeNode)this.wildcardNode).getNestChildEx(1, nodePath));
            } else {
                foundList.add(this.wildcardNode);
            }
        }
        if (this.wildcardDimKey.equals(currentLevelDimKey)) {
            if (hasNextLevel) {
                for (AbstractDimTreeNode childNode : this.childNodes.values()) {
                    foundList.addAll(childNode.getNestChildEx(1, nodePath));
                }
            } else {
                foundList.addAll(this.childNodes.values());
            }
        } else {
            AbstractDimTreeNode childNode = (AbstractDimTreeNode)this.childNodes.get(currentLevelDimKey);
            if (childNode != null) {
                if (hasNextLevel) {
                    foundList.addAll(childNode.getNestChildEx(1, nodePath));
                } else {
                    foundList.add(childNode);
                }
            }
        }
        return foundList;
    }

    public List<TREE_NODE> getChild(DIM_KEY ... nodePath) {
        LinkedList foundList = new LinkedList();
        this.matchChild(foundNodes -> foundList.addAll(foundNodes), nodePath);
        return foundList;
    }

    public void clear() {
        this.wildcardNode = null;
        this.childNodes.clear();
    }

    public DIM_KEY getWildcardDimKey() {
        return this.wildcardDimKey;
    }

    public DIM_KEY getKey() {
        return this.key;
    }

    public void setKey(DIM_KEY key) {
        this.key = key;
    }
}

