/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.model.muldims;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class AbstractDimTreeNode<K, NODE extends AbstractDimTreeNode<K, NODE>>
implements Serializable {
    protected K key;
    protected final K wildcardDimKey;
    protected Map<K, NODE> childNodes;
    protected NODE wildcardNode;
    protected boolean hasChild;

    public AbstractDimTreeNode(K nodeKey, K wildcardDimKey) {
        this.key = nodeKey;
        this.wildcardDimKey = wildcardDimKey;
        this.childNodes = new HashMap<K, NODE>(4);
        this.hasChild = false;
    }

    public String toString() {
        return "AbstractDimTreeNode{key=" + this.key + ", wildcardNode=" + this.wildcardNode + ", childNodes=" + this.childNodes + '}';
    }

    public int addChilds(NODE ... childs) {
        if (childs == null || childs.length <= 0) {
            return 0;
        }
        int addCnt = 0;
        for (NODE node : childs) {
            this.addChildNode(node, false);
            ++addCnt;
        }
        return addCnt;
    }

    public NODE addChildNode(NODE childNode, boolean asWildcardNode) {
        if (childNode != null) {
            if (asWildcardNode) {
                this.wildcardNode = childNode;
            } else {
                this.childNodes.put(((AbstractDimTreeNode)childNode).getKey(), childNode);
            }
            this.hasChild = true;
        }
        return childNode;
    }

    public boolean containChild(K key) {
        return this.wildcardNode != null || this.childNodes.containsKey(key);
    }

    public void clear() {
        this.childNodes.clear();
    }

    public boolean hasChild() {
        return this.hasChild;
    }

    public NODE getChild(K nodeKey, boolean asWildcardNode) {
        return (NODE)(asWildcardNode ? this.wildcardNode : (AbstractDimTreeNode)this.childNodes.get(nodeKey));
    }

    public List<NODE> getNestChild(K ... nodePath) {
        LinkedList foundList = new LinkedList();
        this.matchChild(foundNodes -> foundList.addAll(foundNodes), 0, nodePath);
        return foundList;
    }

    public List<NODE> getNestChildEx(int currentLevel, K ... nodePath) {
        int pathLength;
        LinkedList<Object> foundList = new LinkedList<Object>();
        if (nodePath == null || currentLevel < 0 || (pathLength = nodePath.length) <= 0) {
            return foundList;
        }
        boolean hasNextLevel = pathLength - currentLevel > 1;
        K currentLevelDimKey = nodePath[currentLevel];
        if (this.wildcardNode != null || this.hasChild) {
            if (this.wildcardNode != null) {
                if (hasNextLevel) {
                    foundList.addAll(((AbstractDimTreeNode)this.wildcardNode).getNestChildEx(currentLevel + 1, nodePath));
                } else {
                    foundList.add(this.wildcardNode);
                }
            }
            if (this.wildcardDimKey.equals(currentLevelDimKey)) {
                if (hasNextLevel) {
                    for (AbstractDimTreeNode childNode : this.childNodes.values()) {
                        foundList.addAll(childNode.getNestChildEx(currentLevel + 1, nodePath));
                    }
                } else {
                    foundList.addAll(this.childNodes.values());
                }
            } else {
                AbstractDimTreeNode childNode = (AbstractDimTreeNode)this.childNodes.get(currentLevelDimKey);
                if (childNode != null) {
                    if (hasNextLevel) {
                        foundList.addAll(childNode.getNestChildEx(currentLevel + 1, nodePath));
                    } else {
                        foundList.add(childNode);
                    }
                }
            }
        }
        return foundList;
    }

    public void matchChild(Consumer<Collection<NODE>> matchProceesor, int currentLevel, K ... nodePath) {
        int pathLength;
        if (nodePath == null || currentLevel < 0 || (pathLength = nodePath.length) <= 0) {
            return;
        }
        boolean hasNextLevel = pathLength - currentLevel > 1;
        K currentLevelDimKey = nodePath[currentLevel];
        if (this.wildcardNode != null || this.hasChild) {
            if (this.wildcardNode != null) {
                if (hasNextLevel) {
                    ((AbstractDimTreeNode)this.wildcardNode).matchChild(matchProceesor, currentLevel + 1, nodePath);
                } else {
                    matchProceesor.accept(Collections.singletonList(this.wildcardNode));
                }
            }
            if (this.wildcardDimKey.equals(currentLevelDimKey)) {
                if (hasNextLevel) {
                    for (AbstractDimTreeNode childNode : this.childNodes.values()) {
                        childNode.matchChild(matchProceesor, currentLevel + 1, nodePath);
                    }
                } else {
                    matchProceesor.accept(this.childNodes.values());
                }
            } else {
                AbstractDimTreeNode childNode = (AbstractDimTreeNode)this.childNodes.get(currentLevelDimKey);
                if (childNode != null) {
                    if (hasNextLevel) {
                        childNode.matchChild(matchProceesor, currentLevel + 1, nodePath);
                    } else {
                        matchProceesor.accept(Collections.singletonList(childNode));
                    }
                }
            }
        }
    }

    public boolean containNestChild(K ... nodePath) {
        return this.containNestChild(Arrays.asList(nodePath));
    }

    public boolean containNestChild(List<K> nodePath) {
        List<K> childNodePath;
        int pathLength;
        if (nodePath == null || (pathLength = nodePath.size()) <= 0 || this.wildcardNode == null && this.hasChild) {
            return false;
        }
        K currentLevelDimKey = nodePath.get(0);
        List<K> list = childNodePath = pathLength > 1 ? nodePath.subList(1, nodePath.size()) : null;
        if (this.wildcardNode != null) {
            return childNodePath != null ? ((AbstractDimTreeNode)this.wildcardNode).containNestChild(childNodePath) : true;
        }
        AbstractDimTreeNode childNode = (AbstractDimTreeNode)this.childNodes.get(currentLevelDimKey);
        if (childNode != null) {
            return childNodePath != null ? childNode.containNestChild(childNodePath) : true;
        }
        return false;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public Map<K, ? extends AbstractDimTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(Map<K, NODE> childNodes) {
        this.childNodes = childNodes;
    }

    public NODE getWildcardNode() {
        return this.wildcardNode;
    }

    public void setWildcardNode(NODE wildcardNode) {
        this.wildcardNode = wildcardNode;
    }
}

